/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.network.server.RemovePositionFromSSS;
import net.geforcemods.securitycraft.screen.components.SSSConnectionList;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class SSSItemScreen
extends Screen
implements SSSConnectionList.ConnectionAccessor {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final ItemStack stack;
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private SSSConnectionList<SSSItemScreen> connectionList;

    public SSSItemScreen(ItemStack stack) {
        super((Component)Utils.localize(((SonicSecuritySystemItem)((Object)SCContent.SONIC_SECURITY_SYSTEM_ITEM.get())).getDescriptionId(), new Object[0]));
        this.stack = stack.getItem() instanceof SonicSecuritySystemItem ? stack : ItemStack.EMPTY;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.connectionList = (SSSConnectionList)this.addRenderableWidget((GuiEventListener)new SSSConnectionList<SSSItemScreen>(this, this.minecraft, this.imageWidth - 24, this.imageHeight - 40, this.topPos + 20, this.leftPos + 12));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int textWidth = this.font.width((FormattedText)this.title);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.imageWidth / 2 - textWidth / 2, this.topPos + 6, 0x404040, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public Set<BlockPos> getPositions() {
        return SonicSecuritySystemItem.stackTagToBlockPosSet(this.stack.getTag());
    }

    @Override
    public void removePosition(BlockPos pos) {
        SonicSecuritySystemItem.removeLinkedBlock(this.stack.getTag(), pos);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new RemovePositionFromSSS(pos)});
        this.connectionList.refreshPositions();
    }
}

