/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.inventory.TrophySystemMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.screen.components.ToggleScrollList;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TrophySystemScreen
extends AbstractContainerScreen<TrophySystemMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/trophy_system.png");
    public final Component scrollListTitle;
    public final Component smartModuleTooltip;
    private boolean hasSmartModule;
    private boolean hasRedstoneModule;
    private TrophySystemBlockEntity be;
    private ToggleScrollList<EntityType<?>> scrollList;

    public TrophySystemScreen(TrophySystemMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 248;
        this.be = menu.be;
        this.hasSmartModule = this.be.isModuleEnabled(ModuleType.SMART);
        this.hasRedstoneModule = this.be.isModuleEnabled(ModuleType.REDSTONE);
        this.scrollListTitle = Utils.localize("gui.securitycraft:trophy_system.targetableProjectiles", new Object[0]);
        this.smartModuleTooltip = this.hasSmartModule ? Utils.localize("gui.securitycraft:trophy_system.toggle", new Object[0]) : Utils.localize("gui.securitycraft:trophy_system.moduleRequired", new Object[0]);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = this.imageHeight - 94;
        this.titleLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2;
        this.scrollList = (ToggleScrollList)this.addRenderableWidget((GuiEventListener)new ToggleScrollList(this.be, this.hasSmartModule, this.hasRedstoneModule, this.minecraft, this.imageWidth - 24, 106, this.topPos + 40, this.leftPos + 12));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.minecraft.player.isSpectator()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrollList != null && this.scrollList.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        ClientUtils.renderModuleInfo(guiGraphics, this.font, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, mouseX, mouseY);
    }

    public void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.scrollListTitle, this.imageWidth / 2 - this.font.width((FormattedText)this.scrollListTitle) / 2, 31, 0x404040, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

