/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import org.apache.commons.lang3.StringUtils;

public class ColorChooser
extends Screen
implements GuiEventListener,
NarratableEntry {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/color_chooser.png");
    private static final ResourceLocation HUE_SLIDER_SPRITE = new ResourceLocation("securitycraft", "widget/color_chooser/hue_slider");
    private static final ResourceLocation HUE_SLIDER_HIGHLIGHTED_SPRITE = new ResourceLocation("securitycraft", "widget/color_chooser/hue_slider_highlighted");
    private static final ResourceLocation FIELD_SELECTOR_SPRITE = new ResourceLocation("securitycraft", "widget/color_chooser/field_selector");
    private static final ResourceLocation FIELD_SELECTOR_HIGHLIGHTED_SPRITE = new ResourceLocation("securitycraft", "widget/color_chooser/field_selector_highlighted");
    private static final int COLOR_FIELD_SIZE = 75;
    protected boolean disabled = true;
    private final int xStart;
    private final int yStart;
    private final List<Rect2i> extraAreas = new ArrayList<Rect2i>();
    private final Component rText = Component.literal((String)"R");
    private final Component gText = Component.literal((String)"G");
    private final Component bText = Component.literal((String)"B");
    private final Component rgbHexText = Component.literal((String)"#");
    private boolean clickedInDragRegion = false;
    private float h;
    private float s;
    private float b;
    private int colorFieldTop;
    private int colorFieldBottom;
    private int colorFieldLeft;
    private int colorFieldRight;
    private final HoverChecker colorFieldHoverChecker;
    private float selectionX;
    private float selectionY;
    private final int rgbColor;
    private ColorEditBox rBox;
    private ColorEditBox gBox;
    private ColorEditBox bBox;
    private ColorEditBox rgbHexBox;
    private HueSlider hueSlider;

    public ColorChooser(Component title, int xStart, int yStart, int rgbColor) {
        super(title);
        this.xStart = xStart;
        this.yStart = yStart;
        this.colorFieldLeft = xStart + 6;
        this.colorFieldTop = yStart + 6;
        this.colorFieldRight = this.colorFieldLeft + 75;
        this.colorFieldBottom = this.colorFieldTop + 75;
        this.rgbColor = rgbColor;
        this.colorFieldHoverChecker = new HoverChecker(this.colorFieldTop, this.colorFieldBottom, this.colorFieldLeft, this.colorFieldRight);
    }

    protected void init() {
        Predicate<String> boxFilter = string -> string.isEmpty() || StringUtils.isNumeric((CharSequence)string);
        Function<EditBox, Consumer> boxResponder = box -> string -> {
            if (!string.isEmpty()) {
                int number = Integer.parseInt(string);
                ToIntFunction<EditBox> parsingFunction = editBox -> {
                    if (editBox.getValue().isEmpty()) {
                        return 0;
                    }
                    return Integer.parseInt(editBox.getValue());
                };
                if (number < 0) {
                    box.setValue("0");
                } else if (number > 255) {
                    box.setValue("255");
                }
                this.updateHSBValues(parsingFunction.applyAsInt(this.rBox), parsingFunction.applyAsInt(this.gBox), parsingFunction.applyAsInt(this.bBox));
                this.updateTextFields((EditBox)box);
                this.onColorChange();
            }
        };
        int red = this.rgbColor >> 16 & 0xFF;
        int green = this.rgbColor >> 8 & 0xFF;
        int blue = this.rgbColor & 0xFF;
        this.updateHSBValues(red, green, blue);
        this.extraAreas.add(new Rect2i(this.xStart, this.yStart, 144, 108));
        this.hueSlider = (HueSlider)this.addRenderableWidget((GuiEventListener)new HueSlider(this.colorFieldLeft - 2, this.yStart + 85, 82, 20, (double)this.h * 360.0){

            protected void applyValue() {
                ColorChooser.this.h = (float)this.getValueInt() / 360.0f;
                ColorChooser.this.updateTextFields(null);
                ColorChooser.this.onColorChange();
            }
        });
        this.rBox = (ColorEditBox)this.addRenderableWidget((GuiEventListener)new ColorEditBox(this.font, this.colorFieldRight + 13, this.colorFieldTop, 26, 10, this.rText));
        this.gBox = (ColorEditBox)this.addRenderableWidget((GuiEventListener)new ColorEditBox(this.font, this.colorFieldRight + 13, this.colorFieldTop + 15, 26, 10, this.gText));
        this.bBox = (ColorEditBox)this.addRenderableWidget((GuiEventListener)new ColorEditBox(this.font, this.colorFieldRight + 13, this.colorFieldTop + 30, 26, 10, this.bText));
        this.rgbHexBox = (ColorEditBox)this.addRenderableWidget((GuiEventListener)new ColorEditBox(this.font, this.colorFieldRight + 13, this.colorFieldTop + 45, 46, 10, this.rgbHexText));
        this.rBox.setValue("" + red);
        this.gBox.setValue("" + green);
        this.bBox.setValue("" + blue);
        this.getRgbHexBox().setValue(Integer.toHexString(this.rgbColor).substring(2));
        this.rBox.setMaxLength(3);
        this.gBox.setMaxLength(3);
        this.bBox.setMaxLength(3);
        this.getRgbHexBox().setMaxLength(6);
        this.rBox.setFilter(boxFilter);
        this.gBox.setFilter(boxFilter);
        this.bBox.setFilter(boxFilter);
        this.getRgbHexBox().setFilter(string -> string.matches("[0-9a-fA-F]*"));
        this.rBox.setResponder(boxResponder.apply(this.rBox));
        this.gBox.setResponder(boxResponder.apply(this.gBox));
        this.bBox.setResponder(boxResponder.apply(this.bBox));
        this.getRgbHexBox().setResponder(string -> {
            if (!string.isEmpty()) {
                int hexColor = Integer.parseInt(string, 16);
                this.updateHSBValues(hexColor >> 16 & 0xFF, hexColor >> 8 & 0xFF, hexColor & 0xFF);
                this.updateTextFields(this.getRgbHexBox());
                this.onColorChange();
            }
        });
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.disabled) {
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.blitSprite(this.colorFieldHoverChecker.checkHover(mouseX, mouseY) ? FIELD_SELECTOR_HIGHLIGHTED_SPRITE : FIELD_SELECTOR_SPRITE, (int)this.selectionX - 1, (int)this.selectionY - 1, 3, 3);
            guiGraphics.drawString(this.font, this.rText, this.colorFieldRight + 5, this.colorFieldTop + 1, 0x404040, false);
            guiGraphics.drawString(this.font, this.gText, this.colorFieldRight + 5, this.colorFieldTop + 16, 0x404040, false);
            guiGraphics.drawString(this.font, this.bText, this.colorFieldRight + 5, this.colorFieldTop + 31, 0x404040, false);
            guiGraphics.drawString(this.font, this.rgbHexText, this.colorFieldRight + 5, this.colorFieldTop + 46, 0x404040, false);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(TEXTURE, this.xStart, this.yStart, 0, 0, 145, 109);
        ClientUtils.fillHorizontalGradient(guiGraphics, 0, this.colorFieldLeft, this.colorFieldTop, this.colorFieldRight + 1, this.colorFieldBottom + 1, -1, ClientUtils.HSBtoRGB(this.h, 1.0f, 1.0f));
        guiGraphics.fillGradient(this.colorFieldLeft, this.colorFieldTop, this.colorFieldRight + 1, this.colorFieldBottom + 1, 0, -16777216);
    }

    public void tick() {
        if (!this.disabled) {
            this.validateNotEmpty(this.rBox);
            this.validateNotEmpty(this.gBox);
            this.validateNotEmpty(this.bBox);
            if (this.getRgbHexBox() != null && !this.getRgbHexBox().isFocused() && this.getRgbHexBox().getValue().isEmpty()) {
                this.getRgbHexBox().setValue("000000");
            }
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.disabled) {
            super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
            if (button == 0 && this.clickedInDragRegion) {
                this.setSelection(mouseX, mouseY);
                return true;
            }
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.disabled) {
            super.mouseClicked(mouseX, mouseY, button);
            this.clickedInDragRegion = this.colorFieldHoverChecker.checkHover(mouseX, mouseY);
            if (this.clickedInDragRegion) {
                this.setSelection(mouseX, mouseY);
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.disabled) {
            super.mouseReleased(mouseX, mouseY, button);
            this.clickedInDragRegion = false;
        }
        return false;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public List<Rect2i> getGuiExtraAreas() {
        return this.disabled ? List.of() : this.extraAreas;
    }

    public int getRGBColor() {
        return ClientUtils.HSBtoRGB(this.h, this.s, this.b);
    }

    private void setSelection(double mouseX, double mouseY) {
        this.selectionX = (int)Mth.clamp((double)mouseX, (double)this.colorFieldLeft, (double)this.colorFieldRight);
        this.selectionY = (int)Mth.clamp((double)mouseY, (double)this.colorFieldTop, (double)this.colorFieldBottom);
        this.s = (this.selectionX - (float)this.colorFieldLeft) / 75.0f;
        this.b = 1.0f - (this.selectionY - (float)this.colorFieldTop) / 75.0f;
        this.updateTextFields(null);
        this.onColorChange();
    }

    private void updateHSBValues(int red, int green, int blue) {
        float[] hsbColor = ClientUtils.RGBtoHSB(red, green, blue);
        this.h = hsbColor[0];
        this.s = hsbColor[1];
        this.b = hsbColor[2];
        this.updateSelection();
    }

    private void updateTextFields(EditBox excluded) {
        int currentRGBColor = this.getRGBColor();
        int red = currentRGBColor >> 16 & 0xFF;
        int green = currentRGBColor >> 8 & 0xFF;
        int blue = currentRGBColor & 0xFF;
        this.trySetText(excluded, this.rBox, "" + red);
        this.trySetText(excluded, this.gBox, "" + green);
        this.trySetText(excluded, this.bBox, "" + blue);
        this.trySetText(excluded, this.getRgbHexBox(), Integer.toHexString(currentRGBColor).substring(2));
    }

    private void trySetText(EditBox excluded, ColorEditBox editBox, String value) {
        if (excluded != editBox) {
            editBox.value = value;
            editBox.updateCursor();
        }
    }

    private void updateSelection() {
        this.selectionX = this.s * 75.0f + (float)this.colorFieldLeft;
        this.selectionY = -this.b * 75.0f + 75.0f + (float)this.colorFieldTop;
        if (this.hueSlider != null) {
            this.hueSlider.setValue((double)this.h * 360.0);
        }
    }

    public void onColorChange() {
    }

    private void validateNotEmpty(EditBox box) {
        if (box != null && !box.isFocused() && box.getValue().isEmpty()) {
            box.setValue("0");
        }
    }

    public ColorEditBox getRgbHexBox() {
        return this.rgbHexBox;
    }

    class HueSlider
    extends ExtendedSlider {
        public HueSlider(int x, int y, int width, int height, double currentValue) {
            super(x, y, width, height, (Component)Component.empty(), (Component)Component.empty(), 0.0, 360.0, currentValue, 1.0, 0, false);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.blitSprite(this.isHoveredOrFocused() ? HUE_SLIDER_HIGHLIGHTED_SPRITE : HUE_SLIDER_SPRITE, this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY(), 6, this.height);
        }
    }

    public class ColorEditBox
    extends EditBox {
        public ColorEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
        }

        public void updateCursor() {
            this.setCursorPosition(this.value.length());
            this.setHighlightPos(this.getCursorPosition());
        }
    }
}

