/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class BlockEntityRenderDelegate {
    private final Map<BlockEntity, DelegateRendererInfo> renderDelegates = new HashMap<BlockEntity, DelegateRendererInfo>();

    public void putDelegateFor(BlockEntity originalBlockEntity, BlockState delegateState, ItemStack stack) {
        if (this.renderDelegates.containsKey(originalBlockEntity)) {
            DelegateRendererInfo delegateInfo = this.renderDelegates.get(originalBlockEntity);
            if (delegateInfo.delegateBlockEntity.getBlockState().getBlock() == delegateState.getBlock()) {
                delegateInfo.delegateBlockEntity.setBlockState(delegateState);
                return;
            }
        }
        if (delegateState != null && delegateState.hasBlockEntity()) {
            Minecraft mc = Minecraft.getInstance();
            BlockEntity delegateBe = ((EntityBlock)delegateState.getBlock()).newBlockEntity(BlockPos.ZERO, delegateState);
            if (delegateBe != null) {
                delegateBe.setLevel((Level)mc.level);
                Utils.updateBlockEntityWithItemTag(delegateBe, stack);
                BlockEntityRenderer delegateBeRenderer = mc.getBlockEntityRenderDispatcher().getRenderer(delegateBe);
                if (delegateBeRenderer != null) {
                    this.renderDelegates.put(originalBlockEntity, new DelegateRendererInfo(delegateBe, delegateBeRenderer));
                }
            }
        }
    }

    public void removeDelegateOf(BlockEntity originalBlockEntity) {
        this.renderDelegates.remove(originalBlockEntity);
    }

    public boolean tryRenderDelegate(BlockEntity originalBlockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        DelegateRendererInfo delegateRendererInfo = this.renderDelegates.get(originalBlockEntity);
        if (delegateRendererInfo != null) {
            try {
                PoseStack copyPose = new PoseStack();
                copyPose.pushPose();
                copyPose.last().pose().mul((Matrix4fc)pose.last().pose());
                copyPose.last().normal().mul((Matrix3fc)pose.last().normal());
                delegateRendererInfo.delegateRenderer().render(delegateRendererInfo.delegateBlockEntity(), partialTicks, copyPose, buffer, combinedLight, combinedOverlay);
                copyPose.popPose();
            }
            catch (Exception e) {
                SecurityCraft.LOGGER.warn("Error when delegate-rendering {}", (Object)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)delegateRendererInfo.delegateBlockEntity().getType()));
                e.printStackTrace();
                this.removeDelegateOf(originalBlockEntity);
            }
            return true;
        }
        return false;
    }

    private record DelegateRendererInfo(BlockEntity delegateBlockEntity, BlockEntityRenderer delegateRenderer) {
    }
}

