/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Utils {
    public static final Style GRAY_STYLE = Style.EMPTY.withColor(ChatFormatting.GRAY);
    public static final Component INVENTORY_TEXT = Utils.localize("container.inventory", new Object[0]);

    private Utils() {
    }

    public static Component getFormattedCoordinates(BlockPos pos) {
        return Component.translatable((String)"messages.securitycraft:formattedCoordinates", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()});
    }

    public static MutableComponent localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            Component component;
            Object object = params[i];
            if (object instanceof Component && (object = (component = (Component)object).getContents()) instanceof TranslatableContents) {
                TranslatableContents translatableContents = (TranslatableContents)object;
                params[i] = Utils.localize(translatableContents.getKey(), translatableContents.getArgs());
                continue;
            }
            object = params[i];
            if (!(object instanceof BlockPos)) continue;
            BlockPos pos = (BlockPos)object;
            params[i] = Utils.getFormattedCoordinates(pos);
        }
        return Component.translatable((String)key, (Object[])params);
    }

    public static ResourceLocation getRegistryName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getRegistryName(Potion potion) {
        return BuiltInRegistries.POTION.getKey((Object)potion);
    }

    public static String getLanguageKeyDenotation(Object obj) {
        if (obj instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)obj;
            return Utils.getLanguageKeyDenotation(be.getBlockState().getBlock());
        }
        if (obj instanceof Block) {
            Block block = (Block)obj;
            return block.getDescriptionId().substring(6);
        }
        if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            return entity.getType().toShortString();
        }
        if (obj instanceof BlockState) {
            BlockState state = (BlockState)obj;
            return Utils.getLanguageKeyDenotation(state.getBlock());
        }
        return "";
    }

    public static void updateBlockEntityWithItemTag(BlockEntity be, ItemStack stack) {
        CompoundTag tag = BlockItem.getBlockEntityData((ItemStack)stack);
        if (tag != null) {
            CompoundTag beData = be.saveWithoutMetadata();
            CompoundTag dataCopy = beData.copy();
            beData.merge(tag);
            if (!beData.equals((Object)dataCopy)) {
                be.load(beData);
                be.setChanged();
            }
        }
    }
}

