/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.client.UpdateTeamPrecedence;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Config(modid="securitycraft", category="options")
@Mod.EventBusSubscriber(modid="securitycraft")
public class ConfigHandler {
    @Config.Name(value="codebreaker_chance")
    @Config.RangeDouble(min=-1.0, max=1.0)
    @Config.Comment(value={"The chance for the codebreaker to successfully hack a block. 0.33 is 33%. Set to a negative value to disable the codebreaker.", "Using the codebreaker when this is set to 0.0 will still damage the item, while negative values do not damage it."})
    public static double codebreakerChance = 0.33;
    @Config.Name(value="Is admin tool allowed?")
    @Config.LangKey(value="config.securitycraft:allowAdminTool")
    public static boolean allowAdminTool = true;
    @Config.Name(value="Mine(s) spawn fire when detonated?")
    @Config.LangKey(value="config.securitycraft:shouldSpawnFire")
    public static boolean shouldSpawnFire = true;
    @Config.Name(value="Craftable level 1 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard1")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard1 = true;
    @Config.Name(value="Craftable level 2 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard2")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard2 = true;
    @Config.Name(value="Craftable level 3 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard3")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard3 = true;
    @Config.Name(value="Craftable level 4 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard4")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard4 = true;
    @Config.Name(value="Craftable level 5 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard5")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard5 = true;
    @Config.Name(value="Craftable Limited Use keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftLUKeycard")
    @Config.RequiresMcRestart
    public static boolean ableToCraftLUKeycard = true;
    @Config.Name(value="Mines use a smaller explosion?")
    @Config.LangKey(value="config.securitycraft:smallerMineExplosion")
    public static boolean smallerMineExplosion = false;
    @Config.Name(value="Mines explode when broken in Creative?")
    @Config.LangKey(value="config.securitycraft:mineExplodesWhenInCreative")
    public static boolean mineExplodesWhenInCreative = true;
    @Config.Name(value="Do mines' explosions break blocks?")
    @Config.LangKey(value="config.securitycraft:mineExplosionsBreakBlocks")
    public static boolean mineExplosionsBreakBlocks = true;
    @Config.Name(value="Display a 'tip' message at spawn?")
    @Config.LangKey(value="config.securitycraft:sayThanksMessage")
    public static boolean sayThanksMessage = true;
    @Config.Name(value="Should check for updates on Github?")
    @Config.LangKey(value="config.securitycraft:checkForUpdates")
    public static boolean checkForUpdates = true;
    @Config.Name(value="Laser range:")
    @Config.LangKey(value="config.securitycraft:laserBlockRange")
    public static int laserBlockRange = 5;
    @Config.Name(value="Inventory Scanner range:")
    @Config.LangKey(value="config.securitycraft:inventoryScannerRange")
    public static int inventoryScannerRange = 3;
    @Config.Name(value="Maximum Alarm range:")
    @Config.LangKey(value="config.securitycraft:maxAlarmRange")
    @Config.RangeInt(min=1)
    public static int maxAlarmRange = 100;
    @Config.Name(value="Allow claiming unowned blocks?")
    @Config.LangKey(value="config.securitycraft:allowBlockClaim")
    public static boolean allowBlockClaim = false;
    @Config.Name(value="Darker reinforced block textures?")
    @Config.LangKey(value="config.securitycraft:reinforcedBlockTint")
    public static boolean reinforcedBlockTint = true;
    @Config.Name(value="Craftable mines?")
    @Config.LangKey(value="config.securitycraft:ableToCraftMines")
    public static boolean ableToCraftMines = true;
    @Config.Name(value="Display owner face on retinal scanner?")
    @Config.LangKey(value="config.securitycraft:retinalScannerFace")
    public static boolean retinalScannerFace = true;
    @Config.Name(value="Enable team ownership?")
    @Config.LangKey(value="config.securitycraft:enableTeamOwnership")
    public static boolean enableTeamOwnership = false;
    @Deprecated
    @Config.Name(value="Team Ownership Precedence")
    @Config.Comment(value={"This list defines in which order SecurityCraft checks teams of players to determine if they're on the same team, if \"enable_team_ownership\" is set to true. First in the list means it's checked first.", "SecurityCraft will continue checking for teams down the list until it finds a case where the players are on the same team, or the list is over. E.g. Given the default config, if FTB Teams is installed but the players do not share a team, the mod checks if the same players are on the same vanilla team.", "Removing an entry makes the mod ignore that kind of team. Valid values are \"FTB_TEAMS\" and \"VANILLA\"."})
    public static String[] teamOwnershipPrecedence = new String[]{"FTB_TEAMS", "VANILLA"};
    @Config.Name(value="Trick scanners with player heads?")
    @Config.LangKey(value="config.securitycraft:trickScannersWithPlayerHeads")
    public static boolean trickScannersWithPlayerHeads = false;
    @Config.Name(value="Prevent reinforced floor glitching?")
    @Config.LangKey(value="config.securitycraft:preventReinforcedFloorGlitching")
    public static boolean preventReinforcedFloorGlitching = false;
    @Config.Name(value="Taser damage")
    @Config.LangKey(value="config.securitycraft:taser_damage")
    @Config.RangeDouble(min=0.0)
    public static double taserDamage = 1.0;
    @Config.Name(value="Powered taser damage")
    @Config.LangKey(value="config.securitycraft:powered_taser_damage")
    @Config.RangeDouble(min=0.0)
    public static double poweredTaserDamage = 2.0;
    @Config.Name(value="Reinforced block tint color")
    @Config.RangeInt(min=0, max=0xFFFFFF)
    @Config.Comment(value={"Set the color that reinforced blocks' textures have when reinforced_block_tint is enabled. This cannot be overridden by servers, and will be applied the same to all blocks. Grayscale values look best.", "Format: 0xRRGGBB"})
    public static int reinforcedBlockTintColor = 0x999999;
    @Config.Name(value="Laser damage")
    @Config.RangeDouble(min=0.0)
    @Config.Comment(value={"Defines the damage inflicted to an entity if it passes through a laser with installed harming module. This is given in health points, meaning 2 health points = 1 heart"})
    public static double laserDamage = 10.0;
    @Config.Name(value="Incorrect Passcode Damage")
    @Config.RangeInt(min=1)
    @Config.Comment(value={"Defines the damage that a block requiring a passcode deals to the player, if the player enters an incorrect code. This only works if a harming module is installed.", "Default is two hearts of damage."})
    public static int incorrectPasscodeDamage = 4;
    @Config.Name(value="Sentry Bullet Damage")
    @Config.RangeInt(min=0)
    @Config.Comment(value={"Set the amount of damage the default Sentry bullet inflicts onto the mobs it hits. This will not affect other projectiles the Sentry can use, like arrows.", "Default is one heart."})
    public static int sentryBulletDamage = 2;
    @Config.Name(value="Sentry Attackable Entities Allowlist")
    @Config.Comment(value={"Add entities to this list that the Sentry currently does not attack, but that you want the Sentry to attack. The denylist takes priority over the allowlist."})
    public static String[] sentryAttackableEntitiesAllowlist = new String[0];
    @Config.Name(value="Sentry Attackable Entities Denylist")
    @Config.Comment(value={"Add entities to this list that the Sentry currently attacks, but that you want the Sentry to NOT attack. The denylist takes priority over the allowlist."})
    public static String[] sentryAttackableEntitiesDenylist = new String[0];
    @Config.Name(value="Reinforced Suffocation Damage")
    @Config.Comment(value={"Set the amount of damage the player receives when they are suffocating in a reinforced block. The default is two and a half hearts. If the value is set to -1, vanilla suffocation damage will be used."})
    @Config.RangeInt(min=-1)
    public static int reinforcedSuffocationDamage = 5;
    @Config.Name(value="Allow Camera Night Vision")
    @Config.Comment(value={"Set this to false to disallow players to activate night vision without having the potion effect when looking through cameras."})
    public static boolean allowCameraNightVision = true;
    @Config.Name(value="Passcode Check Cooldown")
    @Config.RangeInt(min=0, max=2000)
    @Config.Comment(value={"Defines the amount of time in milliseconds that needs to pass between two separate attempts from a player to enter a passcode."})
    public static int passcodeCheckCooldown = 250;
    @Config.Name(value="Passcode Spam Log Warning Enabled")
    @Config.Comment(value={"Set this to false to disable the log warning that is sent whenever a player tries to enter a passcode while on passcode cooldown."})
    public static boolean passcodeSpamLogWarningEnabled = true;
    @Config.Name(value="Passcode Spam Log Warning")
    @Config.Comment(value={"The warning that is sent into the server log whenever a player tries to enter a passcode while on passcode cooldown. \"%1$s\" will be replaced with the player's name, \"%2$s\" with the passcode-protected object's name and \"%3$s\" with the object's position and dimension."})
    public static String passcodeSpamLogWarning = "Player \"%1$s\" tried to enter a passcode into \"%2$s\" at position [%3$s] too quickly!";
    @Config.Name(value="Disable In-world Un-/reinforcing")
    @Config.Comment(value={"Setting this to false disables the ability of the Universal Block Reinforcer to (un-)reinforce blocks that are placed in the world."})
    public static boolean inWorldUnReinforcing = true;
    @Config.Name(value="Vanilla Tool Block Breaking")
    @Config.Comment(value={"Whether SecurityCraft's blocks should be broken using vanilla tools (axe, shovel, hoe, ...), instead of the Universal Block Remover. If set to true, this will disable the Universal Block Remover."})
    public static boolean vanillaToolBlockBreaking = true;
    @Config.Name(value="Always Drop")
    @Config.Comment(value={"Whether SecurityCraft's blocks always drop themselves no matter which tool is used. If this is set to false, the correct tool must be used for the block to drop (e.g. pickaxe for reinforced stone, or anything for reinforced dirt).", "This only applies when \"Vanilla Tool Block Breaking\" is set to true."})
    public static boolean alwaysDrop = true;
    @Config.Name(value="Debug Camera Reset Tracing")
    @Config.Comment(value={"If this debug feature is enabled, SecurityCraft will attempt to find and report mods that prevent the feature of viewing security cameras from working when they immediately reset the player's camera entity."})
    public static boolean debugCameraResetTracing = false;
    @Config.Name(value="Frame Feed Render Distance")
    @Config.RangeInt(min=2, max=32)
    @Config.Comment(value={"Set the radius in which chunks viewed in a frame camera feed should be requested from the server and rendered. If this config has a higher value than the vanilla \"Render Distance\" option or the \"view-distance\" server property, the smaller value is used instead."})
    public static int frameFeedRenderDistance = 16;
    @Config.Name(value="Frame Feed Resolution")
    @Config.RangeInt(min=1, max=16384)
    @Config.Comment(value={"Set the resolution of the Frame camera feed. This is always a square resolution. Smaller values will be less detailed, higher values may lead to diminishing returns."})
    public static int frameFeedResolution = 512;
    @Config.Name(value="Frame Feed FPS Limit")
    @Config.RangeInt(min=10, max=260)
    @Config.Comment(value={"The maximum amount of frames per second the Frame camera feed renders at. Higher values will lead to worse performance."})
    public static int frameFeedFpsLimit = 30;
    @Config.Name(value="Frame Feed Viewing Enabled")
    @Config.Comment(value={"Set this to false to disable the feature that camera feeds can be viewed in frames. While this feature is generally stable, it may also impact server performance due to loading chunks within all active frame cameras' views."})
    public static boolean frameFeedViewingEnabled = true;
    @Config.Name(value="Frame Feed View Distance")
    @Config.RangeInt(min=2, max=32)
    @Config.Comment(value={"Set the radius in which chunks viewed in a frame camera should be loaded and sent to players. If this config has a higher value than the \"view-distance\" server property or the vanilla \"Render Distance\" option of the player requesting the chunks, the smaller value is used instead."})
    public static int frameFeedViewDistance = 16;
    @Config.Name(value="Frame Feed Forceloading Limit")
    @Config.RangeInt(min=-1)
    @Config.Comment(value={"Set the limit of chunks per dimension that may be forceloaded around frame feeds. A value of 0 will prevent any frame feed from forceloading chunks. A value of -1 will allow an unlimited number of chunks to be forceloaded by frame feeds."})
    public static int frameFeedForceloadingLimit = -1;
    @Config.Name(value="Allow Breaking Non-owned Blocks")
    @Config.Comment(value={"Whether players who are not the owner of a block can still destroy it.", "This applies regardless of what \"Vanilla Tool Block Breaking\" is set to."})
    public static boolean allowBreakingNonOwnedBlocks = false;
    @Config.Name(value="Non-owned Breaking Slowdown")
    @Config.RangeDouble(min=0.0)
    @Config.Comment(value={"How much slower it should be to break a block that is not owned by the player breaking it.", "The value is calculated as the normal block breaking speed divided by the non-owned block breaking slowdown. Example: A value of 2.0 means it takes twice as long to break the block.", "This only applies when \"Allow Breaking Non-owned Blocks\" and \"Vanilla Tool Block Breaking\" are set to true."})
    public static double nonOwnedBreakingSlowdown = 1.0;
    @Deprecated
    @Config.Name(value="Taser effects")
    @Config.Comment(value={"Add effects to this list that you want the taser to inflict onto the mobs it hits. One entry corresponds to one effect, and is formatted like this:", "effect_namespace:effect_path|duration|amplifier", "Example: The entry \"minecraft:slowness|20|1\" defines slowness 1 for 1 second (20 ticks = 1 second)."})
    public static String[] taserEffectsValue = new String[]{"minecraft:weakness|200|2", "minecraft:nausea|200|2", "minecraft:slowness|200|2"};
    @Deprecated
    @Config.Name(value="Powered taser effects")
    @Config.Comment(value={"Add effects to this list that you want the powered taser to inflict onto the mobs it hits. One entry corresponds to one effect, and is formatted like this:", "effect_namespace:effect_path|duration|amplifier", "Example: The entry \"minecraft:slowness|20|1\" defines slowness 1 for 1 second (20 ticks = 1 second)."})
    public static String[] poweredTaserEffectsValue = new String[]{"minecraft:weakness|400|5", "minecraft:nausea|400|5", "minecraft:slowness|400|5"};
    @Config.Ignore
    public static final List<Supplier<PotionEffect>> TASER_EFFECTS = new ArrayList<Supplier<PotionEffect>>();
    @Config.Ignore
    public static final List<Supplier<PotionEffect>> POWERED_TASER_EFFECTS = new ArrayList<Supplier<PotionEffect>>();

    private ConfigHandler() {
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("securitycraft".equals(event.getModID())) {
            ConfigHandler.loadEffects();
            ConfigHandler.updateTeamPrecedenceFromConfigValues(teamOwnershipPrecedence);
        }
    }

    public static void loadEffects() {
        ConfigHandler.loadEffects(taserEffectsValue, TASER_EFFECTS);
        ConfigHandler.loadEffects(poweredTaserEffectsValue, POWERED_TASER_EFFECTS);
    }

    private static void loadEffects(String[] effectsValue, List<Supplier<PotionEffect>> effects) {
        effects.clear();
        for (String entry : effectsValue) {
            String[] split = entry.split("\\|");
            if (split.length != 3) {
                SecurityCraft.LOGGER.warn("Not enough information provided for effect \"{}\", skipping", (Object)entry);
                continue;
            }
            int duration = Integer.parseInt(split[1]);
            int amplifier = Integer.parseInt(split[2]);
            if (!ConfigHandler.validateValue(duration, entry) || !ConfigHandler.validateValue(amplifier, entry)) continue;
            ResourceLocation effectLocation = new ResourceLocation(split[0]);
            if (!ForgeRegistries.POTIONS.containsKey(effectLocation)) {
                SecurityCraft.LOGGER.warn("Effect \"{}\" does not exist, skipping", (Object)effectLocation);
                continue;
            }
            effects.add(() -> new PotionEffect((Potion)ForgeRegistries.POTIONS.getValue(effectLocation), duration, amplifier - 1));
        }
    }

    private static boolean validateValue(int value, String entry) {
        if (value <= 0) {
            SecurityCraft.LOGGER.warn("Value \"{}\" cannot be less than or equal to zero for entry \"{}\", skipping", (Object)value, (Object)entry);
            return false;
        }
        return true;
    }

    public static void updateTeamPrecedenceFromConfigValues(String[] precedence) {
        TeamUtils.setPrecedence(Arrays.stream(precedence).distinct().map(s -> {
            try {
                return Enum.valueOf(TeamUtils.TeamType.class, s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return TeamUtils.TeamType.NO_OP;
            }
        }).map(TeamUtils.TeamType::getTeamHandler).filter(Objects::nonNull).collect(Collectors.toList()));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            SecurityCraft.network.sendToAll((IMessage)new UpdateTeamPrecedence(precedence));
        }
    }
}

