/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.NamedBlockEntity;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blockentities.CageTrapBlockEntity;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.FloorTrapBlockEntity;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.IMSBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.IronFenceBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeyPanelBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeycardLockBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadDoorBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadFurnaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadTrapdoorBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blockentities.MotionActivatedLightBlockEntity;
import net.geforcemods.securitycraft.blockentities.PortableRadarBlockEntity;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.ProtectoBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedCauldronBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedDispenserBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedDoorBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedDropperBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedHopperBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedIronBarsBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedPistonBlockEntity;
import net.geforcemods.securitycraft.blockentities.RetinalScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.ScannerDoorBlockEntity;
import net.geforcemods.securitycraft.blockentities.ScannerTrapdoorBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.TrackMineBlockEntity;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.blockentities.ValidationOwnableBlockEntity;
import net.geforcemods.securitycraft.entity.BouncingBetty;
import net.geforcemods.securitycraft.entity.IMSBomb;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.entity.sentry.Bullet;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.itemblocks.ItemBlockCrystalQuartzSlab;
import net.geforcemods.securitycraft.itemblocks.ItemBlockCustomQuartz;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedCompressedBlocks;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedCrystalQuartzSlab;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedDirt;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedLog;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedMetals;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedPlanks;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedPrismarine;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedPurpur;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedSand;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedSandstone;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedSlabs;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedSlabs2;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedStainedBlock;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedStone;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedStoneBrick;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedWalls;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedWoodSlabs;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.DyeItemRecipe;
import net.geforcemods.securitycraft.misc.IngredientBrewingRecipe;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.geforcemods.securitycraft.misc.PartialNBTIngredient;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.BlockPocketManagerFailedActivation;
import net.geforcemods.securitycraft.network.client.InteractWithFrame;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.network.client.PlayAlarmSound;
import net.geforcemods.securitycraft.network.client.RefreshDiguisedModel;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.client.SpawnInterfaceHighlightParticle;
import net.geforcemods.securitycraft.network.client.UpdateLaserColors;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.network.client.UpdateTeamPrecedence;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.CheckBriefcasePasscode;
import net.geforcemods.securitycraft.network.server.CheckPasscode;
import net.geforcemods.securitycraft.network.server.ClearChangeDetectorServer;
import net.geforcemods.securitycraft.network.server.ClearLoggerServer;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoteControlMine;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.network.server.RemoveMineFromMRAT;
import net.geforcemods.securitycraft.network.server.RemovePositionFromSSS;
import net.geforcemods.securitycraft.network.server.RemoveSentryFromSRAT;
import net.geforcemods.securitycraft.network.server.SetBriefcasePasscodeAndOwner;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetDefaultCameraViewingDirection;
import net.geforcemods.securitycraft.network.server.SetGhostSlot;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SetListModuleData;
import net.geforcemods.securitycraft.network.server.SetPasscode;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.network.server.SetStateOnDisguiseModule;
import net.geforcemods.securitycraft.network.server.SyncAlarmSettings;
import net.geforcemods.securitycraft.network.server.SyncBlockChangeDetector;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.network.server.SyncBlockReinforcer;
import net.geforcemods.securitycraft.network.server.SyncFrame;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.network.server.SyncLaserSideConfig;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.network.server.SyncRiftStabilizer;
import net.geforcemods.securitycraft.network.server.SyncSSSSettingsOnServer;
import net.geforcemods.securitycraft.network.server.SyncSecureRedstoneInterface;
import net.geforcemods.securitycraft.network.server.SyncTENBTTag;
import net.geforcemods.securitycraft.network.server.SyncTrophySystem;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.network.server.ToggleModule;
import net.geforcemods.securitycraft.network.server.ToggleNightVision;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.recipe.CopyPositionComponentItemRecipe;
import net.geforcemods.securitycraft.recipe.LimitedUseKeycardRecipe;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.potion.PotionType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistrationHandler {
    private static List<Item> itemBlocks = new ArrayList<Item>();
    private static List<Block> blockPages = new ArrayList<Block>();
    private static Map<PageGroup, List<Block>> pageTypeBlocks = new EnumMap<PageGroup, List<Block>>(PageGroup.class);
    private static Map<PageGroup, List<ItemStack>> pageTypeStacks = new EnumMap<PageGroup, List<ItemStack>>(PageGroup.class);
    private static Map<Block, String> blocksDesignedBy = new HashMap<Block, String>();
    private static Map<Block, Supplier<Boolean>> blockConfigValues = new HashMap<Block, Supplier<Boolean>>();
    private static final Supplier<Boolean> ABLE_TO_CRAFT_MINES = () -> ConfigHandler.ableToCraftMines;

    private RegistrationHandler() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistrationHandler.registerBlock(event, SCContent.laserBlock);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.laserField);
        RegistrationHandler.registerBlock(event, SCContent.keypad);
        RegistrationHandler.registerBlock(event, (Block)SCContent.mine, ABLE_TO_CRAFT_MINES);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.mineCut);
        RegistrationHandler.registerBlock(event, SCContent.retinalScanner);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoor);
        RegistrationHandler.registerBlock(event, (Block)SCContent.fakeLava, PageGroup.NO_PAGE);
        RegistrationHandler.registerBlock(event, SCContent.bogusLavaFlowing, PageGroup.NO_PAGE);
        RegistrationHandler.registerBlock(event, (Block)SCContent.fakeWater, PageGroup.NO_PAGE);
        RegistrationHandler.registerBlock(event, SCContent.bogusWaterFlowing, PageGroup.NO_PAGE);
        RegistrationHandler.registerBlock(event, SCContent.keycardReader);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedIronTrapdoor);
        RegistrationHandler.registerBlock(event, SCContent.bouncingBetty, ABLE_TO_CRAFT_MINES);
        RegistrationHandler.registerBlock(event, SCContent.inventoryScanner);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.inventoryScannerField);
        RegistrationHandler.registerBlock(event, SCContent.trackMine, ABLE_TO_CRAFT_MINES);
        RegistrationHandler.registerBlock(event, SCContent.cageTrap);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.horizontalReinforcedIronBars);
        RegistrationHandler.registerBlock(event, SCContent.portableRadar);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedIronBars, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.keypadChest);
        RegistrationHandler.registerBlock(event, SCContent.usernameLogger);
        RegistrationHandler.registerBlock(event, SCContent.alarm);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.alarmLit);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStone, (ItemBlock)new ItemBlockReinforcedStone(SCContent.reinforcedStone), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSandstone, (ItemBlock)new ItemBlockReinforcedSandstone(SCContent.reinforcedSandstone), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedDirt, (ItemBlock)new ItemBlockReinforcedDirt(SCContent.reinforcedDirt), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCobblestone, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.electrifiedIronFenceGate);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWoodPlanks, (ItemBlock)new ItemBlockReinforcedPlanks(SCContent.reinforcedWoodPlanks), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.panicButton);
        RegistrationHandler.registerBlock(event, SCContent.frame);
        RegistrationHandler.registerBlock(event, SCContent.claymore, ABLE_TO_CRAFT_MINES);
        RegistrationHandler.registerBlock(event, SCContent.keypadFurnace);
        RegistrationHandler.registerBlock(event, SCContent.securityCamera);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsOak, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsSpruce, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsCobblestone, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsSandstone, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsBirch, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsJungle, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsAcacia, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsDarkoak, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsStone, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.electrifiedIronFence);
        RegistrationHandler.registerBlock(event, SCContent.ims, ABLE_TO_CRAFT_MINES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGlass, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStainedGlass, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedStainedGlass), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWoodSlabs, (ItemBlock)new ItemBlockReinforcedWoodSlabs(SCContent.reinforcedWoodSlabs), PageGroup.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoubleWoodSlabs);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStoneSlabs, (ItemBlock)new ItemBlockReinforcedSlabs(SCContent.reinforcedStoneSlabs), PageGroup.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoubleStoneSlabs);
        RegistrationHandler.registerBlock(event, SCContent.protecto);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.scannerDoor);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStoneBrick, (ItemBlock)new ItemBlockReinforcedStoneBrick(SCContent.reinforcedStoneBrick), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsStoneBrick, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMossyCobblestone, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBrick, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsBrick, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedNetherBrick, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsNetherBrick, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedHardenedClay, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStainedHardenedClay, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedStainedHardenedClay), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedOldLogs, (ItemBlock)new ItemBlockReinforcedLog(SCContent.reinforcedOldLogs), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedNewLogs, (ItemBlock)new ItemBlockReinforcedLog(SCContent.reinforcedNewLogs), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMetals, (ItemBlock)new ItemBlockReinforcedMetals(SCContent.reinforcedMetals), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedLapisAndCoalBlocks, (ItemBlock)new ItemBlockReinforcedCompressedBlocks(SCContent.reinforcedLapisAndCoalBlocks), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWool, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedWool), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedQuartz, (ItemBlock)new ItemBlockCustomQuartz(SCContent.reinforcedQuartz), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsQuartz, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPrismarine, (ItemBlock)new ItemBlockReinforcedPrismarine(SCContent.reinforcedPrismarine), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedRedSandstone, (ItemBlock)new ItemBlockReinforcedSandstone(SCContent.reinforcedRedSandstone), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsRedSandstone, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStoneSlabs2, (ItemBlock)new ItemBlockReinforcedSlabs2(SCContent.reinforcedStoneSlabs2), PageGroup.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoubleStoneSlabs2);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedEndStoneBricks, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedRedNetherBrick, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPurpur, (ItemBlock)new ItemBlockReinforcedPurpur(SCContent.reinforcedPurpur), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsPurpur, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedConcrete, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedConcrete), PageGroup.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.secretSignWall);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.secretSignStanding);
        RegistrationHandler.registerBlock(event, SCContent.motionActivatedLight);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedObsidian, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedNetherrack, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedEndStone, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSeaLantern, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBoneBlock, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGlassPane, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStainedGlassPanes, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedStainedGlassPanes), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCarpet, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedCarpet), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGlowstone, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSand, (ItemBlock)new ItemBlockReinforcedSand(SCContent.reinforcedSand), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGravel, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.trophySystem);
        RegistrationHandler.registerBlock(event, SCContent.crystalQuartz, (ItemBlock)new ItemBlockCustomQuartz(SCContent.crystalQuartz), PageGroup.SINGLE_ITEM);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCrystalQuartz, (ItemBlock)new ItemBlockCustomQuartz(SCContent.reinforcedCrystalQuartz), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.crystalQuartzSlab, (ItemBlock)new ItemBlockCrystalQuartzSlab(SCContent.crystalQuartzSlab), PageGroup.NO_PAGE);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.doubleCrystalQuartzSlab);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCrystalQuartzSlab, (ItemBlock)new ItemBlockReinforcedCrystalQuartzSlab(SCContent.reinforcedCrystalQuartzSlab), PageGroup.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoubleCrystalQuartzSlab);
        RegistrationHandler.registerBlock(event, SCContent.stairsCrystalQuartz, PageGroup.NO_PAGE);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsCrystalQuartz, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.blockPocketWall);
        RegistrationHandler.registerBlock(event, SCContent.blockPocketManager, "Henzoid");
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStonePressurePlate, PageGroup.PRESSURE_PLATES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWoodenPressurePlate, PageGroup.PRESSURE_PLATES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBookshelf, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWalls, (ItemBlock)new ItemBlockReinforcedWalls(SCContent.reinforcedWalls), PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStickyPiston, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPiston, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPistonHead, null, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMovingPiston, null, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedObserver, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedRedstoneLamp, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCobweb, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGrass, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSnowBlock, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedIce, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPackedIce, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMycelium, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedClay, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedNetherWartBlock, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGrassPath, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStoneButton, PageGroup.BUTTONS);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWoodenButton, PageGroup.BUTTONS);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedLever);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedHopper);
        RegistrationHandler.registerBlock(event, SCContent.projector);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.keypadDoor);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCauldron, PageGroup.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.keyPanelFloorCeilingBlock);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.keyPanelWallBlock);
        RegistrationHandler.registerBlock(event, SCContent.sonicSecuritySystem, (ItemBlock)SCContent.sonicSecuritySystemItem, PageGroup.SINGLE_ITEM);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.blockChangeDetectorFloorCeiling);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.blockChangeDetectorWall);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.sentryDisguise);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedEndRod, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWhiteGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedOrangeGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMagentaGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedLightBlueGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedYellowGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedLimeGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPinkGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGrayGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSilverGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCyanGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPurpleGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBlueGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBrownGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGreenGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedRedGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBlackGlazedTerracotta, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.riftStabilizer);
        RegistrationHandler.registerBlock(event, SCContent.displayCase);
        RegistrationHandler.registerBlock(event, (Block)SCContent.keypadTrapdoor);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedLadder, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.floorTrap);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.keycardLockFloorCeilingBlock);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.keycardLockWallBlock);
        RegistrationHandler.registerBlock(event, (Block)SCContent.scannerTrapdoor);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedDispenser, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedDropper, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedOakFence, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedNetherBrickFence, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSpruceFence, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBirchFence, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedJungleFence, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedDarkOakFence, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedAcaciaFence, PageGroup.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedOakFenceGate, PageGroup.FENCE_GATES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSpruceFenceGate, PageGroup.FENCE_GATES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBirchFenceGate, PageGroup.FENCE_GATES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedJungleFenceGate, PageGroup.FENCE_GATES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedDarkOakFenceGate, PageGroup.FENCE_GATES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedAcaciaFenceGate, PageGroup.FENCE_GATES);
        RegistrationHandler.registerBlock(event, SCContent.secureRedstoneInterface);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMagmaBlock);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSoulSand);
        RegistrationHandler.registerBlockMine(event, SCContent.stoneMine);
        RegistrationHandler.registerBlockMine(event, SCContent.dirtMine);
        RegistrationHandler.registerBlockMine(event, SCContent.cobblestoneMine);
        RegistrationHandler.registerBlockMine(event, SCContent.sandMine);
        RegistrationHandler.registerBlockMine(event, SCContent.gravelMine);
        RegistrationHandler.registerBlockMine(event, SCContent.netherrackMine);
        RegistrationHandler.registerBlockMine(event, SCContent.endStoneMine);
        RegistrationHandler.registerBlockMine(event, SCContent.goldOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.ironOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.coalOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.lapisOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.diamondOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.redstoneOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.emeraldOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.quartzOreMine);
        RegistrationHandler.registerBlock(event, SCContent.furnaceMine, ABLE_TO_CRAFT_MINES);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : itemBlocks) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Block block : blockPages) {
            SCManualItem.PAGES.add(new SCManualPage(Item.func_150898_a((Block)block), PageGroup.SINGLE_ITEM, Utils.localize(block, new Object[0]), Utils.localize("help." + block.func_149739_a().substring(5) + ".info", new Object[0]), blocksDesignedBy.getOrDefault(block, ""), false, blockConfigValues.getOrDefault(block, () -> true)));
        }
        RegistrationHandler.registerItem(event, SCContent.codebreaker);
        RegistrationHandler.registerItem(event, SCContent.reinforcedDoorItem);
        RegistrationHandler.registerItem(event, SCContent.scannerDoorItem);
        RegistrationHandler.registerItem(event, SCContent.universalBlockRemover);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl1, PageGroup.KEYCARDS, () -> ConfigHandler.ableToCraftKeycard1);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl2, PageGroup.KEYCARDS, () -> ConfigHandler.ableToCraftKeycard2);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl3, PageGroup.KEYCARDS, () -> ConfigHandler.ableToCraftKeycard3);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl4, PageGroup.KEYCARDS, () -> ConfigHandler.ableToCraftKeycard4);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl5, PageGroup.KEYCARDS, () -> ConfigHandler.ableToCraftKeycard5);
        RegistrationHandler.registerItem(event, SCContent.limitedUseKeycard, PageGroup.SINGLE_ITEM, () -> ConfigHandler.ableToCraftLUKeycard);
        RegistrationHandler.registerItem(event, SCContent.mineRemoteAccessTool);
        RegistrationHandler.registerItem(event, SCContent.sentryRemoteAccessTool);
        RegistrationHandler.registerItem(event, SCContent.incognitoMask);
        RegistrationHandler.registerItem(event, SCContent.fWaterBucket);
        RegistrationHandler.registerItem(event, SCContent.fLavaBucket);
        RegistrationHandler.registerItem(event, SCContent.universalBlockModifier);
        RegistrationHandler.registerItem(event, SCContent.redstoneModule);
        RegistrationHandler.registerItem(event, SCContent.allowlistModule);
        RegistrationHandler.registerItem(event, SCContent.denylistModule);
        RegistrationHandler.registerItem(event, SCContent.harmingModule);
        RegistrationHandler.registerItem(event, SCContent.smartModule);
        RegistrationHandler.registerItem(event, SCContent.storageModule);
        RegistrationHandler.registerItem(event, SCContent.disguiseModule);
        RegistrationHandler.registerItem(event, SCContent.speedModule);
        RegistrationHandler.registerItem(event, SCContent.wireCutters);
        RegistrationHandler.registerItem(event, SCContent.adminTool);
        RegistrationHandler.registerItem(event, SCContent.keyPanel);
        RegistrationHandler.registerItem(event, SCContent.cameraMonitor);
        RegistrationHandler.registerItem(event, SCContent.taser);
        RegistrationHandler.registerItem(event, SCContent.scManual);
        RegistrationHandler.registerItem(event, SCContent.universalOwnerChanger);
        RegistrationHandler.registerItem(event, SCContent.universalBlockReinforcerLvL1, PageGroup.BLOCK_REINFORCERS);
        RegistrationHandler.registerItem(event, SCContent.universalBlockReinforcerLvL2, PageGroup.BLOCK_REINFORCERS);
        RegistrationHandler.registerItem(event, SCContent.universalBlockReinforcerLvL3, PageGroup.BLOCK_REINFORCERS);
        RegistrationHandler.registerItem(event, SCContent.briefcase);
        RegistrationHandler.registerItem(event, SCContent.universalKeyChanger);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.taserPowered);
        RegistrationHandler.registerItem(event, SCContent.secretSignItem);
        RegistrationHandler.registerItem(event, SCContent.sentry, PageGroup.SINGLE_ITEM, () -> true, "Henzoid");
        RegistrationHandler.registerItem(event, SCContent.crystalQuartzItem);
        RegistrationHandler.registerItem(event, SCContent.keypadDoorItem);
        RegistrationHandler.registerItem(event, SCContent.portableTunePlayer);
        RegistrationHandler.registerItem(event, SCContent.keycardHolder);
        RegistrationHandler.registerItem(event, SCContent.lens);
        RegistrationHandler.registerItem(event, SCContent.keycardLock);
        RegistrationHandler.registerItem(event, SCContent.blockChangeDetectorItem);
        SecurityCraft.proxy.registerVariants();
        pageTypeBlocks.forEach((pageType, list) -> {
            if (!pageTypeStacks.containsKey(pageType)) {
                pageTypeStacks.put((PageGroup)((Object)pageType), new ArrayList());
            }
            list.stream().map(Item::func_150898_a).forEach(item -> {
                if (item != null && item.func_77614_k()) {
                    NonNullList subStacks = NonNullList.func_191196_a();
                    item.func_150895_a(item.func_77640_w(), subStacks);
                    pageTypeStacks.get(pageType).addAll((Collection<ItemStack>)subStacks);
                } else {
                    pageTypeStacks.get(pageType).add(new ItemStack(item));
                }
            });
        });
        pageTypeStacks.remove((Object)PageGroup.SINGLE_ITEM);
        pageTypeStacks.forEach((pageType, list) -> {
            pageType.setItems(Ingredient.func_193369_a((ItemStack[])list.toArray(new ItemStack[list.size()])));
            SCManualItem.PAGES.add(new SCManualPage(((ItemStack)list.get(0)).func_77973_b(), (PageGroup)((Object)pageType), Utils.localize(pageType.getTitle(), new Object[0]), Utils.localize(pageType.getSpecialInfoKey(), new Object[0]), "", !pageType.hasRecipeGrid()));
        });
        itemBlocks = null;
        blockPages = null;
        pageTypeBlocks = null;
        pageTypeStacks = null;
        blocksDesignedBy = null;
        blockConfigValues = null;
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<Block> event) {
        GameRegistry.registerTileEntity(OwnableBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:ownable"));
        GameRegistry.registerTileEntity(NamedBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:abstract"));
        GameRegistry.registerTileEntity(KeypadBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:keypad"));
        GameRegistry.registerTileEntity(LaserBlockBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:laser_block"));
        GameRegistry.registerTileEntity(CageTrapBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:cage_trap"));
        GameRegistry.registerTileEntity(KeycardReaderBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:keycard_reader"));
        GameRegistry.registerTileEntity(InventoryScannerBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:inventory_scanner"));
        GameRegistry.registerTileEntity(PortableRadarBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:portable_radar"));
        GameRegistry.registerTileEntity(SecurityCameraBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:security_camera"));
        GameRegistry.registerTileEntity(UsernameLoggerBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:username_logger"));
        GameRegistry.registerTileEntity(RetinalScannerBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:retinal_scanner"));
        GameRegistry.registerTileEntity(KeypadChestBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:keypad_chest"));
        GameRegistry.registerTileEntity(AlarmBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:alarm"));
        GameRegistry.registerTileEntity(ClaymoreBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:claymore"));
        GameRegistry.registerTileEntity(KeypadFurnaceBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:keypad_furnace"));
        GameRegistry.registerTileEntity(IMSBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:ims"));
        GameRegistry.registerTileEntity(ProtectoBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:protecto"));
        GameRegistry.registerTileEntity(CustomizableBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:customizable"));
        GameRegistry.registerTileEntity(ScannerDoorBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:scanner_door"));
        GameRegistry.registerTileEntity(SecretSignBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:secret_sign"));
        GameRegistry.registerTileEntity(MotionActivatedLightBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:motion_light"));
        GameRegistry.registerTileEntity(TrackMineBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:track_mine"));
        GameRegistry.registerTileEntity(TrophySystemBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:trophy_system"));
        GameRegistry.registerTileEntity(BlockPocketManagerBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:block_pocket_manager"));
        GameRegistry.registerTileEntity(BlockPocketBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:block_pocket"));
        GameRegistry.registerTileEntity(AllowlistOnlyBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_pressure_plate"));
        GameRegistry.registerTileEntity(ReinforcedHopperBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_hopper"));
        GameRegistry.registerTileEntity(ProjectorBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:projector"));
        GameRegistry.registerTileEntity(IronFenceBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:iron_fence"));
        GameRegistry.registerTileEntity(KeypadDoorBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:keypad_door"));
        GameRegistry.registerTileEntity(ReinforcedIronBarsBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_iron_bars"));
        GameRegistry.registerTileEntity(ReinforcedCauldronBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_cauldron"));
        GameRegistry.registerTileEntity(ReinforcedPistonBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_piston"));
        GameRegistry.registerTileEntity(ValidationOwnableBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:validation_ownable"));
        GameRegistry.registerTileEntity(KeyPanelBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:key_panel"));
        GameRegistry.registerTileEntity(SonicSecuritySystemBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:sonic_security_system"));
        GameRegistry.registerTileEntity(ReinforcedDoorBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_door"));
        GameRegistry.registerTileEntity(BlockChangeDetectorBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:block_change_detector"));
        GameRegistry.registerTileEntity(RiftStabilizerBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:rift_stabilizer"));
        GameRegistry.registerTileEntity(DisguisableBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:disguisable"));
        GameRegistry.registerTileEntity(DisplayCaseBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:display_case"));
        GameRegistry.registerTileEntity(KeypadTrapdoorBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:keypad_trapdoor"));
        GameRegistry.registerTileEntity(FloorTrapBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:floor_trap"));
        GameRegistry.registerTileEntity(KeycardLockBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:keycard_lock"));
        GameRegistry.registerTileEntity(ScannerTrapdoorBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:scanner_trapdoor"));
        GameRegistry.registerTileEntity(ReinforcedDispenserBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_dispenser"));
        GameRegistry.registerTileEntity(ReinforcedDropperBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_dropper"));
        GameRegistry.registerTileEntity(SecureRedstoneInterfaceBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:secure_redstone_interface"));
        GameRegistry.registerTileEntity(FrameBlockEntity.class, (ResourceLocation)new ResourceLocation("securitycraft:frame"));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "bouncingbetty"), 0).entity(BouncingBetty.class).name("BBetty").tracker(128, 1, true).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "imsbomb"), 3).entity(IMSBomb.class).name("IMSBomb").tracker(256, 1, true).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "securitycamera"), 4).entity(SecurityCamera.class).name("SecurityCamera").tracker(256, 20, true).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "sentry"), 5).entity(Sentry.class).name("Sentry").tracker(256, 1, true).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "bullet"), 6).entity(Bullet.class).name("SentryBullet").tracker(256, 1, true).build());
    }

    public static void registerPackets(SimpleNetworkWrapper network) {
        network.registerMessage(SetCameraPowered.Handler.class, SetCameraPowered.class, 1, Side.SERVER);
        network.registerMessage(SyncKeycardSettings.Handler.class, SyncKeycardSettings.class, 3, Side.SERVER);
        network.registerMessage(UpdateLogger.Handler.class, UpdateLogger.class, 4, Side.CLIENT);
        network.registerMessage(UpdateNBTTagOnClient.Handler.class, UpdateNBTTagOnClient.class, 5, Side.CLIENT);
        network.registerMessage(RemoteControlMine.Handler.class, RemoteControlMine.class, 8, Side.SERVER);
        network.registerMessage(ToggleNightVision.Handler.class, ToggleNightVision.class, 9, Side.SERVER);
        network.registerMessage(SetPasscode.Handler.class, SetPasscode.class, 12, Side.SERVER);
        network.registerMessage(CheckPasscode.Handler.class, CheckPasscode.class, 13, Side.SERVER);
        network.registerMessage(SyncTENBTTag.Handler.class, SyncTENBTTag.class, 14, Side.SERVER);
        network.registerMessage(MountCamera.Handler.class, MountCamera.class, 15, Side.SERVER);
        network.registerMessage(CheckBriefcasePasscode.Handler.class, CheckBriefcasePasscode.class, 18, Side.SERVER);
        network.registerMessage(ToggleOption.Handler.class, ToggleOption.class, 19, Side.SERVER);
        network.registerMessage(UpdateSliderValue.Handler.class, UpdateSliderValue.class, 22, Side.SERVER);
        network.registerMessage(RemoveCameraTag.Handler.class, RemoveCameraTag.class, 23, Side.SERVER);
        network.registerMessage(ToggleBlockPocketManager.Handler.class, ToggleBlockPocketManager.class, 25, Side.SERVER);
        network.registerMessage(ClearLoggerServer.Handler.class, ClearLoggerServer.class, 27, Side.SERVER);
        network.registerMessage(RefreshDiguisedModel.Handler.class, RefreshDiguisedModel.class, 28, Side.CLIENT);
        network.registerMessage(SetSentryMode.Handler.class, SetSentryMode.class, 29, Side.SERVER);
        network.registerMessage(AssembleBlockPocket.Handler.class, AssembleBlockPocket.class, 30, Side.SERVER);
        network.registerMessage(SyncProjector.Handler.class, SyncProjector.class, 31, Side.SERVER);
        network.registerMessage(SyncBlockPocketManager.Handler.class, SyncBlockPocketManager.class, 32, Side.SERVER);
        network.registerMessage(SyncTrophySystem.Handler.class, SyncTrophySystem.class, 33, Side.SERVER);
        network.registerMessage(SetTrophySystemTarget.Handler.class, SetTrophySystemTarget.class, 34, Side.CLIENT);
        network.registerMessage(SetKeycardUses.Handler.class, SetKeycardUses.class, 35, Side.SERVER);
        network.registerMessage(SetCameraView.Handler.class, SetCameraView.class, 36, Side.CLIENT);
        network.registerMessage(DismountCamera.Handler.class, DismountCamera.class, 37, Side.SERVER);
        network.registerMessage(SyncSSSSettingsOnServer.Handler.class, SyncSSSSettingsOnServer.class, 38, Side.SERVER);
        network.registerMessage(ClearChangeDetectorServer.Handler.class, ClearChangeDetectorServer.class, 39, Side.SERVER);
        network.registerMessage(SyncBlockChangeDetector.Handler.class, SyncBlockChangeDetector.class, 40, Side.SERVER);
        network.registerMessage(ToggleModule.Handler.class, ToggleModule.class, 41, Side.SERVER);
        network.registerMessage(SetGhostSlot.Handler.class, SetGhostSlot.class, 42, Side.SERVER);
        network.registerMessage(RemoveMineFromMRAT.Handler.class, RemoveMineFromMRAT.class, 43, Side.SERVER);
        network.registerMessage(RemovePositionFromSSS.Handler.class, RemovePositionFromSSS.class, 44, Side.SERVER);
        network.registerMessage(RemoveSentryFromSRAT.Handler.class, RemoveSentryFromSRAT.class, 45, Side.SERVER);
        network.registerMessage(SetBriefcasePasscodeAndOwner.Handler.class, SetBriefcasePasscodeAndOwner.class, 46, Side.SERVER);
        network.registerMessage(SetListModuleData.Handler.class, SetListModuleData.class, 47, Side.SERVER);
        network.registerMessage(SetStateOnDisguiseModule.Handler.class, SetStateOnDisguiseModule.class, 48, Side.SERVER);
        network.registerMessage(SyncRiftStabilizer.Handler.class, SyncRiftStabilizer.class, 49, Side.SERVER);
        network.registerMessage(UpdateLaserColors.Handler.class, UpdateLaserColors.class, 50, Side.CLIENT);
        network.registerMessage(SyncLaserSideConfig.Handler.class, SyncLaserSideConfig.class, 51, Side.SERVER);
        network.registerMessage(PlayAlarmSound.Handler.class, PlayAlarmSound.class, 52, Side.CLIENT);
        network.registerMessage(SyncAlarmSettings.Handler.class, SyncAlarmSettings.class, 53, Side.SERVER);
        network.registerMessage(SyncBlockReinforcer.Handler.class, SyncBlockReinforcer.class, 54, Side.SERVER);
        network.registerMessage(OpenScreen.Handler.class, OpenScreen.class, 55, Side.CLIENT);
        network.registerMessage(BlockPocketManagerFailedActivation.Handler.class, BlockPocketManagerFailedActivation.class, 56, Side.SERVER);
        network.registerMessage(SetDefaultCameraViewingDirection.Handler.class, SetDefaultCameraViewingDirection.class, 57, Side.SERVER);
        network.registerMessage(SyncSecureRedstoneInterface.Handler.class, SyncSecureRedstoneInterface.class, 58, Side.SERVER);
        network.registerMessage(SpawnInterfaceHighlightParticle.Handler.class, SpawnInterfaceHighlightParticle.class, 59, Side.CLIENT);
        network.registerMessage(InteractWithFrame.Handler.class, InteractWithFrame.class, 60, Side.CLIENT);
        network.registerMessage(SyncFrame.Handler.class, SyncFrame.class, 61, Side.SERVER);
        network.registerMessage(UpdateTeamPrecedence.Handler.class, UpdateTeamPrecedence.class, 62, Side.CLIENT);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (int i = 0; i < SCSounds.values().length; ++i) {
            event.getRegistry().register((IForgeRegistryEntry)SCSounds.values()[i].event);
        }
    }

    @SubscribeEvent
    public static void registerDataSerializerEntries(RegistryEvent.Register<DataSerializerEntry> event) {
        event.getRegistry().register(new DataSerializerEntry((DataSerializer)new DataSerializer<Owner>(){

            public void write(PacketBuffer buf, Owner value) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value.getName());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value.getUUID());
            }

            public Owner read(PacketBuffer buf) throws IOException {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                String uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
                return new Owner(name, uuid);
            }

            public DataParameter<Owner> func_187161_a(int id) {
                return new DataParameter(id, (DataSerializer)this);
            }

            public Owner copyValue(Owner value) {
                return new Owner(value.getName(), value.getUUID());
            }
        }).setRegistryName(new ResourceLocation("securitycraft", "owner")));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new DyeItemRecipe().setRegistryName(new ResourceLocation("securitycraft", "dye_briefcase")));
        event.getRegistry().register(CopyPositionComponentItemRecipe.cameraMonitor().setRegistryName(new ResourceLocation("securitycraft", "copy_camera_monitor")));
        event.getRegistry().register(CopyPositionComponentItemRecipe.mineRemoteAccessTool().setRegistryName(new ResourceLocation("securitycraft", "copy_mine_remote_access_tool")));
        event.getRegistry().register(CopyPositionComponentItemRecipe.sentryRemoteAccessTool().setRegistryName(new ResourceLocation("securitycraft", "copy_sentry_remote_access_tool")));
        event.getRegistry().register(CopyPositionComponentItemRecipe.sonicSecuritySystem().setRegistryName(new ResourceLocation("securitycraft", "copy_sonic_security_system")));
        event.getRegistry().register(new LimitedUseKeycardRecipe().setRegistryName(new ResourceLocation("securitycraft", "limited_use_keycard_conversion")));
        RegistrationHandler.registerFakeLiquidRecipes(new ItemStack(Items.field_151131_as), PotionTypes.field_185252_x, PotionTypes.field_185253_y, new ItemStack(SCContent.fWaterBucket));
        RegistrationHandler.registerFakeLiquidRecipes(new ItemStack(Items.field_151129_at), PotionTypes.field_185250_v, PotionTypes.field_185251_w, new ItemStack(SCContent.fLavaBucket));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerResourceLocations(ModelRegistryEvent event) {
        RegistrationHandler.registerInventoryModel(SCContent.keypad, 0, "keypad");
        RegistrationHandler.registerInventoryModel(SCContent.frame, 0, "keypad_frame");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 0, "reinforced_stone_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 1, "reinforced_stone_granite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 2, "reinforced_stone_smooth_granite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 3, "reinforced_stone_diorite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 4, "reinforced_stone_smooth_diorite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 5, "reinforced_stone_andesite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 6, "reinforced_stone_smooth_andesite");
        RegistrationHandler.registerInventoryModel(SCContent.laserBlock, 0, "laser_block");
        RegistrationHandler.registerInventoryModel(SCContent.laserField, 0, "laser");
        RegistrationHandler.registerInventoryModel(SCContent.keypadChest, 0, "keypad_chest");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDoor, 0, "reinforced_iron_door");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedIronTrapdoor, 0, "reinforced_iron_trapdoor");
        RegistrationHandler.registerInventoryModel(SCContent.keycardReader, 0, "keycard_reader");
        RegistrationHandler.registerInventoryModel(SCContent.inventoryScanner, 0, "inventory_scanner");
        RegistrationHandler.registerInventoryModel(SCContent.cageTrap, 0, "cage_trap");
        RegistrationHandler.registerInventoryModel(SCContent.inventoryScannerField, 0, "inventory_scanner_field");
        RegistrationHandler.registerInventoryModel(SCContent.retinalScanner, 0, "retinal_scanner");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedIronBars, 0, "reinforced_iron_bars");
        RegistrationHandler.registerInventoryModel(SCContent.portableRadar, 0, "portable_radar");
        RegistrationHandler.registerInventoryModel(SCContent.alarm, 0, "alarm");
        RegistrationHandler.registerInventoryModel(SCContent.alarmLit, 0, "alarm_lit");
        RegistrationHandler.registerInventoryModel(SCContent.usernameLogger, 0, "username_logger");
        RegistrationHandler.registerInventoryModel(SCContent.electrifiedIronFenceGate, 0, "reinforced_fence_gate");
        RegistrationHandler.registerInventoryModel(SCContent.electrifiedIronFence, 0, "electrified_iron_fence");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 0, "reinforced_planks_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 1, "reinforced_planks_spruce");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 2, "reinforced_planks_birch");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 3, "reinforced_planks_jungle");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 4, "reinforced_planks_acacia");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 5, "reinforced_planks_dark_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsStone, 0, "reinforced_stairs_stone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsCobblestone, 0, "reinforced_stairs_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsOak, 0, "reinforced_stairs_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsSpruce, 0, "reinforced_stairs_spruce");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsBirch, 0, "reinforced_stairs_birch");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsJungle, 0, "reinforced_stairs_jungle");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsAcacia, 0, "reinforced_stairs_acacia");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsDarkoak, 0, "reinforced_stairs_darkoak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGlass, 0, "reinforced_glass_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 0, "reinforced_stained_glass_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 1, "reinforced_stained_glass_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 2, "reinforced_stained_glass_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 3, "reinforced_stained_glass_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 4, "reinforced_stained_glass_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 5, "reinforced_stained_glass_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 6, "reinforced_stained_glass_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 7, "reinforced_stained_glass_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 8, "reinforced_stained_glass_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 9, "reinforced_stained_glass_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 10, "reinforced_stained_glass_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 11, "reinforced_stained_glass_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 12, "reinforced_stained_glass_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 13, "reinforced_stained_glass_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 14, "reinforced_stained_glass_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 15, "reinforced_stained_glass_black");
        RegistrationHandler.registerInventoryModel(SCContent.keypadChest, 0, "keypad_chest");
        RegistrationHandler.registerInventoryModel(SCContent.keypadFurnace, 0, "keypad_furnace");
        RegistrationHandler.registerInventoryModel(SCContent.panicButton, 0, "panic_button");
        RegistrationHandler.registerInventoryModel(SCContent.securityCamera, 0, "security_camera");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDirt, 0, "reinforced_dirt");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDirt, 1, "reinforced_coarse_dirt");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDirt, 2, "reinforced_podzol");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCobblestone, 0, "reinforced_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSandstone, 0, "reinforced_sandstone_normal");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSandstone, 1, "reinforced_sandstone_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSandstone, 2, "reinforced_sandstone_smooth");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 0, "reinforced_wood_slabs_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 1, "reinforced_wood_slabs_spruce");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 2, "reinforced_wood_slabs_birch");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 3, "reinforced_wood_slabs_jungle");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 4, "reinforced_wood_slabs_acacia");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 5, "reinforced_wood_slabs_dark_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsCobblestone, 0, "reinforced_stairs_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsSandstone, 0, "reinforced_stairs_sandstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 0, "reinforced_stone_slabs_stone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 1, "reinforced_stone_slabs_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 2, "reinforced_stone_slabs_sandstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 3, "reinforced_stone_slabs_stonebrick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 4, "reinforced_stone_slabs_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 5, "reinforced_stone_slabs_netherbrick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 6, "reinforced_stone_slabs_quartz");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs2, 0, "reinforced_stone_slabs2_red_sandstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs2, 1, "reinforced_stone_slabs2_purpur");
        RegistrationHandler.registerInventoryModel(SCContent.protecto, 0, "protecto");
        RegistrationHandler.registerInventoryModel(SCContent.scannerDoor, 0, "scanner_door");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneBrick, 0, "reinforced_stone_brick_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneBrick, 1, "reinforced_stone_brick_mossy");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneBrick, 2, "reinforced_stone_brick_cracked");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneBrick, 3, "reinforced_stone_brick_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsStoneBrick, 0, "reinforced_stairs_stone_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMossyCobblestone, 0, "reinforced_mossy_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBrick, 0, "reinforced_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsBrick, 0, "reinforced_stairs_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNetherBrick, 0, "reinforced_nether_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsNetherBrick, 0, "reinforced_stairs_nether_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedHardenedClay, 0, "reinforced_hardened_clay");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 0, "reinforced_stained_hardened_clay_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 1, "reinforced_stained_hardened_clay_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 2, "reinforced_stained_hardened_clay_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 3, "reinforced_stained_hardened_clay_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 4, "reinforced_stained_hardened_clay_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 5, "reinforced_stained_hardened_clay_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 6, "reinforced_stained_hardened_clay_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 7, "reinforced_stained_hardened_clay_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 8, "reinforced_stained_hardened_clay_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 9, "reinforced_stained_hardened_clay_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 10, "reinforced_stained_hardened_clay_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 11, "reinforced_stained_hardened_clay_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 12, "reinforced_stained_hardened_clay_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 13, "reinforced_stained_hardened_clay_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 14, "reinforced_stained_hardened_clay_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 15, "reinforced_stained_hardened_clay_black");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOldLogs, 0, "reinforced_logs_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOldLogs, 1, "reinforced_logs_spruce");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOldLogs, 2, "reinforced_logs_birch");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOldLogs, 3, "reinforced_logs_jungle");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNewLogs, 0, "reinforced_logs2_acacia");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNewLogs, 1, "reinforced_logs2_big_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 0, "reinforced_metals_gold");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 1, "reinforced_metals_iron");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 2, "reinforced_metals_diamond");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 3, "reinforced_metals_emerald");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 4, "reinforced_metals_redstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedLapisAndCoalBlocks, 0, "reinforced_compressed_blocks_lapis");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedLapisAndCoalBlocks, 1, "reinforced_compressed_blocks_coal");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 0, "reinforced_wool_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 1, "reinforced_wool_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 2, "reinforced_wool_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 3, "reinforced_wool_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 4, "reinforced_wool_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 5, "reinforced_wool_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 6, "reinforced_wool_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 7, "reinforced_wool_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 8, "reinforced_wool_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 9, "reinforced_wool_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 10, "reinforced_wool_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 11, "reinforced_wool_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 12, "reinforced_wool_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 13, "reinforced_wool_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 14, "reinforced_wool_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 15, "reinforced_wool_black");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedQuartz, 0, "reinforced_quartz_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedQuartz, 1, "reinforced_quartz_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedQuartz, 2, "reinforced_quartz_pillar");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsQuartz, 0, "reinforced_stairs_quartz");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPrismarine, 0, "reinforced_prismarine_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPrismarine, 1, "reinforced_prismarine_bricks");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPrismarine, 2, "reinforced_prismarine_dark");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedSandstone, 0, "reinforced_red_sandstone_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedSandstone, 1, "reinforced_red_sandstone_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedSandstone, 2, "reinforced_red_sandstone_smooth");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsRedSandstone, 0, "reinforced_stairs_red_sandstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedEndStoneBricks, 0, "reinforced_end_stone_bricks");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedNetherBrick, 0, "reinforced_red_nether_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPurpur, 0, "reinforced_purpur_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPurpur, 1, "reinforced_purpur_pillar");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsPurpur, 0, "reinforced_stairs_purpur");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 0, "reinforced_concrete_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 1, "reinforced_concrete_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 2, "reinforced_concrete_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 3, "reinforced_concrete_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 4, "reinforced_concrete_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 5, "reinforced_concrete_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 6, "reinforced_concrete_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 7, "reinforced_concrete_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 8, "reinforced_concrete_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 9, "reinforced_concrete_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 10, "reinforced_concrete_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 11, "reinforced_concrete_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 12, "reinforced_concrete_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 13, "reinforced_concrete_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 14, "reinforced_concrete_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 15, "reinforced_concrete_black");
        RegistrationHandler.registerInventoryModel(SCContent.motionActivatedLight, 0, "motion_activated_light");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedObsidian, 0, "reinforced_obsidian");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNetherrack, 0, "reinforced_netherrack");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedEndStone, 0, "reinforced_end_stone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSeaLantern, 0, "reinforced_sea_lantern");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBoneBlock, 0, "reinforced_bone_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGlassPane, 0, "reinforced_glass_pane");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 0, "reinforced_stained_glass_panes_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 1, "reinforced_stained_glass_panes_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 2, "reinforced_stained_glass_panes_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 3, "reinforced_stained_glass_panes_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 4, "reinforced_stained_glass_panes_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 5, "reinforced_stained_glass_panes_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 6, "reinforced_stained_glass_panes_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 7, "reinforced_stained_glass_panes_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 8, "reinforced_stained_glass_panes_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 9, "reinforced_stained_glass_panes_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 10, "reinforced_stained_glass_panes_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 11, "reinforced_stained_glass_panes_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 12, "reinforced_stained_glass_panes_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 13, "reinforced_stained_glass_panes_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 14, "reinforced_stained_glass_panes_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 15, "reinforced_stained_glass_panes_black");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 0, "reinforced_carpet_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 1, "reinforced_carpet_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 2, "reinforced_carpet_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 3, "reinforced_carpet_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 4, "reinforced_carpet_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 5, "reinforced_carpet_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 6, "reinforced_carpet_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 7, "reinforced_carpet_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 8, "reinforced_carpet_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 9, "reinforced_carpet_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 10, "reinforced_carpet_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 11, "reinforced_carpet_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 12, "reinforced_carpet_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 13, "reinforced_carpet_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 14, "reinforced_carpet_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 15, "reinforced_carpet_black");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGlowstone, 0, "reinforced_glowstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSand, 0, "reinforced_sand");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSand, 1, "reinforced_red_sand");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGravel, 0, "reinforced_gravel");
        RegistrationHandler.registerInventoryModel(SCContent.trophySystem, 0, "trophy_system");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartz, 0, "crystal_quartz_default");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartz, 1, "crystal_quartz_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartz, 2, "crystal_quartz_pillar");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCrystalQuartz, 0, "reinforced_crystal_quartz_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCrystalQuartz, 1, "reinforced_crystal_quartz_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCrystalQuartz, 2, "reinforced_crystal_quartz_pillar");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartzSlab, 0, "crystal_quartz_slab");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCrystalQuartzSlab, 0, "reinforced_crystal_quartz_slab");
        RegistrationHandler.registerInventoryModel(SCContent.stairsCrystalQuartz, 0, "stairs_crystal_quartz");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsCrystalQuartz, 0, "reinforced_stairs_crystal_quartz");
        RegistrationHandler.registerInventoryModel(SCContent.blockPocketWall, 0, "block_pocket_wall");
        RegistrationHandler.registerInventoryModel(SCContent.blockPocketManager, 0, "block_pocket_manager");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStonePressurePlate, 0, "reinforced_stone_pressure_plate");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodenPressurePlate, 0, "reinforced_wooden_pressure_plate");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBookshelf, 0, "reinforced_bookshelf");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWalls, 0, "reinforced_cobblestone_wall");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWalls, 1, "reinforced_mossy_cobblestone_wall");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStickyPiston, 0, "reinforced_sticky_piston");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPiston, 0, "reinforced_piston");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedObserver, 0, "reinforced_observer");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedstoneLamp, 0, "reinforced_redstone_lamp");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCobweb, 0, "reinforced_cobweb");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGrass, 0, "reinforced_grass_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSnowBlock, 0, "reinforced_snow_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedIce, 0, "reinforced_ice");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPackedIce, 0, "reinforced_packed_ice");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMycelium, 0, "reinforced_mycelium");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedClay, 0, "reinforced_clay");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNetherWartBlock, 0, "reinforced_nether_wart_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGrassPath, 0, "reinforced_grass_path");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneButton, 0, "reinforced_stone_button");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodenButton, 0, "reinforced_wooden_button");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedLever, 0, "reinforced_lever");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedHopper, 0, "reinforced_hopper");
        RegistrationHandler.registerInventoryModel(SCContent.projector, 0, "projector");
        RegistrationHandler.registerInventoryModel(SCContent.keypadDoor, 0, "keypad_door");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCauldron, 0, "reinforced_cauldron");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedEndRod, 0, "reinforced_end_rod");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWhiteGlazedTerracotta, 0, "reinforced_white_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOrangeGlazedTerracotta, 0, "reinforced_orange_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMagentaGlazedTerracotta, 0, "reinforced_magenta_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedLightBlueGlazedTerracotta, 0, "reinforced_light_blue_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedYellowGlazedTerracotta, 0, "reinforced_yellow_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedLimeGlazedTerracotta, 0, "reinforced_lime_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPinkGlazedTerracotta, 0, "reinforced_pink_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGrayGlazedTerracotta, 0, "reinforced_gray_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSilverGlazedTerracotta, 0, "reinforced_silver_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCyanGlazedTerracotta, 0, "reinforced_cyan_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPurpleGlazedTerracotta, 0, "reinforced_purple_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBlueGlazedTerracotta, 0, "reinforced_blue_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBrownGlazedTerracotta, 0, "reinforced_brown_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGreenGlazedTerracotta, 0, "reinforced_green_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedGlazedTerracotta, 0, "reinforced_red_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBlackGlazedTerracotta, 0, "reinforced_black_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.riftStabilizer, 0, "rift_stabilizer");
        RegistrationHandler.registerInventoryModel(SCContent.displayCase, 0, "display_case");
        RegistrationHandler.registerInventoryModel((Block)SCContent.keypadTrapdoor, 0, "keypad_trapdoor");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedLadder, 0, "reinforced_ladder");
        RegistrationHandler.registerInventoryModel(SCContent.floorTrap, 0, "floor_trap");
        RegistrationHandler.registerInventoryModel((Block)SCContent.scannerTrapdoor, 0, "scanner_trapdoor");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDispenser, 0, "reinforced_dispenser");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDropper, 0, "reinforced_dropper");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOakFence, 0, "reinforced_oak_fence");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNetherBrickFence, 0, "reinforced_nether_brick_fence");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSpruceFence, 0, "reinforced_spruce_fence");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBirchFence, 0, "reinforced_birch_fence");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedJungleFence, 0, "reinforced_jungle_fence");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDarkOakFence, 0, "reinforced_dark_oak_fence");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedAcaciaFence, 0, "reinforced_acacia_fence");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOakFenceGate, 0, "reinforced_oak_fence_gate");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSpruceFenceGate, 0, "reinforced_spruce_fence_gate");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBirchFenceGate, 0, "reinforced_birch_fence_gate");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedJungleFenceGate, 0, "reinforced_jungle_fence_gate");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDarkOakFenceGate, 0, "reinforced_dark_oak_fence_gate");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedAcaciaFenceGate, 0, "reinforced_acacia_fence_gate");
        RegistrationHandler.registerInventoryModel(SCContent.secureRedstoneInterface, 0, "secure_redstone_interface");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMagmaBlock, 0, "reinforced_magma_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSoulSand, 0, "reinforced_soul_sand");
        RegistrationHandler.registerInventoryModel(SCContent.codebreaker, 0, "codebreaker");
        RegistrationHandler.registerInventoryModel(SCContent.mineRemoteAccessTool, 0, "remote_access_mine");
        RegistrationHandler.registerInventoryModel(SCContent.sentryRemoteAccessTool, 0, "remote_access_sentry");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDoorItem, 0, "door_indestructible_iron_item");
        RegistrationHandler.registerInventoryModel(SCContent.fWaterBucket, 0, "bucket_f_water");
        RegistrationHandler.registerInventoryModel(SCContent.fLavaBucket, 0, "bucket_f_lava");
        RegistrationHandler.registerInventoryModel(SCContent.incognitoMask, 0, "incognito_mask");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl1, 0, "keycard_lv1");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl2, 0, "keycard_lv2");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl3, 0, "keycard_lv3");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl4, 0, "keycard_lv4");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl5, 0, "keycard_lv5");
        RegistrationHandler.registerInventoryModel(SCContent.limitedUseKeycard, 0, "limited_use_keycard");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockRemover, 0, "universal_block_remover");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockModifier, 0, "universal_block_modifier");
        RegistrationHandler.registerInventoryModel(SCContent.allowlistModule, 0, "whitelist_module");
        RegistrationHandler.registerInventoryModel(SCContent.denylistModule, 0, "blacklist_module");
        RegistrationHandler.registerInventoryModel(SCContent.redstoneModule, 0, "redstone_module");
        RegistrationHandler.registerInventoryModel(SCContent.harmingModule, 0, "harming_module");
        RegistrationHandler.registerInventoryModel(SCContent.storageModule, 0, "storage_module");
        RegistrationHandler.registerInventoryModel(SCContent.smartModule, 0, "smart_module");
        RegistrationHandler.registerInventoryModel(SCContent.disguiseModule, 0, "disguise_module");
        RegistrationHandler.registerInventoryModel(SCContent.speedModule, 0, "speed_module");
        RegistrationHandler.registerInventoryModel(SCContent.wireCutters, 0, "wire_cutters");
        RegistrationHandler.registerInventoryModel(SCContent.keyPanel, 0, "keypad_item");
        RegistrationHandler.registerInventoryModel(SCContent.adminTool, 0, "admin_tool");
        RegistrationHandler.registerInventoryModel(SCContent.cameraMonitor, 0, "camera_monitor");
        RegistrationHandler.registerInventoryModel(SCContent.scManual, 0, "sc_manual");
        RegistrationHandler.registerInventoryModel(SCContent.taser, 0, "taser");
        RegistrationHandler.registerInventoryModel(SCContent.taserPowered, 0, "taser_powered");
        RegistrationHandler.registerInventoryModel(SCContent.universalOwnerChanger, 0, "universal_owner_changer");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockReinforcerLvL1, 0, "universal_block_reinforcer_lvl1");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockReinforcerLvL2, 0, "universal_block_reinforcer_lvl2");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockReinforcerLvL3, 0, "universal_block_reinforcer_lvl3");
        RegistrationHandler.registerInventoryModel(SCContent.briefcase, 0, "briefcase");
        RegistrationHandler.registerInventoryModel(SCContent.universalKeyChanger, 0, "universal_key_changer");
        RegistrationHandler.registerInventoryModel(SCContent.scannerDoorItem, 0, "scanner_door_item");
        RegistrationHandler.registerInventoryModel(SCContent.secretSignItem, 0, "secret_sign_item");
        RegistrationHandler.registerInventoryModel(SCContent.sentry, 0, "sentry");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartzItem, 0, "crystal_quartz_item");
        RegistrationHandler.registerInventoryModel(SCContent.keypadDoorItem, 0, "keypad_door_item");
        RegistrationHandler.registerInventoryModel(SCContent.sonicSecuritySystemItem, 0, "sonic_security_system");
        RegistrationHandler.registerInventoryModel(SCContent.portableTunePlayer, 0, "portable_tune_player");
        RegistrationHandler.registerInventoryModel(SCContent.keycardHolder, 0, "keycard_holder");
        RegistrationHandler.registerInventoryModel(SCContent.lens, 0, "lens");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLock, 0, "keycard_lock");
        RegistrationHandler.registerInventoryModel(SCContent.blockChangeDetectorItem, 0, "block_change_detector");
        RegistrationHandler.registerInventoryModel((Block)SCContent.mine, 0, "mine");
        RegistrationHandler.registerInventoryModel(SCContent.dirtMine, 0, "dirt_mine");
        RegistrationHandler.registerInventoryModel(SCContent.stoneMine, 0, "stone_mine");
        RegistrationHandler.registerInventoryModel(SCContent.cobblestoneMine, 0, "cobblestone_mine");
        RegistrationHandler.registerInventoryModel(SCContent.sandMine, 0, "sand_mine");
        RegistrationHandler.registerInventoryModel(SCContent.diamondOreMine, 0, "diamond_mine");
        RegistrationHandler.registerInventoryModel(SCContent.furnaceMine, 0, "furnace_mine");
        RegistrationHandler.registerInventoryModel(SCContent.trackMine, 0, "track_mine");
        RegistrationHandler.registerInventoryModel(SCContent.bouncingBetty, 0, "bouncing_betty");
        RegistrationHandler.registerInventoryModel(SCContent.claymore, 0, "claymore");
        RegistrationHandler.registerInventoryModel(SCContent.ims, 0, "ims");
        RegistrationHandler.registerInventoryModel(SCContent.gravelMine, 0, "gravel_mine");
        RegistrationHandler.registerInventoryModel(SCContent.coalOreMine, 0, "coal_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.emeraldOreMine, 0, "emerald_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.goldOreMine, 0, "gold_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.ironOreMine, 0, "iron_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.lapisOreMine, 0, "lapis_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.quartzOreMine, 0, "quartz_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.redstoneOreMine, 0, "redstone_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.netherrackMine, 0, "netherrack_mine");
        RegistrationHandler.registerInventoryModel(SCContent.endStoneMine, 0, "end_stone_mine");
    }

    private static void registerInventoryModel(Block block, int metadata, String name) {
        RegistrationHandler.registerInventoryModel(Item.func_150898_a((Block)block), metadata, name);
    }

    private static void registerInventoryModel(Item item, int metadata, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation("securitycraft:" + name, "inventory"));
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, String designedBy) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), designedBy);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), PageGroup.SINGLE_ITEM);
    }

    private static void registerBlockMine(RegistryEvent.Register<Block> event, Block block) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), PageGroup.BLOCK_MINES);
        blockConfigValues.put(block, ABLE_TO_CRAFT_MINES);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, Supplier<Boolean> configValue) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), PageGroup.SINGLE_ITEM);
        blockConfigValues.put(block, configValue);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, PageGroup pageGroup) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), pageGroup);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, ItemBlock itemBlock, PageGroup pageType) {
        event.getRegistry().register((IForgeRegistryEntry)block);
        if (itemBlock != null) {
            itemBlocks.add((Item)itemBlock.setRegistryName(block.getRegistryName().toString()));
        }
        if (pageType == PageGroup.SINGLE_ITEM) {
            blockPages.add(block);
        } else if (pageType != PageGroup.NO_PAGE) {
            if (!pageTypeBlocks.containsKey((Object)pageType)) {
                pageTypeBlocks.put(pageType, new ArrayList());
            }
            pageTypeBlocks.get((Object)pageType).add(block);
        }
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, ItemBlock itemBlock, String designedBy) {
        event.getRegistry().register((IForgeRegistryEntry)block);
        if (itemBlock != null) {
            itemBlocks.add((Item)itemBlock.setRegistryName(block.getRegistryName().toString()));
        }
        blockPages.add(block);
        if (designedBy != null) {
            blocksDesignedBy.put(block, designedBy);
        }
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item) {
        RegistrationHandler.registerItem(event, item, PageGroup.SINGLE_ITEM, () -> true, "");
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item, PageGroup pageType, Supplier<Boolean> configValue) {
        RegistrationHandler.registerItem(event, item, pageType, configValue, "");
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item, PageGroup pageType) {
        RegistrationHandler.registerItem(event, item, pageType, () -> true, "");
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item, PageGroup pageType, Supplier<Boolean> configValue, String designedBy) {
        event.getRegistry().register((IForgeRegistryEntry)item);
        if (pageType == PageGroup.NO_PAGE) {
            return;
        }
        if (pageType != PageGroup.SINGLE_ITEM) {
            if (!pageTypeStacks.containsKey((Object)pageType)) {
                pageTypeStacks.put(pageType, new ArrayList());
            }
            if (item != null && item.func_77614_k()) {
                NonNullList subStacks = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), subStacks);
                pageTypeStacks.get((Object)pageType).addAll((Collection<ItemStack>)subStacks);
            } else {
                pageTypeStacks.get((Object)pageType).add(new ItemStack(item));
            }
        } else {
            TextComponentTranslation title = Utils.localize(item, new Object[0]);
            TextComponentTranslation helpInfo = Utils.localize("help." + item.func_77658_a().substring(5) + ".info", new Object[0]);
            SCManualItem.PAGES.add(new SCManualPage(item, pageType, title, helpInfo, designedBy, false, configValue));
        }
    }

    private static void registerFakeLiquidRecipes(ItemStack input, PotionType normalPotion, PotionType strongPotion, ItemStack output) {
        NBTTagCompound normalNBT = new NBTTagCompound();
        NBTTagCompound strongNBT = new NBTTagCompound();
        normalNBT.func_74778_a("Potion", normalPotion.getRegistryName().toString());
        strongNBT.func_74778_a("Potion", strongPotion.getRegistryName().toString());
        PartialNBTIngredient normalPotions = PartialNBTIngredient.of(normalNBT, new Item[]{Items.field_151068_bn, Items.field_185155_bH, Items.field_185156_bI});
        PartialNBTIngredient strongPotions = PartialNBTIngredient.of(strongNBT, new Item[]{Items.field_151068_bn, Items.field_185155_bH, Items.field_185156_bI});
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new IngredientBrewingRecipe(input, (Ingredient)PublicCompoundIngredient.of(normalPotions, strongPotions), output));
    }

    public static class PublicCompoundIngredient
    extends CompoundIngredient {
        public PublicCompoundIngredient(List<Ingredient> children) {
            super(children);
        }

        public static PublicCompoundIngredient of(Ingredient ... ingredients) {
            return new PublicCompoundIngredient(Arrays.asList(ingredients));
        }
    }
}

