/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public interface ICodebreakable {
    public boolean shouldAttemptCodebreak(EntityPlayer var1);

    public void useCodebreaker(EntityPlayer var1);

    default public boolean handleCodebreaking(EntityPlayer player, EnumHand hand) {
        double chance = ConfigHandler.codebreakerChance;
        if (chance < 0.0) {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.codebreaker, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        } else {
            ItemStack codebreaker = player.func_184586_b(hand);
            if (!this.shouldAttemptCodebreak(player)) {
                return true;
            }
            if (codebreaker.func_77973_b() == SCContent.codebreaker) {
                boolean canBypass;
                boolean bl = canBypass = player.func_184812_l_() || player.func_175149_v();
                if (this instanceof IOwnable && ((IOwnable)((Object)this)).isOwnedBy((Entity)player) && !canBypass) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.codebreaker, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreaker.owned", new Object[0]), TextFormatting.RED);
                    return false;
                }
                if (!codebreaker.func_77942_o()) {
                    codebreaker.func_77982_d(new NBTTagCompound());
                }
                if (!canBypass && CodebreakerItem.wasRecentlyUsed(codebreaker)) {
                    return false;
                }
                boolean isSuccessful = canBypass || SecurityCraft.RANDOM.nextDouble() < chance;
                NBTTagCompound tag = codebreaker.func_77978_p();
                if (!canBypass) {
                    codebreaker.func_77972_a(1, (EntityLivingBase)player);
                }
                tag.func_74772_a("last_used_time", System.currentTimeMillis());
                tag.func_74757_a("was_successful", isSuccessful);
                if (isSuccessful) {
                    this.useCodebreaker(player);
                } else {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.codebreaker, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), TextFormatting.RED);
                }
            }
        }
        return true;
    }
}

