/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.ClaymoreBlock;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.SingleLensMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ClaymoreBlockEntity
extends CustomizableBlockEntity
implements ITickable,
IInventoryChangedListener,
SingleLensMenu.SingleLensContainer {
    private Option.IntOption range = new Option.IntOption(() -> ((ClaymoreBlockEntity)this).func_174877_v(), "range", 5, 1, 10, 1);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.TargetingModeOption targetingMode = new Option.TargetingModeOption(TargetingMode.PLAYERS_AND_MOBS);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private int cooldown = -1;
    private IItemHandler insertOnlyHandler;
    private IItemHandler lensHandler;
    private LensContainer lens = new LensContainer(1);

    public ClaymoreBlockEntity() {
        this.lens.func_110134_a(this);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)state.func_177229_b((IProperty)ClaymoreBlock.DEACTIVATED)).booleanValue()) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return;
            }
            if (this.cooldown == 0) {
                ((ClaymoreBlock)this.func_145838_q()).explode(this.field_145850_b, this.field_174879_c);
                return;
            }
            TargetingMode mode = this.getTargetingMode();
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)ClaymoreBlock.FACING);
            AxisAlignedBB area = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1);
            if (dir == EnumFacing.NORTH) {
                area = area.func_191195_a(0.0, 0.0, (double)((Integer)this.range.get()).intValue());
            } else if (dir == EnumFacing.SOUTH) {
                area = area.func_191195_a(0.0, 0.0, (double)(-((Integer)this.range.get()).intValue()));
            } else if (dir == EnumFacing.EAST) {
                area = area.func_191195_a((double)(-((Integer)this.range.get()).intValue()), 0.0, 0.0);
            } else if (dir == EnumFacing.WEST) {
                area = area.func_191195_a((double)((Integer)this.range.get()).intValue(), 0.0, 0.0);
            }
            this.func_145831_w().func_175647_a(EntityLivingBase.class, area, e -> mode.canAttackEntity((EntityLivingBase)e, this, this.respectInvisibility::isConsideredInvisible)).stream().findFirst().ifPresent(e -> {
                this.cooldown = 20;
                this.func_145831_w().func_184133_a(null, new BlockPos((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
            });
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74782_a("lens", (NBTBase)this.lens.func_70301_a(0).func_77955_b(new NBTTagCompound()));
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.cooldown = tag.func_74762_e("cooldown");
        this.lens.func_70299_a(0, new ItemStack(tag.func_74775_l("lens")));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(BlockUtils.isAllowedToExtractFromProtectedObject(facing, this) ? this.getNormalHandler() : this.getInsertOnlyHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    private IItemHandler getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = new InsertOnlyInvWrapper((IInventory)this.lens);
        }
        return this.insertOnlyHandler;
    }

    private IItemHandler getNormalHandler() {
        if (this.lensHandler == null) {
            this.lensHandler = new InvWrapper((IInventory)this.lens);
        }
        return this.lensHandler;
    }

    public void func_76316_a(IInventory container) {
        if (this.field_145850_b == null) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    @Override
    public LensContainer getLensContainer() {
        return this.lens;
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.ignoreOwner, this.targetingMode, this.respectInvisibility};
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public TargetingMode getTargetingMode() {
        return (TargetingMode)((Object)this.targetingMode.get());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c);
    }
}

