/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FakeWaterBlock
extends BlockDynamicLiquid {
    int field_149815_a;

    public FakeWaterBlock(Material material) {
        super(material);
    }

    private void placeStaticBlock(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, FakeWaterBlock.getStaticBlock(this.field_149764_J).func_176223_P().func_177226_a((IProperty)field_176367_b, state.func_177229_b((IProperty)field_176367_b)), 2);
    }

    public static BlockStaticLiquid getStaticBlock(Material material) {
        if (material == Material.field_151586_h) {
            return SCContent.fakeWater;
        }
        if (material == Material.field_151587_i) {
            return SCContent.fakeLava;
        }
        throw new IllegalArgumentException("Invalid material");
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int levelAbove;
        int level = (Integer)state.func_177229_b((IProperty)field_176367_b);
        int levelToAdd = 1;
        if (this.field_149764_J == Material.field_151587_i && !world.field_73011_w.func_177500_n()) {
            levelToAdd = 2;
        }
        int tickRate = this.func_149738_a(world);
        if (level > 0) {
            IBlockState stateBelow;
            int currentMinLevel = -100;
            this.field_149815_a = 0;
            for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                currentMinLevel = this.func_176371_a(world, pos.func_177972_a(facing), currentMinLevel);
            }
            int nextLevel = currentMinLevel + levelToAdd;
            if (nextLevel >= 8 || currentMinLevel < 0) {
                nextLevel = -1;
            }
            if (this.func_189542_i(world.func_180495_p(pos.func_177984_a())) >= 0) {
                levelAbove = this.func_189542_i(world.func_180495_p(pos.func_177984_a()));
                nextLevel = levelAbove >= 8 ? levelAbove : levelAbove + 8;
            }
            if (this.field_149815_a >= 2 && this.field_149764_J == Material.field_151586_h && ((stateBelow = world.func_180495_p(pos.func_177977_b())).func_185904_a().func_76220_a() || stateBelow.func_185904_a() == this.field_149764_J && (Integer)stateBelow.func_177229_b((IProperty)field_176367_b) == 0)) {
                nextLevel = 0;
            }
            if (this.field_149764_J == Material.field_151587_i && level < 8 && nextLevel < 8 && nextLevel > level && rand.nextInt(4) != 0) {
                tickRate *= 4;
            }
            if (nextLevel == level) {
                this.placeStaticBlock(world, pos, state);
            } else {
                level = nextLevel;
                if (nextLevel < 0) {
                    world.func_175698_g(pos);
                } else {
                    state = state.func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(nextLevel));
                    world.func_180501_a(pos, state, 2);
                    world.func_175684_a(pos, (Block)this, tickRate);
                    world.func_175685_c(pos, (Block)this, false);
                }
            }
        } else {
            this.placeStaticBlock(world, pos, state);
        }
        BlockPos downPos = pos.func_177977_b();
        IBlockState stateBelow = world.func_180495_p(downPos);
        if (this.canFlowInto(stateBelow)) {
            if (this.field_149764_J == Material.field_151587_i && world.func_180495_p(downPos).func_177230_c().func_149688_o(world.func_180495_p(downPos)) == Material.field_151586_h) {
                world.func_175656_a(downPos, ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)downPos, (BlockPos)pos, (IBlockState)Blocks.field_150348_b.func_176223_P()));
                this.func_180688_d(world, downPos);
                return;
            }
            if (level >= 8) {
                this.tryFlowInto(world, downPos, stateBelow, level);
            } else {
                this.tryFlowInto(world, downPos, stateBelow, level + 8);
            }
        } else if (level >= 0 && (level == 0 || this.isBlocked(stateBelow))) {
            Set<?> flowDirections = this.getPossibleFlowDirections(world, pos);
            levelAbove = level + levelToAdd;
            if (level >= 8) {
                levelAbove = 1;
            }
            if (levelAbove >= 8) {
                return;
            }
            for (EnumFacing facing : flowDirections) {
                this.tryFlowInto(world, pos.func_177972_a(facing), world.func_180495_p(pos.func_177972_a(facing)), levelAbove);
            }
        }
    }

    private void tryFlowInto(World world, BlockPos pos, IBlockState state, int level) {
        if (this.canFlowInto(state)) {
            if (state.func_177230_c() != Blocks.field_150350_a) {
                if (this.field_149764_J == Material.field_151587_i) {
                    this.func_180688_d(world, pos);
                } else {
                    state.func_177230_c().func_176226_b(world, pos, state, 0);
                }
            }
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(level)), 3);
        }
    }

    private int calculateFlowCost(World world, BlockPos pos, int distance, EnumFacing previousDirection) {
        int cost = 1000;
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            int oppositeCost;
            BlockPos offsetPos;
            IBlockState offsetState;
            if (facing == previousDirection || this.isBlocked(offsetState = world.func_180495_p(offsetPos = pos.func_177972_a(facing))) || offsetState.func_185904_a() == this.field_149764_J && (Integer)offsetState.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            BlockPos downPos = offsetPos.func_177977_b();
            if (!this.isBlocked(world.func_180495_p(downPos))) {
                return distance;
            }
            if (distance >= 4 || (oppositeCost = this.calculateFlowCost(world, offsetPos, distance + 1, facing.func_176734_d())) >= cost) continue;
            cost = oppositeCost;
        }
        return cost;
    }

    private Set<?> getPossibleFlowDirections(World world, BlockPos pos) {
        int cost = 1000;
        EnumSet<EnumFacing> facings = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            if (this.isBlocked(offsetState) || offsetState.func_185904_a() == this.field_149764_J && (Integer)offsetState.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            BlockPos downPos = offsetPos.func_177977_b();
            int oppositeCost = this.isBlocked(world.func_180495_p(downPos)) ? this.calculateFlowCost(world, offsetPos, 1, facing.func_176734_d()) : 0;
            if (oppositeCost < cost) {
                facings.clear();
            }
            if (oppositeCost > cost) continue;
            facings.add(facing);
            cost = oppositeCost;
        }
        return facings;
    }

    private boolean isBlocked(IBlockState state) {
        Block block = state.func_177230_c();
        Material mat = state.func_185904_a();
        if (!(block instanceof BlockDoor) && block != Blocks.field_150472_an && block != Blocks.field_150468_ap && block != Blocks.field_150436_aH && mat != Material.field_151567_E && mat != Material.field_189963_J) {
            return mat.func_76230_c();
        }
        return true;
    }

    protected int func_176371_a(World world, BlockPos pos, int currentMinLevel) {
        int level = this.func_189542_i(world.func_180495_p(pos));
        if (level < 0) {
            return currentMinLevel;
        }
        if (level == 0) {
            ++this.field_149815_a;
        }
        if (level >= 8) {
            level = 0;
        }
        return currentMinLevel >= 0 && level >= currentMinLevel ? currentMinLevel : level;
    }

    private boolean canFlowInto(IBlockState state) {
        Material material = state.func_177230_c().func_149688_o(state);
        return material != this.field_149764_J && material != Material.field_151587_i && !this.isBlocked(state);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!this.func_176365_e(world, pos, state)) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(world.field_72995_K || entity instanceof EntityItem || entity instanceof EntityBoat || entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || entity.func_184187_bx() instanceof EntityBoat))) {
            entity.func_70097_a(CustomDamageSources.FAKE_WATER, 5.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }
}

