/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.KeypadDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.SpecialDoorBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class KeypadDoorBlock
extends SpecialDoorBlock {
    public KeypadDoorBlock(Material material) {
        super(material);
        this.destroyTimeForOwner = 5.0f;
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)field_176522_N)).booleanValue()) {
            return false;
        }
        if (!world.field_72995_K) {
            KeypadDoorBlockEntity be = (KeypadDoorBlockEntity)world.func_175625_s(pos);
            if (be.isDisabled()) {
                player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(world, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                    }
                    this.activate(state, world, pos, be.getSignalLength());
                } else if (player.func_184586_b(hand).func_77973_b() != SCContent.codebreaker) {
                    be.openPasscodeGUI(world, pos, player);
                }
            }
        }
        return true;
    }

    public void activate(IBlockState state, World world, BlockPos pos, int signalLength) {
        boolean open = (Boolean)state.func_177229_b((IProperty)field_176519_b) == false;
        BlockDoor.EnumDoorHalf half = (BlockDoor.EnumDoorHalf)state.func_177229_b((IProperty)field_176523_O);
        BlockPos otherHalfPos = pos.func_177972_a(half == BlockDoor.EnumDoorHalf.UPPER ? EnumFacing.DOWN : EnumFacing.UP);
        world.func_180498_a(null, open ? 1005 : 1011, pos, 0);
        world.func_175656_a(pos, state.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)));
        world.func_175656_a(otherHalfPos, world.func_180495_p(otherHalfPos).func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)));
        world.func_175704_b(pos, otherHalfPos);
        if (open && signalLength > 0) {
            world.func_175684_a(pos, (Block)this, signalLength);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new KeypadDoorBlockEntity();
    }

    @Override
    public Item getDoorItem() {
        return SCContent.keypadDoorItem;
    }
}

