/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SecurityCameraBlock
extends DisguisableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final AxisAlignedBB NORTH = new AxisAlignedBB((double)0.275f, 0.25, (double)0.15f, (double)0.7f, (double)0.8f, 1.0);
    private static final AxisAlignedBB EAST = new AxisAlignedBB(0.0, 0.25, (double)0.275f, (double)0.85f, (double)0.8f, (double)0.725f);
    private static final AxisAlignedBB SOUTH = new AxisAlignedBB((double)0.275f, 0.25, 0.0, (double)0.7f, (double)0.8f, (double)0.85f);
    private static final AxisAlignedBB WEST = new AxisAlignedBB(0.125, 0.25, (double)0.275f, 1.0, (double)0.8f, (double)0.725f);
    private static final AxisAlignedBB DOWN = new AxisAlignedBB(0.3125, 0.875, 0.3125, 0.6875, 1.0, 0.6875);

    public SecurityCameraBlock(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.destroyTimeForOwner = 5.0f;
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity be;
        if (player.func_184586_b(hand).func_77973_b() != SCContent.cameraMonitor && (be = world.func_175625_s(pos)) instanceof SecurityCameraBlockEntity && ((SecurityCameraBlockEntity)be).isOwnedBy((Entity)player)) {
            if (!world.field_72995_K) {
                player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.SINGLE_LENS.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SecurityCameraBlockEntity) {
            if (!ConfigHandler.vanillaToolBlockBreaking) {
                ((SecurityCameraBlockEntity)te).dropAllModules();
            }
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((SecurityCameraBlockEntity)te).getLensContainer());
        }
        super.func_180663_b(world, pos, state);
        world.func_175685_c(pos.func_177978_c(), world.func_180495_p(pos).func_177230_c(), true);
        world.func_175685_c(pos.func_177968_d(), world.func_180495_p(pos).func_177230_c(), true);
        world.func_175685_c(pos.func_177974_f(), world.func_180495_p(pos).func_177230_c(), true);
        world.func_175685_c(pos.func_177976_e(), world.func_180495_p(pos).func_177230_c(), true);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (dir == EnumFacing.SOUTH) {
            return SOUTH;
        }
        if (dir == EnumFacing.NORTH) {
            return NORTH;
        }
        if (dir == EnumFacing.WEST) {
            return WEST;
        }
        if (dir == EnumFacing.DOWN) {
            return DOWN;
        }
        return EAST;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        return field_185506_k;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        if (!world.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing)) {
            for (EnumFacing newFacing : EnumFacing.Plane.HORIZONTAL) {
                if (!world.isSideSolid(pos.func_177972_a(newFacing.func_176734_d()), newFacing)) continue;
                state = state.func_177226_a((IProperty)FACING, (Comparable)newFacing);
                break;
            }
        }
        return state;
    }

    public void mountCamera(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            int cz;
            int cx;
            EntityPlayerMP serverPlayer = (EntityPlayerMP)player;
            WorldServer serverWorld = (WorldServer)world;
            BlockPos pos = new BlockPos(x, y, z);
            Chunk chunk = serverWorld.func_175726_f(pos);
            ChunkPos chunkPos = chunk.func_76632_l();
            int viewDistance = serverPlayer.field_71133_b.func_184103_al().func_72395_o();
            TileEntity te = world.func_175625_s(pos);
            ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)SecurityCraft.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
            if (serverPlayer.func_175398_C() instanceof SecurityCamera) {
                serverPlayer.func_175398_C().func_70106_y();
            }
            SecurityCamera dummyEntity = new SecurityCamera(world, x, y, z);
            ticket.bindEntity((Entity)dummyEntity);
            dummyEntity.setChunkTicket(ticket);
            for (cx = chunkPos.field_77276_a - viewDistance; cx <= chunkPos.field_77276_a + viewDistance; ++cx) {
                for (cz = chunkPos.field_77275_b - viewDistance; cz <= chunkPos.field_77275_b + viewDistance; ++cz) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(cx, cz));
                }
            }
            for (cx = chunkPos.field_77276_a - viewDistance; cx <= chunkPos.field_77276_a + viewDistance; ++cx) {
                for (cz = chunkPos.field_77275_b - viewDistance; cz <= chunkPos.field_77275_b + viewDistance; ++cz) {
                    serverWorld.func_184164_w().func_187302_c(cx, cz).func_187276_a(serverPlayer);
                }
            }
            serverPlayer.field_175401_bS = dummyEntity;
            world.func_72838_d((Entity)dummyEntity);
            SecurityCraft.network.sendTo((IMessage)new SetCameraView(dummyEntity), serverPlayer);
            for (EntityTrackerEntry entry : serverWorld.func_73039_n().field_72793_b) {
                entry.func_73117_b(serverPlayer);
            }
            if (te instanceof SecurityCameraBlockEntity) {
                ((SecurityCameraBlockEntity)te).startViewing();
            }
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP && world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && ((IModuleInventory)world.func_175625_s(pos)).isModuleEnabled(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && ((IModuleInventory)world.func_175625_s(pos)).isModuleEnabled(ModuleType.REDSTONE) && state.func_177229_b((IProperty)FACING) == side) {
            return 15;
        }
        return 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos) && !this.func_176198_a(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta] == EnumFacing.UP ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new SecurityCameraBlockEntity();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.func_176740_k() != EnumFacing.Axis.Z) break;
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
            case FRONT_BACK: {
                if (facing.func_176740_k() != EnumFacing.Axis.X) break;
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
        }
        return state;
    }
}

