/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.entity.BouncingBetty;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BouncingBettyBlock
extends ExplosiveBlock {
    public static final PropertyBool DEACTIVATED = PropertyBool.func_177716_a((String)"deactivated");

    public BouncingBettyBlock(Material material) {
        super(material);
        this.destroyTimeForOwner = 3.5f;
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.2f, (double)0.8f);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151579_a) {
            if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                world.func_175655_b(pos, true);
            } else {
                this.explode(world, pos);
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(!state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos).func_186662_g(0.01).func_72326_a(entity.func_174813_aQ()) || Utils.doesEntityOwn(entity, world, pos) || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() || ((IOwnable)world.func_175625_s(pos)).allowsOwnableEntity(entity))) {
            this.explode(world, pos);
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d && !Utils.doesEntityOwn((Entity)player, world, pos)) {
            this.explode(world, pos);
        }
    }

    @Override
    public boolean activateMine(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (world.field_72995_K || ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            return;
        }
        BouncingBetty bouncingBetty = new BouncingBetty(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
        world.func_175698_g(pos);
        bouncingBetty.setFuse(15);
        bouncingBetty.field_70181_x = 0.5;
        Utils.addScheduledTask(world, () -> world.func_72838_d((Entity)bouncingBetty));
        bouncingBetty.func_184185_a(SoundEvents.field_187904_gd, 1.0f, 1.0f);
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DEACTIVATED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new OwnableBlockEntity();
    }
}

