/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import com.google.common.base.Predicate;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ClaymoreBlock
extends ExplosiveBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool DEACTIVATED = PropertyBool.func_177716_a((String)"deactivated");
    public static final AxisAlignedBB NS_BOUNDING_BOX;
    public static final AxisAlignedBB EW_BOUNDING_BOX;

    public ClaymoreBlock(Material material) {
        super(material);
        this.destroyTimeForOwner = 3.5f;
        this.setHarvestLevel("pickaxe", 1);
        this.field_181083_K = MapColor.field_193574_Z;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity be = world.func_175625_s(pos);
        if (be instanceof ClaymoreBlockEntity && ((ClaymoreBlockEntity)be).isOwnedBy((Entity)player)) {
            if (!world.field_72995_K) {
                player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.SINGLE_LENS.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151579_a) {
            world.func_175655_b(pos, true);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ClaymoreBlockEntity) {
            if (!ConfigHandler.vanillaToolBlockBreaking) {
                ((ClaymoreBlockEntity)te).dropAllModules();
            }
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((ClaymoreBlockEntity)te).getLensContainer());
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().isSideSolid(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        ClaymoreBlockEntity claymore;
        if (!(player.field_71075_bZ.field_75098_d || world.field_72995_K || ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue() || !(claymore = (ClaymoreBlockEntity)world.func_175625_s(pos)).getTargetingMode().allowsPlayers() || claymore.isOwnedBy((Entity)player) && claymore.ignoresOwner())) {
            this.explode(world, pos);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        IBlockState state;
        if (!world.field_72995_K && (state = world.func_180495_p(pos)).func_177227_a().contains(DEACTIVATED) && !((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(world, pos);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean activateMine(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            world.func_175655_b(pos, false);
            world.func_72885_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ConfigHandler.smallerMineExplosion ? 1.5f : 3.5f, ConfigHandler.shouldSpawnFire, ConfigHandler.mineExplosionsBreakBlocks);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: 
            case SOUTH: {
                return NS_BOUNDING_BOX;
            }
            case EAST: 
            case WEST: {
                return EW_BOUNDING_BOX;
            }
        }
        return Block.field_185505_j;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED) == false;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new ClaymoreBlockEntity();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    static {
        float px = 0.0625f;
        NS_BOUNDING_BOX = new AxisAlignedBB((double)(4.0f * px), 0.0, (double)(6.0f * px), (double)(12.0f * px), (double)(7.0f * px), (double)(10.0f * px));
        EW_BOUNDING_BOX = new AxisAlignedBB((double)(10.0f * px), 0.0, (double)(12.0f * px), (double)(6.0f * px), (double)(7.0f * px), (double)(4.0f * px));
    }
}

