/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.ReinforcedDoorBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReinforcedDoorBlock
extends BlockDoor
implements ITileEntityProvider {
    private final float destroyTimeForOwner;

    public ReinforcedDoorBlock(Material material) {
        super(material);
        this.func_149722_s();
        this.func_149672_a(SoundType.field_185852_e);
        this.destroyTimeForOwner = 5.0f;
        this.setHarvestLevel("pickaxe", 0);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.func_180647_a(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public boolean canHarvestBlock(IBlockAccess level, BlockPos pos, EntityPlayer player) {
        return ConfigHandler.alwaysDrop || super.canHarvestBlock(level, pos, player);
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.onNeighborChanged((IBlockAccess)world, pos, fromPos);
    }

    public void onNeighborChanged(IBlockAccess access, BlockPos firstDoorPos, BlockPos neighbor) {
        World level = (World)access;
        IBlockState firstDoorState = level.func_180495_p(firstDoorPos).func_185899_b(access, firstDoorPos);
        Block neighborBlock = level.func_180495_p(neighbor).func_177230_c();
        if (firstDoorState.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockBelow = firstDoorPos.func_177977_b();
            IBlockState stateBelow = level.func_180495_p(blockBelow);
            if (stateBelow.func_177230_c() != this) {
                level.func_175698_g(firstDoorPos);
            } else if (neighborBlock != this) {
                this.onNeighborChanged((IBlockAccess)level, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockAbove = firstDoorPos.func_177984_a();
            IBlockState stateAbove = level.func_180495_p(blockAbove);
            if (stateAbove.func_177230_c() != this) {
                level.func_175698_g(firstDoorPos);
                drop = true;
            }
            if (!level.isSideSolid(firstDoorPos.func_177977_b(), EnumFacing.UP)) {
                level.func_175698_g(firstDoorPos);
                drop = true;
                if (stateAbove.func_177230_c() == this) {
                    level.func_175698_g(blockAbove);
                }
            }
            if (drop) {
                if (!level.field_72995_K) {
                    this.func_176226_b(level, firstDoorPos, firstDoorState, 0);
                }
            } else if (neighborBlock != this) {
                boolean shouldBeOpen;
                boolean hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(level, firstDoorPos) || BlockUtils.hasActiveSCBlockNextTo(level, firstDoorPos.func_177984_a());
                EnumFacing directionToCheck = ((EnumFacing)firstDoorState.func_177229_b((IProperty)field_176520_a)).func_176746_e();
                BlockPos secondDoorPos = firstDoorPos.func_177972_a(directionToCheck);
                IBlockState secondDoorState = level.func_180495_p(secondDoorPos).func_185899_b(access, secondDoorPos);
                if (!(secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && secondDoorState.func_177229_b((IProperty)field_176521_M) == BlockDoor.EnumHingePosition.RIGHT && firstDoorState.func_177229_b((IProperty)field_176521_M) != secondDoorState.func_177229_b((IProperty)field_176521_M) || (secondDoorState = level.func_180495_p(secondDoorPos = firstDoorPos.func_177972_a(directionToCheck.func_176734_d())).func_185899_b(access, secondDoorPos)) != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && secondDoorState.func_177229_b((IProperty)field_176521_M) == BlockDoor.EnumHingePosition.LEFT && firstDoorState.func_177229_b((IProperty)field_176521_M) != secondDoorState.func_177229_b((IProperty)field_176521_M))) {
                    secondDoorPos = null;
                }
                boolean hasSecondDoorActiveSCBlock = secondDoorPos != null && (BlockUtils.hasActiveSCBlockNextTo(level, secondDoorPos) || BlockUtils.hasActiveSCBlockNextTo(level, secondDoorPos.func_177984_a()));
                boolean bl = shouldBeOpen = hasActiveSCBlock != hasSecondDoorActiveSCBlock || hasActiveSCBlock;
                if (shouldBeOpen != (Boolean)firstDoorState.func_177229_b((IProperty)field_176519_b)) {
                    this.setDoorState(level, firstDoorPos, firstDoorState, shouldBeOpen);
                }
                if (secondDoorPos != null && shouldBeOpen != (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b)) {
                    this.setDoorState(level, secondDoorPos, secondDoorState, shouldBeOpen);
                }
            }
        }
    }

    public void setDoorState(World level, BlockPos pos, IBlockState state, boolean open) {
        level.func_180501_a(pos, state.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 2);
        level.func_180498_a((EntityPlayer)null, open ? 1005 : 1011, pos, 0);
        level.func_175704_b(pos, pos);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (!ConfigHandler.vanillaToolBlockBreaking && te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        world.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te.func_145842_c(id, param);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(SCContent.reinforcedDoorItem);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : SCContent.reinforcedDoorItem;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new ReinforcedDoorBlockEntity();
    }
}

