/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.jei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.compat.jei.InventoryScannerGhostIngredientHandler;
import net.geforcemods.securitycraft.compat.jei.ReinforcerRecipe;
import net.geforcemods.securitycraft.compat.jei.SecurityCraftToVanillaCategory;
import net.geforcemods.securitycraft.compat.jei.SlotMover;
import net.geforcemods.securitycraft.compat.jei.VanillaToSecurityCraftCategory;
import net.geforcemods.securitycraft.screen.BlockChangeDetectorScreen;
import net.geforcemods.securitycraft.screen.BlockPocketManagerScreen;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

@JEIPlugin
public class SCJEIPlugin
implements IModPlugin {
    public static final String VTS_ID = "securitycraft:vanilla_to_securitycraft";
    public static final String STV_ID = "securitycraft:securitycraft_to_vanilla";

    public void register(IModRegistry registry) {
        ArrayList<ReinforcerRecipe> vtsRecipes = new ArrayList<ReinforcerRecipe>();
        ArrayList<ReinforcerRecipe> stvRecipes = new ArrayList<ReinforcerRecipe>();
        ItemStack vanillaCauldron = new ItemStack(Items.field_151066_bu);
        ItemStack reinforcedCauldron = new ItemStack(SCContent.reinforcedCauldron);
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new SlotMover<CustomizeBlockScreen>(CustomizeBlockScreen.class), new SlotMover<ProjectorScreen>(ProjectorScreen.class), new SlotMover<DisguiseModuleScreen>(DisguiseModuleScreen.class), new SlotMover<BlockChangeDetectorScreen>(BlockChangeDetectorScreen.class), new SlotMover<BlockPocketManagerScreen>(BlockPocketManagerScreen.class)});
        registry.addIngredientInfo((Object)new ItemStack(SCContent.adminTool), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.admin_tool"});
        registry.addIngredientInfo((Object)new ItemStack(SCContent.keypad), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.keypad"});
        registry.addIngredientInfo((Object)new ItemStack(SCContent.keypadChest), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.keypad_chest"});
        registry.addIngredientInfo((Object)new ItemStack(SCContent.keypadFurnace), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.keypad_furnace"});
        registry.addIngredientInfo((Object)new ItemStack((Block)SCContent.keypadTrapdoor), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.keypad_trapdoor"});
        IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.forEach((vanillaBlock, securityCraftBlock) -> {
            IReinforcedBlock reinforcedBlock = (IReinforcedBlock)securityCraftBlock;
            NonNullList subBlocks = NonNullList.func_191196_a();
            vanillaBlock.func_149666_a(CreativeTabs.field_78027_g, subBlocks);
            subBlocks.forEach(vanillaStack -> {
                if (!vanillaStack.func_190926_b()) {
                    ItemStack reinforcedStack = reinforcedBlock.convertToReinforcedStack((ItemStack)vanillaStack, (Block)vanillaBlock);
                    vtsRecipes.add(new ReinforcerRecipe((ItemStack)vanillaStack, reinforcedStack));
                    stvRecipes.add(new ReinforcerRecipe(reinforcedStack, (ItemStack)vanillaStack));
                }
            });
        });
        vtsRecipes.add(new ReinforcerRecipe(vanillaCauldron, reinforcedCauldron));
        stvRecipes.add(new ReinforcerRecipe(reinforcedCauldron, vanillaCauldron));
        registry.addRecipes(vtsRecipes, VTS_ID);
        registry.addRecipes(stvRecipes, STV_ID);
        registry.addRecipeCatalyst((Object)new ItemStack(SCContent.keypadFurnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(SCContent.universalBlockReinforcerLvL1), new String[]{VTS_ID});
        registry.addRecipeCatalyst((Object)new ItemStack(SCContent.universalBlockReinforcerLvL2), new String[]{VTS_ID, STV_ID});
        registry.addRecipeCatalyst((Object)new ItemStack(SCContent.universalBlockReinforcerLvL3), new String[]{VTS_ID, STV_ID});
        registry.addGhostIngredientHandler(InventoryScannerScreen.class, (IGhostIngredientHandler)new InventoryScannerGhostIngredientHandler());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new VanillaToSecurityCraftCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SecurityCraftToVanillaCategory(registration.getJeiHelpers().getGuiHelper())});
    }
}

