/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.vecmath.Vector3f;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.misc.GlobalPos;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import org.apache.commons.lang3.tuple.Pair;

public class CameraFeed {
    private final Set<BlockPos> linkedFrames = new HashSet<BlockPos>();
    private final AtomicDouble lastActiveTime = new AtomicDouble();
    private final List<RenderGlobal.ContainerLocalRenderInformation> sectionsInRange = new ArrayList<RenderGlobal.ContainerLocalRenderInformation>();
    private final Set<Long> sectionsInRangePositions = new HashSet<Long>();
    private final List<RenderGlobal.ContainerLocalRenderInformation> visibleSections = new ArrayList<RenderGlobal.ContainerLocalRenderInformation>();
    private final List<Pair<RenderChunk, Boolean>> compilingSectionsQueue = new ArrayList<Pair<RenderChunk, Boolean>>();
    private final Framebuffer renderTarget;
    private final boolean createdUsingVbo;
    private boolean requiresFrustumUpdate = false;
    private Vector3f backgroundColor = new Vector3f(0.0f, 0.0f, 0.0f);

    public CameraFeed(GlobalPos globalPos, RenderGlobal.ContainerLocalRenderInformation startingSection) {
        int resolution = ConfigHandler.frameFeedResolution;
        this.renderTarget = new Framebuffer(resolution, resolution, true);
        this.compilingSectionsQueue.add((Pair<RenderChunk, Boolean>)Pair.of((Object)startingSection.field_178036_a, (Object)false));
        this.sectionsInRange.add(startingSection);
        this.sectionsInRangePositions.add(startingSection.field_178036_a.func_178568_j().func_177986_g());
        this.createdUsingVbo = OpenGlHelper.func_176075_f();
        this.discoverVisibleSections(globalPos, FrameFeedHandler.getFrameFeedViewDistance(null));
    }

    public void requestFrustumUpdate() {
        this.requiresFrustumUpdate = true;
    }

    public boolean requiresFrustumUpdate() {
        return this.requiresFrustumUpdate;
    }

    public void discoverVisibleSections(GlobalPos cameraPos, int viewDistance) {
        ChunkPos cameraSectionPos = new ChunkPos(cameraPos.pos());
        ArrayDeque<Pair<RenderChunk, Boolean>> queueToCheck = new ArrayDeque<Pair<RenderChunk, Boolean>>(this.compilingSectionsQueue);
        this.compilingSectionsQueue.clear();
        while (!queueToCheck.isEmpty()) {
            RenderChunk currentSection = (RenderChunk)((Pair)queueToCheck.poll()).getLeft();
            BlockPos origin = currentSection.func_178568_j();
            CompiledChunk currentCompiledSection = currentSection.func_178571_g();
            if (!CameraFeed.hasAllNeighbors(currentSection)) {
                this.compilingSectionsQueue.add((Pair<RenderChunk, Boolean>)Pair.of((Object)currentSection, (Object)false));
                continue;
            }
            if (currentCompiledSection == CompiledChunk.field_178502_a) {
                this.compilingSectionsQueue.add((Pair<RenderChunk, Boolean>)Pair.of((Object)currentSection, (Object)true));
                continue;
            }
            for (EnumFacing dir : EnumFacing.values()) {
                long neighbourPosAsLong;
                RenderChunk neighbourSection;
                int cx = (origin.func_177958_n() >> 4) + dir.func_82601_c();
                int cy = (origin.func_177956_o() >> 4) + dir.func_96559_d();
                int cz = (origin.func_177952_p() >> 4) + dir.func_82599_e();
                if (!Utils.isInViewDistance(cameraSectionPos.field_77276_a, cameraSectionPos.field_77275_b, viewDistance, cx, cz) || (neighbourSection = CameraViewAreaExtension.rawFetch(cx, cy, cz, true)) == null || this.sectionsInRangePositions.contains(neighbourPosAsLong = neighbourSection.func_178568_j().func_177986_g()) || !CameraFeed.canSeeNeighborFace(currentCompiledSection, dir)) continue;
                RenderGlobal renderGlobal = Minecraft.func_71410_x().field_71438_f;
                renderGlobal.getClass();
                RenderGlobal.ContainerLocalRenderInformation neighbourChunkInfo = new RenderGlobal.ContainerLocalRenderInformation(renderGlobal, neighbourSection, null, 0);
                this.sectionsInRange.add(neighbourChunkInfo);
                this.sectionsInRangePositions.add(neighbourSection.func_178568_j().func_177986_g());
                this.compilingSectionsQueue.add((Pair<RenderChunk, Boolean>)Pair.of((Object)neighbourChunkInfo.field_178036_a, (Object)false));
                this.requestFrustumUpdate();
            }
        }
    }

    private static boolean hasAllNeighbors(RenderChunk renderChunk) {
        int chunkZ;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos chunkBlockPos = renderChunk.func_178568_j();
        int chunkX = chunkBlockPos.func_177958_n() >> 4;
        return !world.func_72964_e(chunkX + 1, chunkZ = chunkBlockPos.func_177952_p() >> 4).func_76621_g() && !world.func_72964_e(chunkX - 1, chunkZ).func_76621_g() && !world.func_72964_e(chunkX, chunkZ + 1).func_76621_g() && !world.func_72964_e(chunkX, chunkZ - 1).func_76621_g();
    }

    private static boolean canSeeNeighborFace(CompiledChunk currentCompiledSection, EnumFacing dir) {
        for (int j = 0; j < EnumFacing.values().length; ++j) {
            if (!currentCompiledSection.func_178495_a(EnumFacing.values()[j].func_176734_d(), dir)) continue;
            return true;
        }
        return false;
    }

    public void updateVisibleSections(Frustum frustum) {
        this.requiresFrustumUpdate = false;
        this.visibleSections.clear();
        for (RenderGlobal.ContainerLocalRenderInformation section : this.sectionsInRange) {
            AxisAlignedBB bb = section.field_178036_a.field_178591_c;
            if (frustum != null && !frustum.func_78548_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f)) continue;
            this.visibleSections.add(section);
        }
    }

    public void applyVisibleSections(List<RenderGlobal.ContainerLocalRenderInformation> currentRenderChunks, Set<RenderChunk> currentChunksToCompile) {
        currentRenderChunks.clear();
        currentRenderChunks.addAll(this.visibleSections);
        currentChunksToCompile.clear();
        currentChunksToCompile.addAll(this.getSectionsToCompile());
    }

    public boolean hasVisibleSections() {
        return !this.visibleSections.isEmpty();
    }

    public List<RenderChunk> getSectionsToCompile() {
        return this.compilingSectionsQueue.stream().filter(p -> (Boolean)p.getRight() != false && (((RenderChunk)p.getLeft()).field_178599_i == null || !((RenderChunk)p.getLeft()).field_178599_i.func_178537_h())).map(Pair::getLeft).collect(Collectors.toList());
    }

    public List<RenderChunk> getDirtyRenderChunks() {
        ArrayList<RenderChunk> dirtyRenderChunks = new ArrayList<RenderChunk>();
        for (RenderGlobal.ContainerLocalRenderInformation container : this.sectionsInRange) {
            RenderChunk renderChunk = container.field_178036_a;
            if (!renderChunk.func_178569_m()) continue;
            dirtyRenderChunks.add(renderChunk);
        }
        return dirtyRenderChunks;
    }

    public boolean hasFrameInFrustum(Frustum frustum) {
        for (BlockPos framePos : this.linkedFrames) {
            AxisAlignedBB bb = new AxisAlignedBB(framePos);
            if (!frustum.func_78548_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f)) continue;
            return true;
        }
        return false;
    }

    public void linkFrame(FrameBlockEntity be) {
        this.linkedFrames.add(be.func_174877_v());
    }

    public void unlinkFrame(FrameBlockEntity be) {
        this.linkedFrames.remove(be.func_174877_v());
    }

    public boolean isFrameLinked(FrameBlockEntity be) {
        return this.linkedFrames.contains(be.func_174877_v());
    }

    public void markForRemoval() {
        this.linkedFrames.clear();
    }

    public boolean shouldBeRemoved() {
        return this.linkedFrames.isEmpty();
    }

    public AtomicDouble lastActiveTime() {
        return this.lastActiveTime;
    }

    public Framebuffer renderTarget() {
        return this.renderTarget;
    }

    public Vector3f backgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Vector3f newColor) {
        this.backgroundColor = newColor;
    }

    public boolean usesVbo() {
        return this.createdUsingVbo;
    }
}

