/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.chunk.ListedRenderChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CameraViewAreaExtension {
    private static final Long2ObjectOpenHashMap<RenderChunk> SECTIONS = new Long2ObjectOpenHashMap();

    private CameraViewAreaExtension() {
    }

    public static RenderChunk provideSection(long sectionPos) {
        RenderChunk section = (RenderChunk)SECTIONS.get(sectionPos);
        if (section == null || section instanceof ListedRenderChunk == OpenGlHelper.func_176075_f()) {
            section = CameraViewAreaExtension.createSection(sectionPos);
            SECTIONS.put(sectionPos, (Object)section);
        }
        return section;
    }

    private static RenderChunk createSection(long sectionPos) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockPos sectionOrigin = CameraViewAreaExtension.sectionLongToBlockPos(sectionPos);
        RenderChunk chunkRender = OpenGlHelper.func_176075_f() ? new RenderChunk((World)mc.field_71441_e, mc.field_71438_f, 0) : new ListedRenderChunk((World)mc.field_71441_e, mc.field_71438_f, 0);
        chunkRender.func_189562_a(sectionOrigin.func_177958_n(), sectionOrigin.func_177956_o(), sectionOrigin.func_177952_p());
        return chunkRender;
    }

    public static void setDirty(int cx, int cy, int cz, boolean playerChanged) {
        RenderChunk section = CameraViewAreaExtension.rawFetch(cx, cy, cz, false);
        if (section != null) {
            section.func_178575_a(playerChanged);
        }
    }

    public static void onChunkUnload(int sectionX, int sectionZ) {
        for (int sectionY = 0; sectionY < 16; ++sectionY) {
            SECTIONS.remove(CameraViewAreaExtension.sectionPosToLong(sectionX, sectionY, sectionZ));
        }
    }

    public static RenderChunk rawFetch(int cx, int cy, int cz, boolean generateNew) {
        if (cy < 0 || cy >= 16) {
            return null;
        }
        long sectionPos = CameraViewAreaExtension.sectionPosToLong(cx, cy, cz);
        return generateNew ? CameraViewAreaExtension.provideSection(sectionPos) : (RenderChunk)SECTIONS.get(sectionPos);
    }

    private static long sectionPosToLong(int sx, int sy, int sz) {
        long sectionPosAsLong = 0L;
        sectionPosAsLong |= ((long)sx & 0x3FFFFFL) << 42;
        sectionPosAsLong |= (long)sy & 0xFFFFFL;
        return sectionPosAsLong |= ((long)sz & 0x3FFFFFL) << 20;
    }

    private static BlockPos sectionLongToBlockPos(long sectionPosAsLong) {
        return new BlockPos((double)(sectionPosAsLong >> 42 << 4), (double)(sectionPosAsLong << 44 >> 44 << 4), (double)(sectionPosAsLong << 22 >> 42 << 4));
    }

    public static void clear() {
        for (RenderChunk section : SECTIONS.values()) {
            section.func_178566_a();
        }
        SECTIONS.clear();
    }
}

