/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.blockentities.ReinforcedCauldronBlockEntity;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ColorableItem
extends Item {
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (state.func_177230_c() instanceof BlockCauldron) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof ReinforcedCauldronBlockEntity && !((ReinforcedCauldronBlockEntity)te).isAllowedToInteract(player)) {
                return EnumActionResult.FAIL;
            }
            int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            if (level > 0 && this.hasColor(stack)) {
                this.removeColor(stack);
                ((BlockCauldron)state.func_177230_c()).func_176590_a(world, pos, state, level - 1);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        this.extraHandling(stack, world, player);
        return EnumActionResult.SUCCESS;
    }

    public boolean hasColor(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("display", 10) && tag.func_74775_l("display").func_150297_b("color", 3);
    }

    public int getColor(ItemStack stack) {
        NBTTagCompound displayTag;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (displayTag = tag.func_74775_l("display")) != null && displayTag.func_150297_b("color", 3)) {
            return displayTag.func_74762_e("color");
        }
        return this.getDefaultColor();
    }

    public int getDefaultColor() {
        return -1;
    }

    public void removeColor(ItemStack stack) {
        NBTTagCompound displayTag;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (displayTag = tag.func_74775_l("display")).func_74764_b("color")) {
            displayTag.func_82580_o("color");
        }
    }

    public void setColor(ItemStack stack, int color) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        NBTTagCompound displayTag = tag.func_74775_l("display");
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)displayTag);
        }
        displayTag.func_74768_a("color", color);
    }

    public void extraHandling(ItemStack stack, World level, EntityPlayer player) {
    }
}

