/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.LinkingStateItemPropertyHandler;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SentryRemoteAccessToolItem
extends Item {
    public SentryRemoteAccessToolItem() {
        this.func_185043_a(LinkingStateItemPropertyHandler.LINKING_STATE_PROPERTY, LinkingStateItemPropertyHandler::sentryRemoteAccessTool);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            this.updateTagWithNames(stack, world);
            player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.SRAT.ordinal(), world, player.func_184102_h().func_184103_al().func_72372_a(), (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        List sentries = world.func_72872_a(Sentry.class, new AxisAlignedBB(pos));
        if (!sentries.isEmpty()) {
            Sentry sentry = (Sentry)sentries.get(0);
            BlockPos sentryPos = sentry.func_180425_c();
            if (!SentryRemoteAccessToolItem.isSentryAdded(stack, sentryPos)) {
                int nextAvailableSlot = SentryRemoteAccessToolItem.getNextAvailableSlot(stack);
                if (nextAvailableSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:srat.noSlots", new Object[0]), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                if (!sentry.isOwnedBy((Entity)player)) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:srat.cantBind", new Object[0]), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74783_a("sentry" + nextAvailableSlot, new int[]{sentryPos.func_177958_n(), sentryPos.func_177956_o(), sentryPos.func_177952_p()});
                stack.func_77978_p().func_74778_a("sentry" + nextAvailableSlot + "_name", sentry.func_95999_t());
                if (!world.field_72995_K) {
                    SecurityCraft.network.sendTo((IMessage)new UpdateNBTTagOnClient(stack), (EntityPlayerMP)player);
                }
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:srat.bound", sentryPos), TextFormatting.GREEN);
            } else {
                this.removeTagFromItemAndUpdate(stack, sentryPos, player);
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:srat.unbound", sentryPos), TextFormatting.RED);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            if (stack.func_77978_p().func_74759_k("sentry" + i).length > 0) {
                List sentries;
                int[] coords = stack.func_77978_p().func_74759_k("sentry" + i);
                if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) {
                    list.add("---");
                    continue;
                }
                BlockPos pos = new BlockPos(coords[0], coords[1], coords[2]);
                String nameKey = "sentry" + i + "_name";
                String nameToShow = null;
                nameToShow = stack.func_77978_p().func_74764_b(nameKey) ? stack.func_77978_p().func_74779_i(nameKey) : (!(sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72872_a(Sentry.class, new AxisAlignedBB(pos))).isEmpty() && ((Sentry)sentries.get(0)).func_145818_k_() ? ((Sentry)sentries.get(0)).func_95999_t() : Utils.localize("tooltip.securitycraft:sentry", i).func_150254_d());
                list.add(nameToShow + ": " + Utils.getFormattedCoordinates(pos).func_150255_a(Utils.GRAY_STYLE).func_150254_d());
                continue;
            }
            list.add("---");
        }
    }

    private void updateTagWithNames(ItemStack stack, World level) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        for (int i = 1; i <= 12; ++i) {
            int[] coords = tag.func_74759_k("sentry" + i);
            String nameKey = "sentry" + i + "_name";
            if (coords.length == 3 && (coords[0] != 0 || coords[1] != 0 || coords[2] != 0)) {
                Sentry sentry;
                BlockPos sentryPos = new BlockPos(coords[0], coords[1], coords[2]);
                if (!level.func_175668_a(sentryPos, false)) continue;
                List sentries = level.func_72872_a(Sentry.class, new AxisAlignedBB(sentryPos));
                if (!sentries.isEmpty() && (sentry = (Sentry)sentries.get(0)).func_145818_k_()) {
                    tag.func_74778_a(nameKey, sentry.func_95999_t());
                    continue;
                }
            }
            tag.func_82580_o(nameKey);
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("sentry" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            stack.func_77978_p().func_74783_a("sentry" + i, new int[]{0, 0, 0});
            if (!player.field_70170_p.field_72995_K) {
                SecurityCraft.network.sendTo((IMessage)new UpdateNBTTagOnClient(stack), (EntityPlayerMP)player);
            }
            return;
        }
    }

    public static boolean hasSentryAdded(NBTTagCompound tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords = tag.func_74759_k("sentry" + i);
            if (tag.func_74759_k("sentry" + i).length <= 0 || coords[0] == 0 && coords[1] == 0 && coords[2] == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isSentryAdded(ItemStack stack, BlockPos pos) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords = stack.func_77978_p().func_74759_k("sentry" + i);
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || coords[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    public static int getNextAvailableSlot(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 1;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] pos = stack.func_77978_p().func_74759_k("sentry" + i);
            if (pos.length != 0 && (pos[0] != 0 || pos[1] != 0 || pos[2] != 0)) continue;
            return i;
        }
        return 0;
    }
}

