/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public enum ModuleType {
    REDSTONE(SCContent.redstoneModule, "redstone_module"),
    ALLOWLIST(SCContent.allowlistModule, "whitelist_module"),
    DENYLIST(SCContent.denylistModule, "blacklist_module"),
    HARMING(SCContent.harmingModule, "harming_module"),
    SMART(SCContent.smartModule, "smart_module"),
    STORAGE(SCContent.storageModule, "storage_module"),
    DISGUISE(SCContent.disguiseModule, "disguise_module"),
    SPEED(SCContent.speedModule, "speed_module");

    private ModuleItem module;
    private String registryPath;

    private ModuleType(ModuleItem moduleItem, String registryPath) {
        this.module = moduleItem;
        this.registryPath = registryPath;
    }

    public ModuleItem getItem() {
        return this.module;
    }

    public String getTranslationKey() {
        return this.module.func_77658_a() + ".name";
    }

    public String getRegistryPath() {
        return this.registryPath;
    }

    public static void refresh() {
        for (ModuleType module : ModuleType.values()) {
            module.module = (ModuleItem)ForgeRegistries.ITEMS.getValue(new ResourceLocation("securitycraft", module.getRegistryPath()));
        }
    }
}

