/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import java.util.Arrays;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class}, priority=1100)
public class MinecraftMixin {
    @Shadow
    public EntityPlayerSP field_71439_g;

    @ModifyConstant(method={"processKeyBinds"}, constant={@Constant(intValue=2)})
    private int securitycraft$resetView(int i) {
        if (ClientProxy.isPlayerMountedOnCamera()) {
            return -1;
        }
        return i;
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;runTickKeyboard()V", shift=At.Shift.AFTER)})
    private void securitycraft$updateCameraKeyBindings(CallbackInfo callback) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)this.field_71439_g)) {
            CameraController.handleKeybinds();
        }
    }

    @Inject(method={"setRenderViewEntity"}, at={@At(value="HEAD")})
    private void securitycraft$onSetCameraEntity(Entity newCameraEntity, CallbackInfo ci) {
        if (ConfigHandler.debugCameraResetTracing && Minecraft.func_71410_x().func_175606_aa() instanceof SecurityCamera && !(newCameraEntity instanceof SecurityCamera)) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            StackTraceElement[] cutStacktrace = Arrays.copyOfRange(stacktrace, 1, stacktrace.length);
            Exception exception = new Exception();
            long millisSinceLastMount = CameraController.getMillisSinceLastMount();
            PlayerUtils.sendMessageToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITextComponent)Utils.localize(SCContent.securityCamera, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:security_camera.camera_reset_detected", millisSinceLastMount), TextFormatting.RED, true);
            SecurityCraft.LOGGER.warn("Detected camera entity reset {}ms after the camera was mounted. If this time interval is very short, a mod incompatibility could be at fault. See stacktrace below for potential culprits", (Object)millisSinceLastMount);
            exception.setStackTrace(cutStacktrace);
            exception.printStackTrace();
        }
    }
}

