/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SonicSecuritySystemModel;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SonicSecuritySystemRenderer
extends TileEntitySpecialRenderer<SonicSecuritySystemBlockEntity> {
    private static final SonicSecuritySystemModel MODEL = new SonicSecuritySystemModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/blocks/sonic_security_system.png");
    private static final TextComponentTranslation RECORDING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.recording", new Object[0]);
    private static final TextComponentTranslation LISTENING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.listening", new Object[0]);

    public void render(SonicSecuritySystemBlockEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        boolean recording = te.isRecording();
        BlockEntityRenderDelegate.DISGUISED_BLOCK.tryRenderDelegate(te, x, y, z, partialTicks, destroyStage, alpha);
        if (recording || te.isListening() && !te.isShutDown()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            this.func_190053_a(true);
            EntityRenderer.func_189692_a((FontRenderer)this.func_147498_b(), (String)(recording ? RECORDING_TEXT : LISTENING_TEXT).func_150254_d(), (float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f), (int)0, (float)player.field_70177_z, (float)player.field_70125_A, (boolean)false, (boolean)false);
            this.func_190053_a(false);
        }
        if (!te.isModuleEnabled(ModuleType.DISGUISE)) {
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
            MODEL.setRadarRotation(Utils.lerp(partialTicks, te.getOriginalRadarRotationDegrees(), te.getRadarRotationDegrees()));
            MODEL.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
        }
    }
}

