/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.inventory.BlockChangeDetectorMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.ClearChangeDetectorServer;
import net.geforcemods.securitycraft.network.server.SyncBlockChangeDetector;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.CollapsibleTextList;
import net.geforcemods.securitycraft.screen.components.ColorChooser;
import net.geforcemods.securitycraft.screen.components.ColorChooserButton;
import net.geforcemods.securitycraft.screen.components.ColorableScrollPanel;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class BlockChangeDetectorScreen
extends GuiContainer
implements IContainerListener,
IHasExtraAreas {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/block_change_detector.png");
    private final String title;
    private BlockChangeDetectorBlockEntity be;
    private ChangeEntryList changeEntryList;
    private StringHoverChecker[] hoverCheckers = new StringHoverChecker[5];
    private StringHoverChecker smartModuleHoverChecker;
    private CallbackCheckbox showAllCheckbox;
    private ColorChooser colorChooser;
    private final BlockChangeDetectorBlockEntity.EnumDetectionMode previousMode;
    private final boolean wasShowingHighlights;
    private final int previousColor;

    public BlockChangeDetectorScreen(InventoryPlayer inv, BlockChangeDetectorBlockEntity be) {
        super((Container)new BlockChangeDetectorMenu(inv, be));
        this.be = be;
        this.field_147002_h.func_75132_a((IContainerListener)this);
        this.field_146999_f = 200;
        this.field_147000_g = 256;
        this.previousMode = be.getMode();
        this.wasShowingHighlights = be.isShowingHighlights();
        this.previousColor = be.getColor();
        this.title = be.func_145748_c_().func_150254_d();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiButton clearButton = this.func_189646_b((GuiButton)new ClickButton(0, this.field_147003_i + 4, this.field_147009_r + 4, 8, 8, "x", b -> {
            this.changeEntryList.allEntries.clear();
            this.changeEntryList.filteredEntries.clear();
            this.be.getEntries().clear();
            this.be.func_70296_d();
            SecurityCraft.network.sendToServer((IMessage)new ClearChangeDetectorServer(this.be.func_174877_v()));
        }));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        boolean isOwner = this.be.isOwnedBy((Entity)this.field_146297_k.field_71439_g);
        int settingsX = this.field_147003_i + 173;
        ModeButton modeButton = (ModeButton)this.func_189646_b((GuiButton)new ModeButton(1, settingsX, this.field_147009_r + 19, 20, 20, this.previousMode.ordinal(), BlockChangeDetectorBlockEntity.EnumDetectionMode.values().length, b -> {
            this.be.setMode(BlockChangeDetectorBlockEntity.EnumDetectionMode.values()[((ModeButton)b).getCurrentIndex()]);
            this.changeEntryList.updateFilteredEntries();
            this.be.updateFilteredEntries();
        }));
        this.showAllCheckbox = (CallbackCheckbox)this.func_189646_b((GuiButton)new CallbackCheckbox(2, settingsX, this.field_147009_r + 65, 20, 20, "", false, isSelected -> this.changeEntryList.updateFilteredEntries(), 0x404040));
        CallbackCheckbox highlightInWorldCheckbox = (CallbackCheckbox)this.func_189646_b((GuiButton)new CallbackCheckbox(3, settingsX, this.field_147009_r + 90, 20, 20, "", this.be.isShowingHighlights(), isSelected -> this.be.showHighlights((boolean)isSelected), 0x404040));
        this.colorChooser = new ColorChooser(settingsX, this.field_147009_r + 135, this.previousColor, SCContent.blockChangeDetectorFloorCeiling){

            @Override
            public void onColorChange() {
                BlockChangeDetectorScreen.this.be.setColor(this.getRGBColor());
            }
        };
        this.colorChooser.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        GuiButton colorChooserButton = this.func_189646_b((GuiButton)new ColorChooserButton(4, settingsX, this.field_147009_r + 115, 20, 20, this.colorChooser));
        this.hoverCheckers[0] = new StringHoverChecker(clearButton, Utils.localize("gui.securitycraft:editModule.clear", new Object[0]).func_150254_d());
        this.hoverCheckers[1] = new StringHoverChecker((GuiButton)modeButton, Arrays.stream(BlockChangeDetectorBlockEntity.EnumDetectionMode.values()).map(e -> Utils.localize(e.getDescriptionId(), new Object[0]).func_150254_d()).collect(Collectors.toList()));
        this.hoverCheckers[2] = new StringHoverChecker((GuiButton)this.showAllCheckbox, Utils.localize("gui.securitycraft:block_change_detector.show_all_checkbox", new Object[0]).func_150254_d());
        this.hoverCheckers[3] = new StringHoverChecker((GuiButton)highlightInWorldCheckbox, Utils.localize("gui.securitycraft:block_change_detector.highlight_in_world_checkbox", new Object[0]).func_150254_d());
        this.hoverCheckers[4] = new StringHoverChecker(colorChooserButton, Utils.localize("gui.securitycraft:choose_outline_color_tooltip", new Object[0]).func_150254_d());
        this.smartModuleHoverChecker = isOwner ? new StringHoverChecker(this.field_147009_r + 44, this.field_147009_r + 60, settingsX + 1, this.field_147003_i + 191, Utils.localize("gui.securitycraft:block_change_detector.smart_module_hint", new Object[0]).func_150254_d()) : null;
        this.changeEntryList = new ChangeEntryList(this.field_146297_k, 160, 150, this.field_147009_r + 20, this.field_147003_i + 8);
        modeButton.field_146124_l = colorChooserButton.field_146124_l = isOwner;
        clearButton.field_146124_l = colorChooserButton.field_146124_l;
        for (BlockChangeDetectorBlockEntity.ChangeEntry entry : this.be.getEntries()) {
            String stateString = entry.state.func_177228_b().size() > 0 ? "[" + entry.state.toString().split("\\[")[1].replace(",", ", ") : "";
            List list = Arrays.asList(new Serializable[]{entry.player, entry.uuid, entry.action, Utils.getFormattedCoordinates(entry.pos).func_150254_d(), stateString, dateFormat.format(new Date(entry.timestamp))}).stream().map(Object::toString).filter(s -> !s.isEmpty()).map(TextComponentString::new).collect(Collectors.toList());
            Block block = entry.state.func_177230_c();
            int meta = block.func_176201_c(entry.state);
            ItemStack stack = new ItemStack(block, 1, meta);
            String blockName = stack.func_190926_b() ? Utils.localize(block, new Object[0]).func_150254_d() : Utils.localize(stack.func_77977_a() + ".name", new Object[0]).func_150254_d();
            this.changeEntryList.addEntry(new ContentSavingCollapsibleTextList(-1, 0, 0, 154, blockName, list, b -> this.changeEntryList.setOpen((ContentSavingCollapsibleTextList)((Object)b)), this.changeEntryList::isHovered, entry));
        }
        this.changeEntryList.updateFilteredEntries();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 6, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (StringHoverChecker hoverChecker : this.hoverCheckers) {
            if (hoverChecker == null || !hoverChecker.checkHover(mouseX, mouseY)) continue;
            this.func_146279_a(hoverChecker.getName(), mouseX, mouseY);
        }
        if (this.smartModuleHoverChecker != null && this.smartModuleHoverChecker.checkHover(mouseX, mouseY) && !this.be.isModuleEnabled(ModuleType.SMART)) {
            this.func_146283_a(this.smartModuleHoverChecker.getLines(), mouseX, mouseY);
        }
        if (this.changeEntryList != null) {
            this.changeEntryList.renderLongMessageTooltips();
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.changeEntryList != null) {
            this.changeEntryList.drawScreen(mouseX, mouseY);
        }
        if (this.colorChooser != null) {
            this.colorChooser.func_73863_a(mouseX, mouseY, partialTicks);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        Slot hoveredSlot = this.getSlotUnderMouse();
        if (keyCode == 1 || !this.colorChooser.getRgbHexBox().func_146206_l() && this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.func_146983_a(keyCode);
        if (hoveredSlot != null && hoveredSlot.func_75216_d()) {
            if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(keyCode)) {
                this.func_184098_a(hoveredSlot, hoveredSlot.field_75222_d, 0, ClickType.CLONE);
            } else if (this.field_146297_k.field_71474_y.field_74316_C.isActiveAndMatches(keyCode)) {
                this.func_184098_a(hoveredSlot, hoveredSlot.field_75222_d, BlockChangeDetectorScreen.func_146271_m() ? 1 : 0, ClickType.THROW);
            }
        }
        if (this.colorChooser != null) {
            this.colorChooser.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.colorChooser != null) {
            this.colorChooser.func_73876_c();
        }
        if (this.changeEntryList != null) {
            this.changeEntryList.tick();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.changeEntryList != null && this.changeEntryList.mouseClicked(mouseX, mouseY, button)) {
            return;
        }
        if (this.colorChooser != null) {
            this.colorChooser.func_73864_a(mouseX, mouseY, button);
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.colorChooser != null) {
            this.colorChooser.func_146286_b(mouseX, mouseY, state);
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    public void func_146281_b() {
        super.func_146281_b();
        BlockChangeDetectorBlockEntity.EnumDetectionMode currentMode = this.be.getMode();
        boolean isShowingHighlights = this.be.isShowingHighlights();
        int currentColor = this.be.getColor();
        if (this.previousMode != currentMode || this.wasShowingHighlights != isShowingHighlights || this.previousColor != currentColor) {
            SecurityCraft.network.sendToServer((IMessage)new SyncBlockChangeDetector(this.be.func_174877_v(), currentMode, isShowingHighlights, currentColor));
        }
        this.be.updateFilteredEntries();
    }

    public void func_71111_a(Container container, int slotIndex, ItemStack stack) {
        if (slotIndex == 0 && this.changeEntryList != null) {
            this.changeEntryList.updateFilteredEntries();
            this.be.updateFilteredEntries();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.changeEntryList != null) {
            this.changeEntryList.handleMouseInput(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c, this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1);
        }
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> stacks) {
    }

    public void func_71112_a(Container container, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container container, IInventory inventory) {
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        if (this.colorChooser != null) {
            return this.colorChooser.getGuiExtraAreas();
        }
        return new ArrayList<Rectangle>();
    }

    class ContentSavingCollapsibleTextList
    extends CollapsibleTextList {
        private final BlockChangeDetectorBlockEntity.ChangeEntry changeEntry;

        public ContentSavingCollapsibleTextList(int id, int xPos, int yPos, int width, String displayString, List<? extends ITextComponent> textLines, Consumer<CollapsibleTextList> onPress, BiPredicate<Integer, Integer> extraHoverCheck, BlockChangeDetectorBlockEntity.ChangeEntry changeEntry) {
            super(id, xPos, yPos, width, displayString, textLines, onPress, extraHoverCheck);
            this.changeEntry = changeEntry;
        }

        public BlockChangeDetectorBlockEntity.ChangeEntry getChangeEntry() {
            return this.changeEntry;
        }
    }

    class ModeButton
    extends ClickButton
    implements IToggleableButton {
        private final ItemStack ironPickaxe;
        private final ItemStack grassBlock;
        private final int toggleCount;
        private int currentIndex;

        public ModeButton(int id, int xPos, int yPos, int width, int height, int initialIndex, int toggleCount, Consumer<ClickButton> onPress) {
            super(id, xPos, yPos, width, height, "", onPress);
            this.ironPickaxe = new ItemStack(Items.field_151035_b);
            this.grassBlock = new ItemStack((Block)Blocks.field_150349_c);
            this.currentIndex = 0;
            this.toggleCount = toggleCount;
            this.currentIndex = initialIndex;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
            super.func_191745_a(mc, mouseX, mouseY, partial);
            if (this.currentIndex == BlockChangeDetectorBlockEntity.EnumDetectionMode.BREAK.ordinal()) {
                GuiUtils.drawItemStackToGui(this.ironPickaxe, this.field_146128_h + 2, this.field_146129_i + 2, false);
            } else if (this.currentIndex == BlockChangeDetectorBlockEntity.EnumDetectionMode.PLACE.ordinal()) {
                GuiUtils.drawItemStackToGui(this.grassBlock, this.field_146128_h + 2, this.field_146129_i + 2, true);
            } else if (this.currentIndex == BlockChangeDetectorBlockEntity.EnumDetectionMode.BOTH.ordinal()) {
                float blitOffset = mc.func_175599_af().field_77023_b;
                mc.func_175599_af().field_77023_b = -50.0f;
                GuiUtils.drawItemStackToGui(this.grassBlock, this.field_146128_h + 2, this.field_146129_i + 2, true);
                mc.func_175599_af().field_77023_b = blitOffset;
                GuiUtils.drawItemStackToGui(this.ironPickaxe, this.field_146128_h + 2, this.field_146129_i + 2, false);
            }
        }

        @Override
        public void onClick() {
            this.setCurrentIndex(this.currentIndex + 1);
            super.onClick();
        }

        @Override
        public int getCurrentIndex() {
            return this.currentIndex;
        }

        @Override
        public void setCurrentIndex(int newIndex) {
            this.currentIndex = Math.floorMod(newIndex, this.toggleCount);
        }
    }

    class ChangeEntryList
    extends ColorableScrollPanel {
        private List<ContentSavingCollapsibleTextList> allEntries;
        private List<ContentSavingCollapsibleTextList> filteredEntries;
        private ContentSavingCollapsibleTextList currentlyOpen;
        private int contentHeight;

        public ChangeEntryList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, top + height, left, 12, new ColorableScrollPanel.Color(0, 0, 0, 0), new ColorableScrollPanel.Color(0, 0, 0, 0));
            this.allEntries = new ArrayList<ContentSavingCollapsibleTextList>();
            this.filteredEntries = new ArrayList<ContentSavingCollapsibleTextList>();
            this.currentlyOpen = null;
            this.contentHeight = 0;
        }

        @Override
        public int getContentHeight() {
            return this.contentHeight;
        }

        @Override
        public void drawScreen(int mouseX, int mouseY) {
            int height = 0;
            for (int i = 0; i < this.filteredEntries.size(); ++i) {
                ContentSavingCollapsibleTextList entry = this.filteredEntries.get(i);
                entry.field_146129_i = this.top + height - (int)this.scrollDistance;
                entry.field_146125_m = entry.field_146129_i + entry.getHeight() > this.top && entry.field_146129_i < this.bottom;
                height += entry.getHeight();
            }
            this.applyScrollLimits();
            super.drawScreen(mouseX, mouseY);
        }

        @Override
        public void drawPanel(int entryRight, int relativeY, Tessellator tesselator, int mouseX, int mouseY) {
            for (int i = 0; i < this.filteredEntries.size(); ++i) {
                this.filteredEntries.get(i).func_191745_a(BlockChangeDetectorScreen.this.field_146297_k, mouseX, mouseY, 0.0f);
            }
        }

        public void renderLongMessageTooltips() {
            for (int i = 0; i < this.filteredEntries.size(); ++i) {
                this.filteredEntries.get(i).renderLongMessageTooltip();
            }
        }

        public void tick() {
            this.filteredEntries.forEach(CollapsibleTextList::tick);
        }

        public void addEntry(ContentSavingCollapsibleTextList entry) {
            entry.func_175211_a(154);
            entry.setHeight(this.slotHeight);
            entry.field_146128_h = this.left;
            entry.setY(this.top + this.slotHeight * this.allEntries.size());
            this.allEntries.add(entry);
        }

        public void setOpen(ContentSavingCollapsibleTextList newOpenedTextList) {
            if (this.currentlyOpen == null) {
                this.currentlyOpen = newOpenedTextList;
            } else if (this.currentlyOpen == newOpenedTextList) {
                this.currentlyOpen = null;
            } else {
                this.currentlyOpen.switchOpenStatus();
                this.currentlyOpen = newOpenedTextList;
            }
            this.recalculateContentHeight();
        }

        public boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.left && mouseY >= this.top && mouseX < this.right && mouseY < this.bottom;
        }

        public void updateFilteredEntries() {
            this.allEntries.forEach(e -> {
                e.field_146124_l = false;
            });
            this.filteredEntries = !BlockChangeDetectorScreen.this.showAllCheckbox.selected() ? new ArrayList<ContentSavingCollapsibleTextList>(this.allEntries.stream().filter(e -> BlockChangeDetectorScreen.this.be.isEntryShown(e.getChangeEntry())).collect(Collectors.toList())) : new ArrayList<ContentSavingCollapsibleTextList>(this.allEntries);
            this.filteredEntries.forEach(e -> {
                e.field_146124_l = true;
            });
            this.recalculateContentHeight();
        }

        public void recalculateContentHeight() {
            int height = this.filteredEntries.stream().reduce(0, (accumulated, ctl) -> accumulated + ctl.getMaximumHeight(), (identity, accumulated) -> identity + accumulated);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            this.contentHeight = height;
            if (this.currentlyOpen != null) {
                this.scrollDistance = this.slotHeight * this.filteredEntries.indexOf((Object)this.currentlyOpen);
            }
            this.applyScrollLimits();
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (button == 0) {
                for (GuiButton guiButton : this.filteredEntries) {
                    if (!guiButton.func_146116_c(BlockChangeDetectorScreen.this.field_146297_k, mouseX, mouseY)) continue;
                    GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)BlockChangeDetectorScreen.this, guiButton, BlockChangeDetectorScreen.this.field_146292_n);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                    GuiButton guiButton2 = event.getButton();
                    guiButton2.func_146113_a(BlockChangeDetectorScreen.this.field_146297_k.func_147118_V());
                    BlockChangeDetectorScreen.this.func_146284_a(guiButton2);
                    if (!BlockChangeDetectorScreen.this.equals(BlockChangeDetectorScreen.this.field_146297_k.field_71462_r)) continue;
                    MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)BlockChangeDetectorScreen.this, guiButton2, BlockChangeDetectorScreen.this.field_146292_n));
                }
            }
            return mouseY >= this.top && mouseY <= this.bottom && mouseX >= this.right - 6 && mouseX <= this.right;
        }

        @Override
        public int getSize() {
            return 0;
        }
    }
}

