/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.screen.components.ColorableScrollPanel;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.IngredientDisplay;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class SCManualScreen
extends GuiScreen {
    private static final ResourceLocation PAGE = new ResourceLocation("securitycraft:textures/gui/info_book_texture.png");
    private static final ResourceLocation PAGE_WITH_SCROLL = new ResourceLocation("securitycraft:textures/gui/info_book_texture_special.png");
    private static final ResourceLocation TITLE_PAGE = new ResourceLocation("securitycraft:textures/gui/info_book_title_page.png");
    private static final ResourceLocation BOOK_ICONS = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private static final ResourceLocation VANILLA_BOOK = new ResourceLocation("textures/gui/book.png");
    private static final int SUBPAGE_LENGTH = 1285;
    private static int lastPage = -1;
    private final String intro1 = Utils.localize("gui.securitycraft:scManual.intro.1", new Object[0]).func_150255_a(new Style().func_150228_d(Boolean.valueOf(true))).func_150254_d();
    private final String ourPatrons = Utils.localize("gui.securitycraft:scManual.patreon.title", new Object[0]).func_150254_d();
    private List<HoverChecker> hoverCheckers = new ArrayList<HoverChecker>();
    private int currentPage = lastPage;
    private NonNullList<Ingredient> recipe;
    private IngredientDisplay[] displays = new IngredientDisplay[9];
    private int startX = -1;
    private List<String> subpages = new ArrayList<String>();
    private List<String> author = new ArrayList<String>();
    private int currentSubpage = 0;
    private List<String> intro2;
    private PatronList patronList;
    private GuiButton patreonLinkButton;
    private boolean explosive;
    private boolean ownable;
    private boolean passcodeProtected;
    private boolean viewActivated;
    private boolean customizable;
    private boolean lockable;
    private boolean moduleInventory;
    private IngredientDisplay pageIcon;
    private String pageTitle;
    private String designedBy;

    public void func_73866_w_() {
        int startY = 2;
        this.startX = (this.field_146294_l - 256) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.func_189646_b(new ChangePageButton(1, this.startX + 210, startY + 188, true));
        this.func_189646_b(new ChangePageButton(2, this.startX + 16, startY + 188, false));
        this.func_189646_b(new ChangePageButton(3, this.startX + 180, startY + 97, true));
        this.func_189646_b(new ChangePageButton(4, this.startX + 155, startY + 97, false));
        this.patreonLinkButton = this.func_189646_b((GuiButton)new HyperlinkButton(5, this.startX + 225, 143, 16, 16, ""));
        this.patronList = new PatronList(this.field_146297_k, 115, 90, 50, this.startX + 125);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.displays[i * 3 + j] = new IngredientDisplay(this.startX + 101 + j * 19, 144 + i * 19);
            }
        }
        this.pageIcon = new IngredientDisplay(this.startX + 19, 22);
        this.updateRecipeAndIcons();
        SCManualItem.PAGES.sort((page1, page2) -> {
            String key1 = page1.getTitle().func_150254_d();
            String key2 = page2.getTitle().func_150254_d();
            return key1.compareTo(key2);
        });
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currentPage == -1) {
            this.field_146297_k.func_110434_K().func_110577_a(TITLE_PAGE);
        } else if (this.recipe != null || SCManualItem.PAGES.get(this.currentPage).isRecipeDisabled()) {
            this.field_146297_k.func_110434_K().func_110577_a(PAGE);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(PAGE_WITH_SCROLL);
        }
        this.func_73729_b(this.startX, 5, 0, 0, 256, 250);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_191745_a(this.field_146297_k, mouseX, mouseY, 0.0f);
        }
        if (this.currentPage > -1) {
            String pageNumberText = this.currentPage + 2 + "/" + (SCManualItem.PAGES.size() + 1);
            if (this.subpages.size() > 1) {
                this.field_146289_q.func_78276_b(this.currentSubpage + 1 + "/" + this.subpages.size(), this.startX + 205, 102, 9339504);
            }
            if (this.designedBy != null) {
                this.field_146289_q.func_78279_b(this.designedBy, this.startX + 18, 150, 75, 0);
            }
            this.field_146289_q.func_175065_a(this.pageTitle, (float)(this.startX + 39), 27.0f, 0, false);
            this.field_146289_q.func_78276_b(pageNumberText, this.startX + 240 - this.field_146289_q.func_78256_a(pageNumberText), 182, 9339504);
            this.field_146289_q.func_78279_b(this.subpages.get(this.currentSubpage), this.startX + 18, 45, 225, 0);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            this.pageIcon.render(partialTicks);
            for (IngredientDisplay display : this.displays) {
                if (display == null) continue;
                display.render(partialTicks);
            }
            this.field_146297_k.func_110434_K().func_110577_a(BOOK_ICONS);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.explosive) {
                this.func_73729_b(this.startX + 107, 117, 54, 1, 18, 18);
            }
            if (this.ownable) {
                this.func_73729_b(this.startX + 29, 118, 1, 1, 16, 16);
            }
            if (this.passcodeProtected) {
                this.func_73729_b(this.startX + 55, 118, 18, 1, 17, 16);
            }
            if (this.viewActivated) {
                this.func_73729_b(this.startX + 81, 118, 36, 1, 17, 16);
            }
            if (this.customizable) {
                this.func_73729_b(this.startX + 136, 118, 88, 1, 16, 16);
            }
            if (this.moduleInventory) {
                this.func_73729_b(this.startX + 163, 118, 105, 1, 16, 16);
            }
            if (this.lockable) {
                this.func_73729_b(this.startX + 189, 118, 154, 1, 16, 16);
            }
            if (this.customizable || this.moduleInventory) {
                this.func_73729_b(this.startX + 213, 118, 72, 1, 16, 16);
            }
            for (int i = 0; i < this.hoverCheckers.size(); ++i) {
                HoverChecker chc = this.hoverCheckers.get(i);
                if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
                if (chc instanceof StringHoverChecker && ((StringHoverChecker)chc).getName() != null) {
                    this.func_146283_a(((StringHoverChecker)chc).getLines(), mouseX, mouseY);
                    continue;
                }
                if (i >= this.displays.length || this.displays[i].getCurrentStack().func_190926_b()) continue;
                this.func_146285_a(this.displays[i].getCurrentStack(), mouseX, mouseY);
            }
        } else {
            String text;
            int i;
            String pageNumberText = "1/" + (SCManualItem.PAGES.size() + 1);
            this.field_146289_q.func_175065_a(this.intro1, (float)(this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.intro1) / 2), 22.0f, 0, false);
            for (i = 0; i < this.intro2.size(); ++i) {
                text = this.intro2.get(i);
                this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, 150 + 10 * i, 0);
            }
            for (i = 0; i < this.author.size(); ++i) {
                text = this.author.get(i);
                this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, 180 + 10 * i, 0);
            }
            if (this.patronList != null) {
                this.patronList.drawScreen(mouseX, mouseY);
            }
            this.field_146289_q.func_78276_b(pageNumberText, this.startX + 240 - this.field_146289_q.func_78256_a(pageNumberText), 182, 9339504);
            this.field_146289_q.func_78276_b(this.ourPatrons, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.ourPatrons) / 2 + 30, 40, 0);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.pageIcon.tick();
        for (IngredientDisplay display : this.displays) {
            display.tick();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        lastPage = this.currentPage;
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 203) {
            this.previousSubpage();
        } else if (keyCode == 205) {
            this.nextSubpage();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            this.nextPage();
        } else if (button.field_146127_k == 2) {
            this.previousPage();
        } else if (button.field_146127_k == 3) {
            this.nextSubpage();
        } else if (button.field_146127_k == 4) {
            this.previousSubpage();
        } else if (button.field_146127_k == this.patreonLinkButton.field_146127_k) {
            this.func_175276_a(new TextComponentString("").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/Geforce"))));
            return;
        }
        ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
        ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (ClientUtils.hasShiftDown()) {
            for (IngredientDisplay display : this.displays) {
                if (display == null) continue;
                display.changeRenderingStack(-Mouse.getEventDWheel());
            }
            if (this.pageIcon != null) {
                this.pageIcon.changeRenderingStack(-Mouse.getEventDWheel());
            }
            return;
        }
        if (this.currentPage == -1 && this.patronList != null && this.patronList.isHovering() && !this.patronList.patrons.isEmpty()) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.patronList.handleMouseInput(mouseX, mouseY);
            return;
        }
        if (ClientUtils.hasCtrlDown() && this.subpages.size() > 1) {
            switch ((int)Math.signum(Mouse.getEventDWheel())) {
                case -1: {
                    this.nextSubpage();
                    break;
                }
                case 1: {
                    this.previousSubpage();
                }
            }
            return;
        }
        switch ((int)Math.signum(Mouse.getEventDWheel())) {
            case -1: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
            }
        }
        ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
        ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
    }

    private void nextPage() {
        ++this.currentPage;
        if (this.currentPage > SCManualItem.PAGES.size() - 1) {
            this.currentPage = -1;
        }
        this.updateRecipeAndIcons();
    }

    private void previousPage() {
        --this.currentPage;
        if (this.currentPage < -1) {
            this.currentPage = SCManualItem.PAGES.size() - 1;
        }
        this.updateRecipeAndIcons();
    }

    private void nextSubpage() {
        ++this.currentSubpage;
        if (this.currentSubpage == this.subpages.size()) {
            this.currentSubpage = 0;
        }
    }

    private void previousSubpage() {
        --this.currentSubpage;
        if (this.currentSubpage == -1) {
            this.currentSubpage = this.subpages.size() - 1;
        }
    }

    private void updateRecipeAndIcons() {
        Object inWorldObj;
        int i2;
        this.currentSubpage = 0;
        this.hoverCheckers.clear();
        boolean bl = this.patreonLinkButton.field_146125_m = this.currentPage == -1;
        if (this.currentPage < 0) {
            for (IngredientDisplay display : this.displays) {
                display.setIngredient(Ingredient.field_193370_a);
            }
            this.pageIcon.setIngredient(Ingredient.field_193370_a);
            ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = false;
            ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = false;
            this.recipe = null;
            if (I18n.func_188566_a((String)"gui.securitycraft:scManual.author")) {
                this.author = this.field_146289_q.func_78271_c(Utils.localize("gui.securitycraft:scManual.author", new Object[0]).func_150254_d(), 180);
            } else {
                this.author.clear();
            }
            this.intro2 = this.field_146289_q.func_78271_c(Utils.localize("gui.securitycraft:scManual.intro.2", new Object[0]).func_150254_d(), 203);
            this.patronList.fetchPatrons();
            return;
        }
        SCManualPage page = SCManualItem.PAGES.get(this.currentPage);
        String designerName = page.getDesignedBy();
        Item item = page.getItem();
        PageGroup pageType = page.getPageType();
        this.designedBy = designerName != null && !designerName.isEmpty() ? Utils.localize("gui.securitycraft:scManual.designedBy", designerName).func_150254_d() : null;
        this.recipe = null;
        if (pageType == PageGroup.SINGLE_ITEM) {
            for (int o = 0; o < CraftingManager.field_193380_a.func_148742_b().size(); ++o) {
                IRecipe object = (IRecipe)CraftingManager.field_193380_a.func_148754_a(o);
                if (object instanceof ShapedRecipes) {
                    ShapedRecipes shapedRecipe = (ShapedRecipes)object;
                    ItemStack resultStack = shapedRecipe.func_77571_b();
                    Item resultItem = resultStack.func_77973_b();
                    if (resultItem != item || resultItem == SCContent.lens && SCContent.lens.hasColor(resultStack)) continue;
                    NonNullList ingredients = shapedRecipe.func_192400_c();
                    NonNullList recipeItems = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
                    for (i2 = 0; i2 < ingredients.size(); ++i2) {
                        recipeItems.set(this.getCraftMatrixPosition(i2, shapedRecipe.func_192403_f(), shapedRecipe.func_192404_g()), ingredients.get(i2));
                    }
                    this.recipe = recipeItems;
                } else {
                    ShapelessRecipes shapelessRecipe;
                    if (!(object instanceof ShapelessRecipes) || (shapelessRecipe = (ShapelessRecipes)object).func_77571_b().func_77973_b() != page.getItem() || shapelessRecipe.getRegistryName().func_110623_a().endsWith("_reset")) continue;
                    NonNullList recipeItems = NonNullList.func_191197_a((int)shapelessRecipe.field_77579_b.size(), (Object)Ingredient.field_193370_a);
                    for (int i3 = 0; i3 < recipeItems.size(); ++i3) {
                        recipeItems.set(i3, shapelessRecipe.field_77579_b.get(i3));
                    }
                    this.recipe = recipeItems;
                }
                break;
            }
        } else if (pageType.hasRecipeGrid()) {
            this.recipe = null;
            HashMap<Integer, ItemStack[]> recipeStacks = new HashMap<Integer, ItemStack[]>();
            List pageItems = Arrays.stream(pageType.getItems().func_193365_a()).map(ItemStack::func_77973_b).collect(Collectors.toList());
            int stacksLeft = pageItems.size();
            for (int i4 = 0; i4 < 9; ++i4) {
                recipeStacks.put(i4, new ItemStack[pageItems.size()]);
            }
            for (int o = 0; o < CraftingManager.field_193380_a.func_148742_b().size() && stacksLeft != 0; ++o) {
                ShapelessRecipes shapelessRecipe;
                int indexToAddAt;
                ItemStack[] items;
                NonNullList ingredients;
                Option<?>[] object = (Option<?>[])CraftingManager.field_193380_a.func_148754_a(o);
                if (object instanceof ShapedRecipes) {
                    ShapedRecipes shapedRecipe = (ShapedRecipes)object;
                    if (shapedRecipe.func_77571_b().func_190926_b() || !pageItems.contains(shapedRecipe.func_77571_b().func_77973_b())) continue;
                    ingredients = shapedRecipe.func_192400_c();
                    for (i2 = 0; i2 < ingredients.size(); ++i2) {
                        items = ((Ingredient)ingredients.get(i2)).func_193365_a();
                        if (items.length == 0) continue;
                        indexToAddAt = pageItems.indexOf(shapedRecipe.func_77571_b().func_77973_b());
                        ((ItemStack[])recipeStacks.get((Object)Integer.valueOf((int)this.getCraftMatrixPosition((int)i2, (int)shapedRecipe.func_192403_f(), (int)shapedRecipe.func_192404_g()))))[indexToAddAt] = items[0];
                    }
                    --stacksLeft;
                    continue;
                }
                if (!(object instanceof ShapelessRecipes) || (shapelessRecipe = (ShapelessRecipes)object).func_77571_b().func_190926_b() || !pageItems.contains(shapelessRecipe.func_77571_b().func_77973_b()) || shapelessRecipe.getRegistryName().func_110623_a().endsWith("_reset")) continue;
                ingredients = shapelessRecipe.func_192400_c();
                for (i2 = 0; i2 < ingredients.size(); ++i2) {
                    items = ((Ingredient)ingredients.get(i2)).func_193365_a();
                    if (items.length == 0) continue;
                    indexToAddAt = pageItems.indexOf(shapelessRecipe.func_77571_b().func_77973_b());
                    ((ItemStack[])recipeStacks.get((Object)Integer.valueOf((int)i2)))[indexToAddAt] = items[0];
                }
                --stacksLeft;
            }
            this.recipe = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
            recipeStacks.forEach((i, stackArray) -> {
                Ingredient cfr_ignored_0 = (Ingredient)this.recipe.set(i.intValue(), (Object)Ingredient.func_193369_a((ItemStack[])Arrays.stream(stackArray).map(s -> s == null ? ItemStack.field_190927_a : s).collect(Collectors.toList()).toArray((T[])stackArray)));
            });
        }
        if (pageType == PageGroup.REINFORCED || item == Item.func_150898_a((Block)SCContent.reinforcedHopper)) {
            this.recipe = null;
            this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, Utils.localize("gui.securitycraft:scManual.recipe.reinforced", new Object[0]).func_150254_d()));
        } else if (this.recipe != null) {
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    this.hoverCheckers.add(new HoverChecker(144 + row * 19, 144 + row * 19 + 16, this.startX + 101 + column * 19, this.startX + 101 + column * 19 + 16));
                }
            }
        } else if (page.isRecipeDisabled()) {
            this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]).func_150254_d()));
        } else {
            String name = page.getItem().getRegistryName().func_110623_a();
            this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, Utils.localize("gui.securitycraft:scManual.recipe." + name, new Object[0]).func_150254_d()));
        }
        this.pageTitle = page.getTitle().func_150254_d();
        if (pageType != PageGroup.SINGLE_ITEM) {
            this.pageIcon.setIngredient(pageType.getItems());
        } else {
            this.pageIcon.setIngredient(Ingredient.func_193367_a((Item)page.getItem()));
        }
        this.resetTileEntityInfo();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            this.explosive = block instanceof IExplosive;
            if (this.explosive) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 107, this.startX + 107 + 16, Utils.localize("gui.securitycraft:scManual.explosiveBlock", new Object[0]).func_150254_d()));
            }
        }
        if ((inWorldObj = page.getInWorldObject()) != null) {
            IModuleInventory moduleInv;
            ICustomizable scte;
            Option<?>[] options;
            this.ownable = inWorldObj instanceof IOwnable;
            this.passcodeProtected = inWorldObj instanceof IPasscodeProtected;
            this.viewActivated = inWorldObj instanceof IViewActivated;
            this.lockable = inWorldObj instanceof ILockable;
            if (this.ownable) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 29, this.startX + 29 + 16, Utils.localize("gui.securitycraft:scManual.ownableBlock", new Object[0]).func_150254_d()));
            }
            if (this.passcodeProtected) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 55, this.startX + 55 + 16, Utils.localize("gui.securitycraft:scManual.passcodeProtectedBlock", new Object[0]).func_150254_d()));
            }
            if (this.viewActivated) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 81, this.startX + 81 + 16, Utils.localize("gui.securitycraft:scManual.viewActivatedBlock", new Object[0]).func_150254_d()));
            }
            if (inWorldObj instanceof ICustomizable && (options = (scte = (ICustomizable)inWorldObj).customOptions()).length > 0) {
                ArrayList<String> display = new ArrayList<String>();
                this.customizable = true;
                display.add(Utils.localize("gui.securitycraft:scManual.options", new Object[0]).func_150254_d());
                display.add("---");
                for (Option<?> option : options) {
                    display.add(new TextComponentTranslation("gui.securitycraft:scManual.option_text", new Object[]{Utils.localize(option.getDescriptionKey(Utils.getLanguageKeyDenotation(scte)), new Object[0]), option.getDefaultInfo()}).func_150254_d());
                    display.add("");
                }
                display.remove(display.size() - 1);
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 136, this.startX + 136 + 16, display));
            }
            if (inWorldObj instanceof IModuleInventory && (moduleInv = (IModuleInventory)inWorldObj).acceptedModules() != null && moduleInv.acceptedModules().length > 0) {
                ArrayList<String> display = new ArrayList<String>();
                this.moduleInventory = true;
                display.add(Utils.localize("gui.securitycraft:scManual.modules", new Object[0]).func_150254_d());
                display.add("---");
                for (ModuleType module : moduleInv.acceptedModules()) {
                    display.add(Utils.localize(moduleInv.getModuleDescriptionId(Utils.getLanguageKeyDenotation(inWorldObj), module), new Object[0]).func_150254_d());
                    display.add("");
                }
                display.remove(display.size() - 1);
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 163, this.startX + 163 + 16, display));
            }
            if (this.lockable) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 189, this.startX + 189 + 16, Utils.localize("gui.securitycraft:scManual.lockable", new Object[0]).func_150254_d()));
            }
            if (this.customizable || this.moduleInventory) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 213, this.startX + 213 + 16, Utils.localize("gui.securitycraft:scManual.customizableBlock", new Object[0]).func_150254_d()));
            }
        }
        if (this.recipe != null && !this.recipe.isEmpty()) {
            for (int i5 = 0; i5 < 3; ++i5) {
                for (int j = 0; j < 3; ++j) {
                    int index = i5 * 3 + j;
                    if (index >= this.recipe.size()) {
                        this.displays[index].setIngredient(Ingredient.field_193370_a);
                        continue;
                    }
                    this.displays[index].setIngredient((Ingredient)this.recipe.get(index));
                }
            }
        } else {
            for (IngredientDisplay display : this.displays) {
                display.setIngredient(Ingredient.field_193370_a);
            }
        }
        String helpInfo = page.getHelpInfo().func_150254_d();
        this.subpages.clear();
        while (this.field_146289_q.func_78256_a(helpInfo) > 1285) {
            String trimmed = this.field_146289_q.func_78269_a(helpInfo, 1285);
            int temp = trimmed.lastIndexOf(32);
            if (temp > 0) {
                trimmed = trimmed.trim().substring(0, temp);
            }
            trimmed = trimmed.trim();
            this.subpages.add(trimmed);
            helpInfo = helpInfo.replace(trimmed, "").trim();
        }
        this.subpages.add(helpInfo);
    }

    private void resetTileEntityInfo() {
        this.explosive = false;
        this.ownable = false;
        this.passcodeProtected = false;
        this.viewActivated = false;
        this.customizable = false;
        this.lockable = false;
        this.moduleInventory = false;
    }

    private int getCraftMatrixPosition(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    class HyperlinkButton
    extends GuiButtonExt {
        public HyperlinkButton(int id, int xPos, int yPos, int width, int height, String displayString) {
            super(id, xPos, yPos, width, height, displayString);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(BOOK_ICONS);
                boolean bl = this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                if (this.field_146123_n) {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 138, 1, 16, 16);
                } else {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 122, 1, 16, 16);
                }
            }
        }
    }

    static class ChangePageButton
    extends GuiButton {
        private final int textureY;

        public ChangePageButton(int index, int xPos, int yPos, boolean forward) {
            super(index, xPos, yPos, 23, 13, "");
            this.textureY = forward ? 192 : 205;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean isHovering = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(VANILLA_BOOK);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, isHovering ? 23 : 0, this.textureY, 23, 13);
            }
        }
    }

    class PatronList
    extends ColorableScrollPanel {
        private final ExecutorService executor;
        private Future<List<String>> patronRequestFuture;
        private List<String> patrons;
        private boolean patronsAvailable;
        private boolean error;
        private boolean patronsRequested;
        private final List<String> fetchErrorLines;
        private final List<String> noPatronsLines;
        private final String loadingText;

        public PatronList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, top + height, left, 12, new ColorableScrollPanel.Color(192, 191, 187, 178), new ColorableScrollPanel.Color(208, 191, 187, 178), new ColorableScrollPanel.Color(142, 130, 112, 255), new ColorableScrollPanel.Color(128, 112, 85, 255), new ColorableScrollPanel.Color(209, 191, 161, 255));
            this.executor = Executors.newSingleThreadExecutor();
            this.patrons = new ArrayList<String>();
            this.patronsAvailable = false;
            this.error = false;
            this.loadingText = Utils.localize("gui.securitycraft:scManual.patreon.loading", new Object[0]).func_150254_d();
            this.fetchErrorLines = SCManualScreen.this.field_146289_q.func_78271_c(Utils.localize("gui.securitycraft:scManual.patreon.error", new Object[0]).func_150254_d(), this.listWidth);
            this.noPatronsLines = SCManualScreen.this.field_146289_q.func_78271_c(Utils.localize("advancements.empty", new Object[0]).func_150254_d(), this.listWidth - 10);
        }

        @Override
        public int getSize() {
            return this.patrons.size();
        }

        @Override
        public int getContentHeight() {
            int height = this.patrons.size() * (((SCManualScreen)SCManualScreen.this).field_146289_q.field_78288_b + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        @Override
        public void drawScreen(int mouseX, int mouseY) {
            if (this.patronsAvailable) {
                super.drawScreen(mouseX, mouseY);
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 4.0f);
                int slotIndex = mouseListY / this.slotHeight;
                int baseY = this.top + 4 - (int)this.scrollDistance;
                if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.patrons.size() && mouseY >= this.top && mouseY <= this.bottom) {
                    String patron = this.patrons.get(slotIndex);
                    int length = SCManualScreen.this.field_146289_q.func_78256_a(patron);
                    if (length >= this.listWidth - 6) {
                        SCManualScreen.this.func_146279_a(patron, this.left - 10, baseY + (this.slotHeight * slotIndex + this.slotHeight));
                        GlStateManager.func_179140_f();
                    }
                }
                if (this.patrons.isEmpty()) {
                    for (int i = 0; i < this.noPatronsLines.size(); ++i) {
                        String line = this.noPatronsLines.get(i);
                        SCManualScreen.this.field_146289_q.func_78276_b(line, this.left + this.listWidth / 2 - SCManualScreen.this.field_146289_q.func_78256_a(line) / 2, this.top + 30 + i * 10, -13421773);
                    }
                }
            } else if (this.error) {
                for (int i = 0; i < this.fetchErrorLines.size(); ++i) {
                    String line = this.fetchErrorLines.get(i);
                    SCManualScreen.this.field_146289_q.func_78276_b(line, this.left + this.listWidth / 2 - SCManualScreen.this.field_146289_q.func_78256_a(line) / 2, this.top + 30 + i * 10, -5242623);
                }
            } else if (this.patronRequestFuture != null && this.patronRequestFuture.isDone()) {
                try {
                    this.patrons = this.patronRequestFuture.get();
                    this.executor.shutdown();
                    this.patronsAvailable = true;
                }
                catch (InterruptedException | ExecutionException e) {
                    this.error = true;
                }
            } else {
                SCManualScreen.this.field_146289_q.func_78276_b(this.loadingText, this.left + this.listWidth / 2 - SCManualScreen.this.field_146289_q.func_78256_a(this.loadingText) / 2, this.top + 30, 0);
            }
        }

        @Override
        public void drawPanel(int entryRight, int relativeY, Tessellator tesselator, int mouseX, int mouseY) {
            for (int i = 0; i < this.patrons.size(); ++i) {
                String patron = this.patrons.get(i);
                if (patron == null || patron.isEmpty()) continue;
                SCManualScreen.this.field_146289_q.func_78276_b(patron, this.left + 2, relativeY + this.slotHeight * i, 0);
            }
        }

        public void fetchPatrons() {
            if (!this.patronsRequested) {
                this.patronRequestFuture = this.executor.submit(() -> {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL("https://gist.githubusercontent.com/bl4ckscor3/bdda6596012b1206816db034350b5717/raw").openStream()));){
                        List list = reader.lines().collect(Collectors.toList());
                        return list;
                    }
                    catch (IOException e) {
                        this.error = true;
                        return new ArrayList();
                    }
                });
                this.patronsRequested = true;
            }
        }
    }
}

