/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;

public class ToggleComponentButton
extends ClickButton
implements IToggleableButton {
    private final IntFunction<String> onValueChange;
    private int currentIndex = 0;
    private final int toggleCount;

    public ToggleComponentButton(int id, int xPos, int yPos, int width, int height, IntFunction<String> onValueChange, int initialValue, int toggleCount, Consumer<ClickButton> onPress) {
        super(id, xPos, yPos, width, height, "", button -> {
            onPress.accept((ClickButton)((Object)button));
            ((ToggleComponentButton)button).cycleIndex(1);
        });
        this.onValueChange = onValueChange;
        this.currentIndex = initialValue;
        this.toggleCount = toggleCount;
        this.onValueChange();
    }

    public void cycleIndex(int value) {
        this.setCurrentIndex(Math.floorMod(this.currentIndex + value, this.toggleCount));
        this.onValueChange();
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void setCurrentIndex(int newIndex) {
        this.currentIndex = newIndex % this.toggleCount;
        this.onValueChange();
    }

    public void onValueChange() {
        this.field_146126_j = this.onValueChange.apply(this.currentIndex);
    }
}

