/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamHandler;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.TextFormatting;

public class VanillaTeamHandler
implements TeamHandler {
    @Override
    public boolean areOnSameTeam(Owner owner1, Owner owner2) {
        ScorePlayerTeam team = TeamUtils.getVanillaTeamFromPlayer(owner1.getName());
        return team != null && team.func_96670_d().contains(owner2.getName());
    }

    @Override
    public TeamUtils.TeamRepresentation getTeamRepresentation(Owner owner) {
        ScorePlayerTeam team = TeamUtils.getVanillaTeamFromPlayer(owner.getName());
        if (team != null && team.func_96670_d().size() > 1) {
            TextFormatting color = team.func_178775_l();
            return new TeamUtils.TeamRepresentation(team.func_96669_c(), !color.func_96302_c() ? TextFormatting.GRAY : color);
        }
        return null;
    }

    @Override
    public Collection<EntityPlayerMP> getOnlinePlayersFromOwner(MinecraftServer server, Owner owner) {
        Collection onlinePlayers = null;
        ScorePlayerTeam team = TeamUtils.getVanillaTeamFromPlayer(owner.getName());
        if (team != null) {
            onlinePlayers = team.func_96670_d().stream().map(arg_0 -> ((PlayerList)server.func_184103_al()).func_152612_a(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (onlinePlayers == null || onlinePlayers.isEmpty()) {
            return PlayerUtils.getPlayerListFromOwner(owner);
        }
        return onlinePlayers;
    }
}

