/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IOwnable {
    public Owner getOwner();

    public void setOwner(String var1, String var2);

    default public boolean needsValidation() {
        return false;
    }

    default public void onValidate() {
    }

    default public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        BlockEntity be;
        if (this.needsValidation()) {
            this.getOwner().setValidated(false);
            if (player != null) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.ownerInvalidated", new Object[0]), ChatFormatting.GREEN);
            }
        }
        if ((be = (BlockEntity)this) instanceof LinkableBlockEntity) {
            LinkableBlockEntity linkable = (LinkableBlockEntity)be;
            linkable.propagate((ILinkedAction)new ILinkedAction.OwnerChanged(this.getOwner()), linkable);
        }
        be.m_6596_();
    }

    default public boolean isOwnedBy(Entity entity) {
        Player player;
        return entity instanceof Player && this.isOwnedBy(player = (Player)entity, false);
    }

    default public boolean isOwnedBy(Player player, boolean ignoreMask) {
        return this.isOwnedBy(new Owner(player)) && (ignoreMask || this.isOwnedBy(PlayerUtils.getOwnerFromPlayerOrMask(player)));
    }

    default public boolean isOwnedBy(Owner otherOwner) {
        Owner self = this.getOwner();
        if (TeamUtils.areOnSameTeam(self, otherOwner)) {
            return true;
        }
        String selfUUID = self.getUUID();
        String otherUUID = otherOwner.getUUID();
        String otherName = otherOwner.getName();
        if (otherUUID != null && otherUUID.equals(selfUUID)) {
            return true;
        }
        return otherName != null && (selfUUID.equals("ownerUUID") || otherUUID.equals("ownerUUID")) && otherName.equals(self.getName());
    }

    default public boolean allowsOwnableEntity(OwnableEntity entity) {
        Owner beOwner = this.getOwner();
        return entity.m_21805_() != null && (entity.m_21805_().toString().equals(beOwner.getUUID()) || TeamUtils.areOnSameTeam(beOwner, new Owner((Entity)entity.m_269323_())));
    }

    default public boolean ignoresOwner() {
        return false;
    }
}

