/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class KeycardReaderBlockEntity
extends DisguisableBlockEntity
implements MenuProvider,
ILockable,
ICodebreakable {
    protected boolean[] acceptedLevels = new boolean[]{true, false, false, false, false};
    protected int signature = 0;
    protected Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    protected Option.IntOption signalLength = new Option.SignalLengthOption(60);
    protected Option.DisabledOption disabled = new Option.DisabledOption(false);

    public KeycardReaderBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.KEYCARD_READER_BLOCK_ENTITY.get(), pos, state);
    }

    public KeycardReaderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag acceptedLevelsTag = new CompoundTag();
        for (int i = 1; i <= 5; ++i) {
            acceptedLevelsTag.m_128379_("lvl" + i, this.acceptedLevels[i - 1]);
        }
        tag.m_128365_("acceptedLevels", (Tag)acceptedLevelsTag);
        tag.m_128405_("signature", this.signature);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("passLV")) {
            boolean oldRequiresExactKeycard = false;
            int oldPassLV = tag.m_128451_("passLV") - 1;
            if (tag.m_128441_("requiresExactKeycard")) {
                oldRequiresExactKeycard = tag.m_128471_("requiresExactKeycard");
            }
            for (int i = 0; i < 5; ++i) {
                this.acceptedLevels[i] = oldRequiresExactKeycard ? i == oldPassLV : i >= oldPassLV;
            }
        }
        if (tag.m_128425_("acceptedLevels", 10)) {
            CompoundTag acceptedLevelsTag = tag.m_128469_("acceptedLevels");
            for (int i = 1; i <= 5; ++i) {
                this.acceptedLevels[i - 1] = acceptedLevelsTag.m_128471_("lvl" + i);
            }
        }
        this.signature = tag.m_128451_("signature");
        if (tag.m_128441_("sendMessage")) {
            this.sendDenylistMessage.setValue(tag.m_128471_("sendMessage"));
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(Player player) {
        if (this.isDisabled()) {
            player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) == false;
    }

    @Override
    public void useCodebreaker(Player player) {
        if (!this.f_58857_.f_46443_) {
            this.activate();
        }
    }

    public InteractionResult onRightClickWithActionItem(ItemStack stack, InteractionHand hand, Player player, boolean isCodebreaker, boolean isKeycardHolder) {
        if (isCodebreaker) {
            double chance = (Double)ConfigHandler.SERVER.codebreakerChance.get();
            if (chance < 0.0) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_58900_().m_60734_().m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
            } else {
                if (!player.m_7500_() && (this.isOwnedBy((Entity)player) || CodebreakerItem.wasRecentlyUsed(stack))) {
                    return InteractionResult.PASS;
                }
                boolean isSuccessful = player.m_7500_() || SecurityCraft.RANDOM.nextDouble() < chance;
                CompoundTag tag = stack.m_41784_();
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                tag.m_128356_("last_used_time", System.currentTimeMillis());
                tag.m_128379_("was_successful", isSuccessful);
                if (isSuccessful) {
                    this.activate();
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.CODEBREAKER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                }
            }
        } else if (isKeycardHolder) {
            ItemContainer holderInventory = ItemContainer.keycardHolder(stack);
            MutableComponent feedback = null;
            for (int i = 0; i < holderInventory.m_6643_(); ++i) {
                ItemStack keycardStack = holderInventory.m_8020_(i);
                if (!(keycardStack.m_41720_() instanceof KeycardItem) || !keycardStack.m_41782_() || (feedback = this.insertCard(keycardStack, player)) != null) continue;
                holderInventory.save(stack.m_41784_());
                return InteractionResult.SUCCESS;
            }
            if (feedback == null) {
                PlayerUtils.sendMessageToPlayer(player, Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_()), Utils.localize("messages.securitycraft:keycard_holder.no_keycards", new Object[0]), ChatFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_()), Utils.localize("messages.securitycraft:keycard_holder.fail", new Object[0]), ChatFormatting.RED);
            }
        } else {
            MutableComponent feedback = this.insertCard(stack, player);
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer(player, Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_()), feedback, ChatFormatting.RED);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public MutableComponent insertCard(ItemStack stack, Player player) {
        boolean powered;
        CompoundTag tag = stack.m_41783_();
        Owner keycardOwner = new Owner(tag.m_128461_("ownerName"), tag.m_128461_("ownerUUID"));
        String usableBy = tag.m_128461_("usable_by");
        if (!TeamUtils.areOnSameTeam(this.getOwner(), keycardOwner) || !this.getOwner().getUUID().equals(keycardOwner.getUUID())) {
            return Component.m_237115_((String)"messages.securitycraft:keycardReader.differentOwner");
        }
        if (!usableBy.isBlank() && !usableBy.equals(player.m_36316_().getName())) {
            return Component.m_237115_((String)"messages.securitycraft:keycardReader.cantUse");
        }
        if (this.getSignature() != tag.m_128451_("signature")) {
            return Component.m_237115_((String)"messages.securitycraft:keycardReader.wrongSignature");
        }
        int keycardLevel = ((KeycardItem)stack.m_41720_()).getLevel();
        if (!this.getAcceptedLevels()[keycardLevel]) {
            return Component.m_237110_((String)"messages.securitycraft:keycardReader.wrongLevel", (Object[])new Object[]{keycardLevel + 1});
        }
        boolean bl = powered = (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61448_) != false && this.getSignalLength() > 0;
        if (!powered) {
            if (tag.m_128471_("limited")) {
                int uses = tag.m_128451_("uses");
                if (uses <= 0) {
                    return Component.m_237115_((String)"messages.securitycraft:keycardReader.noUses");
                }
                if (!player.m_7500_()) {
                    tag.m_128405_("uses", --uses);
                }
            }
            this.activate();
        }
        return null;
    }

    public void activate() {
        Block block = this.m_58900_().m_60734_();
        int signalLength = this.getSignalLength();
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61122_((Property)BlockStateProperties.f_61448_));
        BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, block);
        if (signalLength > 0) {
            this.f_58857_.m_186460_(this.f_58858_, block, signalLength);
        }
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, this.m_58900_().m_60734_());
        }
        super.onOptionChanged(option);
    }

    public void setAcceptedLevels(boolean[] acceptedLevels) {
        this.acceptedLevels = acceptedLevels;
        this.m_6596_();
    }

    public boolean[] getAcceptedLevels() {
        return this.acceptedLevels;
    }

    public void setSignature(int signature) {
        this.signature = signature;
        this.m_6596_();
    }

    public int getSignature() {
        return this.signature;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendDenylistMessage, this.signalLength, this.disabled};
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new KeycardReaderMenu(windowId, inv, this.f_58857_, this.f_58858_);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        this.reset();
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors(level, pos, state.m_60734_());
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    public void reset() {
        this.acceptedLevels = new boolean[]{true, false, false, false, false};
        this.signature = 0;
        this.m_6596_();
    }

    public Component m_5446_() {
        return super.m_5446_();
    }
}

