/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SecretHangingSignBlockEntity
extends HangingSignBlockEntity
implements IOwnable,
IModuleInventory,
ICustomizable {
    private Owner owner = new Owner();
    private Option.BooleanOption isSecret = new Option.BooleanOption("isSecret", true){

        @Override
        public String getKey(String denotation) {
            return "option.generic.secret_sign.isSecret";
        }
    };
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    public SecretHangingSignBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)SCContent.SECRET_HANGING_SIGN_BLOCK_ENTITY.get();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
        this.owner.load(tag);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isSecret};
    }

    public boolean isSecret() {
        return (Boolean)this.isSecret.get();
    }

    public boolean isPlayerAllowedToSeeText(Player player) {
        return !this.isSecret() || this.isOwnedBy((Entity)player) || this.isAllowed((Entity)player);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        ICustomizable.super.onOptionChanged(option);
    }

    public ClientboundBlockEntityDataPacket m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.m_6596_();
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    @Override
    public String getModuleDescriptionId(String denotation, ModuleType module) {
        return IModuleInventory.super.getModuleDescriptionId("generic.secret_sign", module);
    }

    @Override
    public Level myLevel() {
        return this.f_58857_;
    }

    @Override
    public BlockPos myPos() {
        return this.f_58858_;
    }
}

