/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class InventoryScannerBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HORIZONTAL = BooleanProperty.m_61465_((String)"horizontal");

    public InventoryScannerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.isFacingAnotherScanner(level, pos) && player instanceof ServerPlayer) {
            BlockEntity blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof InventoryScannerBlockEntity) {
                InventoryScannerBlockEntity be = (InventoryScannerBlockEntity)blockEntity;
                if (be.isDisabled()) {
                    player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)be, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((InventoryScannerBlock)SCContent.INVENTORY_SCANNER.get()).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:invScan.notConnected", new Object[0]), ChatFormatting.RED);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (level.f_46443_) {
            return;
        }
        InventoryScannerBlock.checkAndPlaceAppropriately(level, pos, false);
    }

    public static void checkAndPlaceAppropriately(Level level, BlockPos pos, boolean force) {
        InventoryScannerBlockEntity thisBe = (InventoryScannerBlockEntity)level.m_7702_(pos);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos);
        if (connectedScanner == null || !connectedScanner.getOwner().owns(thisBe)) {
            return;
        }
        if (!force) {
            if (connectedScanner.isDisabled()) {
                thisBe.setDisabled(true);
                return;
            }
        } else {
            thisBe.setDisabled(false);
            connectedScanner.setDisabled(false);
        }
        boolean horizontal = false;
        if (((Boolean)connectedScanner.m_58900_().m_61143_((Property)HORIZONTAL)).booleanValue()) {
            horizontal = true;
        }
        Direction facing = (Direction)level.m_8055_(pos).m_61143_((Property)FACING);
        int loopBoundary = switch (facing) {
            case Direction.WEST, Direction.EAST -> Math.abs(pos.m_123341_() - connectedScanner.m_58899_().m_123341_());
            case Direction.NORTH, Direction.SOUTH -> Math.abs(pos.m_123343_() - connectedScanner.m_58899_().m_123343_());
            default -> 0;
        };
        thisBe.setHorizontal(horizontal);
        for (int i = 1; i < loopBoundary; ++i) {
            if (level.m_8055_(pos.m_5484_(facing, i)).m_60734_() != SCContent.INVENTORY_SCANNER_FIELD.get()) continue;
            return;
        }
        Option<?>[] customOptions = thisBe.customOptions();
        for (int i = 1; i < loopBoundary; ++i) {
            BlockPos offsetPos = pos.m_5484_(facing, i);
            level.m_46597_(offsetPos, (BlockState)((BlockState)((BlockState)((InventoryScannerFieldBlock)((Object)SCContent.INVENTORY_SCANNER_FIELD.get())).m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(horizontal))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_)));
            BlockEntity blockEntity = level.m_7702_(offsetPos);
            if (!(blockEntity instanceof IOwnable)) continue;
            IOwnable ownable = (IOwnable)blockEntity;
            ownable.setOwner(thisBe.getOwner().getUUID(), thisBe.getOwner().getName());
        }
        for (ModuleType type : connectedScanner.getInsertedModules()) {
            thisBe.insertModule(connectedScanner.getModule(type), false);
        }
        ((Option.BooleanOption)customOptions[0]).setValue(connectedScanner.isHorizontal());
        ((Option.BooleanOption)customOptions[1]).setValue(connectedScanner.doesFieldSolidify());
        ((Option.BooleanOption)customOptions[2]).setValue(false);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level.f_46443_ || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos, state, null);
        BlockUtils.removeInSequence((direction, stateToCheck) -> {
            if (stateToCheck.m_60734_() != SCContent.INVENTORY_SCANNER_FIELD.get()) {
                return false;
            }
            Direction stateToCheckFacing = (Direction)stateToCheck.m_61143_((Property)FACING);
            return stateToCheckFacing == direction || stateToCheckFacing == direction.m_122424_();
        }, (LevelAccessor)level, pos, (Direction)state.m_61143_((Property)FACING));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InventoryScannerBlockEntity) {
            InventoryScannerBlockEntity be = (InventoryScannerBlockEntity)blockEntity;
            for (int i = 10; i < be.m_6643_(); ++i) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((ItemStack)be.getContents().get(i)));
            }
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)be.getLensContainer());
            if (be.isProvidingPower()) {
                level.m_46672_(pos, (Block)this);
                BlockUtils.updateIndirectNeighbors(level, pos, (Block)this);
            }
        }
        if (connectedScanner != null) {
            for (int i = 0; i < connectedScanner.getContents().size(); ++i) {
                connectedScanner.getContents().set(i, (Object)ItemStack.f_41583_);
            }
            connectedScanner.getLensContainer().m_6211_();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private boolean isFacingAnotherScanner(Level level, BlockPos pos) {
        return InventoryScannerBlock.getConnectedInventoryScanner(level, pos) != null;
    }

    public static InventoryScannerBlockEntity getConnectedInventoryScanner(Level level, BlockPos pos) {
        return InventoryScannerBlock.getConnectedInventoryScanner(level, pos, level.m_8055_(pos), null);
    }

    public static InventoryScannerBlockEntity getConnectedInventoryScanner(Level level, BlockPos pos, BlockState stateAtPos, Consumer<OwnableBlockEntity> fieldModifier) {
        if (!stateAtPos.m_60713_((Block)SCContent.INVENTORY_SCANNER.get()) && !stateAtPos.m_60713_((Block)SCContent.INVENTORY_SCANNER_FIELD.get())) {
            return null;
        }
        Direction facing = (Direction)stateAtPos.m_61143_((Property)FACING);
        ArrayList<BlockPos> fields = new ArrayList<BlockPos>();
        for (int i = 0; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
            boolean isField;
            BlockPos offsetPos = pos.m_5484_(facing, i);
            BlockState state = level.m_8055_(offsetPos);
            Block block = state.m_60734_();
            boolean bl = isField = block == SCContent.INVENTORY_SCANNER_FIELD.get();
            if (!(isField || state.m_60795_() || state.m_247087_() || block == SCContent.INVENTORY_SCANNER.get())) {
                return null;
            }
            if (isField) {
                fields.add(offsetPos);
            }
            if (block != SCContent.INVENTORY_SCANNER.get() || state.m_61143_((Property)FACING) != facing.m_122424_()) continue;
            if (fieldModifier != null) {
                fields.stream().map(arg_0 -> ((Level)level).m_7702_(arg_0)).forEach(be -> fieldModifier.accept((OwnableBlockEntity)be));
            }
            return (InventoryScannerBlockEntity)level.m_7702_(offsetPos);
        }
        return null;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        InventoryScannerBlock.checkAndPlaceAppropriately((Level)level, pos, false);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader level, BlockPos pos, Direction side) {
        return false;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof InventoryScannerBlockEntity)) {
            return 0;
        }
        InventoryScannerBlockEntity be = (InventoryScannerBlockEntity)blockEntity;
        return be.isProvidingPower() ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.m_6378_(state, level, pos, side);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HORIZONTAL, WATERLOGGED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InventoryScannerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return InventoryScannerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static class DoorActivator
    implements IDoorActivator {
        private List<Block> blocks = Arrays.asList((Block)SCContent.INVENTORY_SCANNER.get());

        @Override
        public boolean isPowering(Level level, BlockPos pos, BlockState state, BlockEntity be, Direction direction, int distance) {
            return ((InventoryScannerBlockEntity)be).isProvidingPower();
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

