/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadTrapdoorBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.BaseIronTrapDoorBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KeypadTrapDoorBlock
extends BaseIronTrapDoorBlock
implements IDisguisable,
IOverlayDisplay {
    public KeypadTrapDoorBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(properties, blockSetType);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return super.m_5940_(state, level, pos, ctx);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
                return Shapes.m_83040_();
            }
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return super.m_5940_(state, level, pos, ctx);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        KeypadTrapdoorBlockEntity be = (KeypadTrapdoorBlockEntity)level.m_7702_(pos);
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue() && be.getSignalLength() > 0) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            if (be.isDisabled()) {
                player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(state, level, pos, be.getSignalLength());
                } else if (!player.m_21120_(hand).m_150930_((Item)SCContent.CODEBREAKER.get())) {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(BlockState state, Level level, BlockPos pos, int signalLength) {
        level.m_46597_(pos, (BlockState)state.m_61122_((Property)f_57514_));
        this.m_57527_(null, level, pos, true);
        if (signalLength > 0) {
            level.m_186460_(pos, (Block)this, signalLength);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false)));
            this.m_57527_(null, (Level)level, pos, false);
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof IPasscodeProtected) {
            IPasscodeProtected be = (IPasscodeProtected)blockEntity;
            SaltData.removeSalt(be.getSaltKey());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeypadTrapdoorBlockEntity(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (IDisguisable.shouldPickBlockDisguise(level, pos, player)) {
            return this.getDisguisedStack(level, pos);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getLightEmission(level, pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60792_(level, pos);
        }
        return super.m_7749_(state, level, pos);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60739_(level, pos);
        }
        return super.m_7753_(state, level, pos);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos).m_41720_() == this.m_5456_();
    }

    public static class Convertible
    implements IPasscodeConvertible {
        @Override
        public boolean isUnprotectedBlock(BlockState state) {
            return state.m_60713_((Block)SCContent.REINFORCED_IRON_TRAPDOOR.get());
        }

        @Override
        public boolean isProtectedBlock(BlockState state) {
            return state.m_60713_((Block)SCContent.KEYPAD_TRAPDOOR.get());
        }

        @Override
        public boolean protect(Player player, Level level, BlockPos pos) {
            return this.convert(level, pos, (Block)SCContent.KEYPAD_TRAPDOOR.get());
        }

        @Override
        public boolean unprotect(Player player, Level level, BlockPos pos) {
            return this.convert(level, pos, (Block)SCContent.REINFORCED_IRON_TRAPDOOR.get());
        }

        private boolean convert(Level level, BlockPos pos, Block convertedBlock) {
            BlockState state = level.m_8055_(pos);
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Half half = (Half)state.m_61143_((Property)TrapDoorBlock.f_57515_);
            boolean waterlogged = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57517_);
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof IModuleInventory) {
                IModuleInventory moduleInv = (IModuleInventory)be;
                moduleInv.dropAllModules();
            }
            CompoundTag tag = be.m_187480_();
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)convertedBlock.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing)).m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)half)).m_61124_((Property)TrapDoorBlock.f_57516_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TrapDoorBlock.f_57517_, (Comparable)Boolean.valueOf(waterlogged)));
            level.m_7702_(pos).m_142466_(tag);
            return true;
        }
    }
}

