/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Map;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedCauldronBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedLavaCauldronBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedLayeredCauldronBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedCauldronBlock
extends AbstractCauldronBlock
implements IReinforcedBlock,
EntityBlock {
    private final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    public ReinforcedCauldronBlock(BlockBehaviour.Properties properties, Map<Item, CauldronInteraction> interactions) {
        super(OwnableBlock.withReinforcedDestroyTime(properties), interactions);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.m_5880_(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        Entity entity;
        EntityCollisionContext ctx;
        if (collisionContext instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)collisionContext).m_193113_() != null && (entity = ctx.m_193113_()) instanceof Player) {
            ReinforcedCauldronBlockEntity be;
            Player player = (Player)entity;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ReinforcedCauldronBlockEntity && (be = (ReinforcedCauldronBlockEntity)blockEntity).isAllowedToInteract(player)) {
                return f_151937_;
            }
            return Shapes.m_83144_();
        }
        return f_151937_;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ReinforcedCauldronBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ReinforcedCauldronBlockEntity && (be = (ReinforcedCauldronBlockEntity)blockEntity).isAllowedToInteract(player)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public boolean m_142596_(BlockState state) {
        return false;
    }

    protected static boolean shouldHandlePrecipitation(Level level, Biome.Precipitation precipitation) {
        return switch (precipitation) {
            case Biome.Precipitation.RAIN -> {
                if (level.m_213780_().m_188501_() < 0.05f) {
                    yield true;
                }
                yield false;
            }
            case Biome.Precipitation.SNOW -> {
                if (level.m_213780_().m_188501_() < 0.1f) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void m_141997_(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (ReinforcedCauldronBlock.shouldHandlePrecipitation(level, precipitation)) {
            BlockState newCauldronState = null;
            if (precipitation == Biome.Precipitation.RAIN) {
                newCauldronState = ((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_WATER_CAULDRON.get()).m_49966_();
            } else if (precipitation == Biome.Precipitation.SNOW) {
                newCauldronState = ((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_POWDER_SNOW_CAULDRON.get()).m_49966_();
            }
            if (newCauldronState != null) {
                ReinforcedCauldronBlock.updateBlockState(level, pos, newCauldronState);
                level.m_142346_(null, GameEvent.f_157792_, pos);
            }
        }
    }

    protected boolean m_142087_(Fluid fluid) {
        return true;
    }

    protected void m_142310_(BlockState state, Level level, BlockPos pos, Fluid fluid) {
        BlockState newCauldronState = null;
        int levelEvent = 0;
        if (fluid == Fluids.f_76193_) {
            newCauldronState = ((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_WATER_CAULDRON.get()).m_49966_();
            levelEvent = 1047;
        } else if (fluid == Fluids.f_76195_) {
            newCauldronState = ((ReinforcedLavaCauldronBlock)SCContent.REINFORCED_LAVA_CAULDRON.get()).m_49966_();
            levelEvent = 1046;
        }
        if (newCauldronState != null) {
            ReinforcedCauldronBlock.updateBlockState(level, pos, newCauldronState);
            level.m_46796_(levelEvent, pos, 0);
            level.m_142346_(null, GameEvent.f_157792_, pos);
        }
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.f_50256_;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ReinforcedCauldronBlockEntity(pos, state);
    }

    public static void updateBlockState(Level level, BlockPos pos, BlockState newState) {
        ReinforcedCauldronBlock.updateBlockState(level, pos, newState, level.m_7702_(pos));
    }

    public static void updateBlockState(Level level, BlockPos pos, BlockState newState, BlockEntity be) {
        CompoundTag tag = null;
        if (be != null) {
            tag = be.m_187482_();
        }
        level.m_46597_(pos, newState);
        if (tag != null) {
            level.m_7702_(pos).m_142466_(tag);
        }
    }

    public static interface IReinforcedCauldronInteraction
    extends CauldronInteraction {
        public static final Map<Item, CauldronInteraction> EMPTY = CauldronInteraction.m_175617_();
        public static final Map<Item, CauldronInteraction> WATER = CauldronInteraction.m_175617_();
        public static final Map<Item, CauldronInteraction> LAVA = CauldronInteraction.m_175617_();
        public static final Map<Item, CauldronInteraction> POWDER_SNOW = CauldronInteraction.m_175617_();
        public static final CauldronInteraction FILL_WATER = (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.emptyBucket(level, pos, player, hand, stack, (BlockState)((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_WATER_CAULDRON.get()).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_11778_);
        public static final CauldronInteraction FILL_LAVA = (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.emptyBucket(level, pos, player, hand, stack, ((ReinforcedLavaCauldronBlock)SCContent.REINFORCED_LAVA_CAULDRON.get()).m_49966_(), SoundEvents.f_11780_);
        public static final CauldronInteraction FILL_POWDER_SNOW = (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.emptyBucket(level, pos, player, hand, stack, (BlockState)((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_POWDER_SNOW_CAULDRON.get()).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_144076_);
        public static final CauldronInteraction SHULKER_BOX = (state, level, pos, player, hand, stack) -> {
            Block block = Block.m_49814_((Item)stack.m_41720_());
            if (!(block instanceof ShulkerBoxBlock)) {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_) {
                ItemStack shulker = new ItemStack((ItemLike)Blocks.f_50456_);
                if (stack.m_41782_()) {
                    shulker.m_41751_(stack.m_41783_().m_6426_());
                }
                player.m_21008_(hand, shulker);
                player.m_36220_(Stats.f_12947_);
                ReinforcedLayeredCauldronBlock.m_153559_(state, level, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        };
        public static final CauldronInteraction BANNER = (state, level, pos, player, hand, stack) -> {
            if (BannerBlockEntity.m_58504_((ItemStack)stack) <= 0) {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_) {
                ItemStack banner = stack.m_41777_();
                banner.m_41764_(1);
                BannerBlockEntity.m_58509_((ItemStack)banner);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (stack.m_41619_()) {
                    player.m_21008_(hand, banner);
                } else if (player.m_150109_().m_36054_(banner)) {
                    player.f_36095_.m_150429_();
                } else {
                    player.m_36176_(banner, false);
                }
                player.m_36220_(Stats.f_12946_);
                ReinforcedLayeredCauldronBlock.m_153559_(state, level, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        };
        public static final CauldronInteraction DYED_ITEM = (state, level, pos, player, hand, stack) -> {
            Item item = stack.m_41720_();
            if (!(item instanceof DyeableLeatherItem)) {
                return InteractionResult.PASS;
            }
            DyeableLeatherItem leatherItem = (DyeableLeatherItem)item;
            if (!leatherItem.m_41113_(stack)) {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_) {
                leatherItem.m_41123_(stack);
                player.m_36220_(Stats.f_12945_);
                ReinforcedLayeredCauldronBlock.m_153559_(state, level, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        };

        public static void bootStrap() {
            IReinforcedCauldronInteraction.addDefaultInteractions(EMPTY);
            EMPTY.put(Items.f_42589_, (state, level, pos, player, hand, stack) -> {
                if (PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43599_) {
                    return InteractionResult.PASS;
                }
                if (!level.f_46443_) {
                    Item item = stack.m_41720_();
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    ReinforcedCauldronBlock.updateBlockState(level, pos, ((ReinforcedLayeredCauldronBlock)SCContent.REINFORCED_WATER_CAULDRON.get()).m_49966_());
                    level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157769_, pos);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            });
            IReinforcedCauldronInteraction.addDefaultInteractions(WATER);
            WATER.put(Items.f_42446_, (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)Items.f_42447_), s -> (Integer)s.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
            WATER.put(Items.f_42590_, (state, level, pos, player, hand, stack) -> {
                if (!level.f_46443_) {
                    Item item = stack.m_41720_();
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    ReinforcedLayeredCauldronBlock.m_153559_(state, level, pos);
                    level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157816_, pos);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            });
            WATER.put(Items.f_42589_, (state, level, pos, player, hand, stack) -> {
                if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) != 3 && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
                    if (!level.f_46443_) {
                        player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                        player.m_36220_(Stats.f_12944_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                        ReinforcedCauldronBlock.updateBlockState(level, pos, (BlockState)state.m_61122_((Property)LayeredCauldronBlock.f_153514_), null);
                        level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_142346_(null, GameEvent.f_157769_, pos);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return InteractionResult.PASS;
            });
            WATER.put(Items.f_42463_, DYED_ITEM);
            WATER.put(Items.f_42462_, DYED_ITEM);
            WATER.put(Items.f_42408_, DYED_ITEM);
            WATER.put(Items.f_42407_, DYED_ITEM);
            WATER.put(Items.f_42654_, DYED_ITEM);
            WATER.put(Items.f_42660_, BANNER);
            WATER.put(Items.f_42667_, BANNER);
            WATER.put(Items.f_42728_, BANNER);
            WATER.put(Items.f_42671_, BANNER);
            WATER.put(Items.f_42672_, BANNER);
            WATER.put(Items.f_42669_, BANNER);
            WATER.put(Items.f_42673_, BANNER);
            WATER.put(Items.f_42663_, BANNER);
            WATER.put(Items.f_42668_, BANNER);
            WATER.put(Items.f_42665_, BANNER);
            WATER.put(Items.f_42662_, BANNER);
            WATER.put(Items.f_42661_, BANNER);
            WATER.put(Items.f_42666_, BANNER);
            WATER.put(Items.f_42670_, BANNER);
            WATER.put(Items.f_42727_, BANNER);
            WATER.put(Items.f_42664_, BANNER);
            WATER.put(Items.f_42266_, SHULKER_BOX);
            WATER.put(Items.f_42273_, SHULKER_BOX);
            WATER.put(Items.f_42229_, SHULKER_BOX);
            WATER.put(Items.f_42225_, SHULKER_BOX);
            WATER.put(Items.f_42226_, SHULKER_BOX);
            WATER.put(Items.f_42275_, SHULKER_BOX);
            WATER.put(Items.f_42227_, SHULKER_BOX);
            WATER.put(Items.f_42269_, SHULKER_BOX);
            WATER.put(Items.f_42274_, SHULKER_BOX);
            WATER.put(Items.f_42271_, SHULKER_BOX);
            WATER.put(Items.f_42268_, SHULKER_BOX);
            WATER.put(Items.f_42267_, SHULKER_BOX);
            WATER.put(Items.f_42272_, SHULKER_BOX);
            WATER.put(Items.f_42224_, SHULKER_BOX);
            WATER.put(Items.f_42228_, SHULKER_BOX);
            WATER.put(Items.f_42270_, SHULKER_BOX);
            LAVA.put(Items.f_42446_, (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)Items.f_42448_), s -> true, SoundEvents.f_11783_));
            IReinforcedCauldronInteraction.addDefaultInteractions(LAVA);
            POWDER_SNOW.put(Items.f_42446_, (state, level, pos, player, hand, stack) -> IReinforcedCauldronInteraction.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)Items.f_151055_), l -> (Integer)l.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_144089_));
            IReinforcedCauldronInteraction.addDefaultInteractions(POWDER_SNOW);
            CauldronInteraction.f_175607_.put((Item)SCContent.BRIEFCASE.get(), CauldronInteraction.f_175615_);
            WATER.put((Item)SCContent.BRIEFCASE.get(), DYED_ITEM);
            CauldronInteraction.f_175607_.put((Item)SCContent.LENS.get(), CauldronInteraction.f_175615_);
            WATER.put((Item)SCContent.LENS.get(), DYED_ITEM);
        }

        public static void addDefaultInteractions(Map<Item, CauldronInteraction> interactions) {
            interactions.put(Items.f_42448_, FILL_LAVA);
            interactions.put(Items.f_42447_, FILL_WATER);
            interactions.put(Items.f_151055_, FILL_POWDER_SNOW);
        }

        public static InteractionResult fillBucket(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, ItemStack bucket, Predicate<BlockState> fillPredicate, SoundEvent sound) {
            if (!fillPredicate.test(state)) {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_) {
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)bucket));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                ReinforcedCauldronBlock.updateBlockState(level, pos, ((ReinforcedCauldronBlock)SCContent.REINFORCED_CAULDRON.get()).m_49966_());
                level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }

        public static InteractionResult emptyBucket(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state, SoundEvent sound) {
            if (!level.f_46443_) {
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
                player.m_36220_(Stats.f_12943_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                ReinforcedCauldronBlock.updateBlockState(level, pos, state);
                level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157769_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
    }
}

