/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class DumpCommand {
    private static final DynamicCommandExceptionType ERROR_REGISTRY_NOT_FOUND = new DynamicCommandExceptionType(registry -> Component.m_264642_((String)"commands.securitycraft.dump.notFound", (String)"SecurityCraft has nothing registered to \"%s\".", (Object[])new Object[]{registry}));
    private static final Map<String, DeferredRegister<?>> REGISTRIES = (Map)Util.m_137537_(() -> {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Field field : SCContent.class.getFields()) {
            if (field.getType() != DeferredRegister.class) {
                return map;
            }
            try {
                map.put(field.getName().toLowerCase(Locale.ROOT), (DeferredRegister)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return map;
    });

    private DumpCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"dump").then(Commands.m_82129_((String)"registry", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(REGISTRIES.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> {
            String registry = (String)ctx.getArgument("registry", String.class);
            if (!REGISTRIES.containsKey(registry)) {
                throw ERROR_REGISTRY_NOT_FOUND.create((Object)registry);
            }
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String lineSeparator = System.lineSeparator();
            Collection registryObjects = REGISTRIES.get(registry).getEntries();
            Object result = "";
            for (RegistryObject ro : registryObjects) {
                result = (String)result + ro.getId().toString() + lineSeparator;
            }
            String finalResult = ((String)result).substring(0, ((String)result).lastIndexOf(lineSeparator));
            if (source.m_230897_()) {
                source.m_81354_((Component)Component.m_237113_((String)"[").m_7220_((Component)Component.m_237113_((String)"SecurityCraft").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"] ")).m_7220_((Component)Component.m_237110_((String)"commands.securitycraft.dump.result", (Object[])new Object[]{registryObjects.size()}).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)registry))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, finalResult)))), true);
            } else {
                source.m_81354_((Component)Component.m_237113_((String)finalResult), true);
            }
            return 0;
        }));
    }
}

