/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.UUID;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.commands.SingleGameProfileArgument;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.RandomStringUtils;

public class OwnerCommand {
    private static final SimpleCommandExceptionType ERROR_SET_FAILED = new SimpleCommandExceptionType((Message)Component.m_264568_((String)"commands.securitycraft.owner.set.failed", (String)"There is no ownable block at the given position or it is already owned by the given player"));
    private static final SimpleCommandExceptionType ERROR_FILL_FAILED = new SimpleCommandExceptionType((Message)Component.m_264568_((String)"commands.securitycraft.owner.fill.failed", (String)"There are no ownable blocks in the given area or they are already owned by the given player"));

    private OwnerCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"owner").requires(ctx -> ctx.m_6761_(2))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82127_((String)"reset").executes(ctx -> OwnerCommand.setOwner((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos"), "ownerUUID", "owner")))).then(Commands.m_82127_((String)"random").executes(ctx -> OwnerCommand.setRandomOwner((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos"))))).then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"owner", (ArgumentType)SingleGameProfileArgument.singleGameProfile()).executes(ctx -> OwnerCommand.setOwner((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos"), SingleGameProfileArgument.getGameProfile((CommandContext<CommandSourceStack>)ctx, "owner")))))))).then(Commands.m_82127_((String)"fill").then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82127_((String)"reset").executes(ctx -> OwnerCommand.fillOwner((CommandContext<CommandSourceStack>)ctx, "ownerUUID", "owner")))).then(Commands.m_82127_((String)"random").executes(ctx -> OwnerCommand.fillRandomOwner((CommandContext<CommandSourceStack>)ctx)))).then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"owner", (ArgumentType)SingleGameProfileArgument.singleGameProfile()).executes(ctx -> OwnerCommand.fillOwner((CommandContext<CommandSourceStack>)ctx, SingleGameProfileArgument.getGameProfile((CommandContext<CommandSourceStack>)ctx, "owner"))))))));
    }

    private static int setRandomOwner(CommandSourceStack source, BlockPos pos) throws CommandSyntaxException {
        return OwnerCommand.setOwner(source, pos, UUID.randomUUID().toString(), RandomStringUtils.randomAlphanumeric((int)10));
    }

    private static int setOwner(CommandSourceStack source, BlockPos pos, GameProfile gameProfile) throws CommandSyntaxException {
        return OwnerCommand.setOwner(source, pos, gameProfile.getId().toString(), gameProfile.getName());
    }

    private static int setOwner(CommandSourceStack source, BlockPos pos, String uuid, String name) throws CommandSyntaxException {
        ServerLevel level = source.m_81372_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IOwnable)) {
            throw ERROR_SET_FAILED.create();
        }
        IOwnable ownable = (IOwnable)blockEntity;
        Owner previousOwner = ownable.getOwner();
        if (!previousOwner.getUUID().equals(uuid) || !previousOwner.getName().equals(name)) {
            BlockState state = ((BlockEntity)ownable).m_58900_();
            Owner oldOwner = ownable.getOwner().copy();
            ownable.setOwner(uuid, name);
            ownable.onOwnerChanged(state, (Level)level, pos, null, oldOwner, ownable.getOwner());
            ownable.getOwner().setValidated(true);
            level.m_7260_(pos, state, state, 3);
            source.m_81354_((Component)Component.m_264642_((String)"commands.securitycraft.owner.set.success", (String)"Set the owner at %s, %s, %s", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
            return 1;
        }
        throw ERROR_SET_FAILED.create();
    }

    private static int fillRandomOwner(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return OwnerCommand.fillOwner(ctx, UUID.randomUUID().toString(), RandomStringUtils.randomAlphanumeric((int)10));
    }

    private static int fillOwner(CommandContext<CommandSourceStack> ctx, GameProfile gameProfile) throws CommandSyntaxException {
        return OwnerCommand.fillOwner(ctx, gameProfile.getId().toString(), gameProfile.getName());
    }

    private static int fillOwner(CommandContext<CommandSourceStack> ctx, String uuid, String name) throws CommandSyntaxException {
        int commandModificationBlockLimit;
        BoundingBox area = BoundingBox.m_162375_((Vec3i)BlockPosArgument.m_118242_(ctx, (String)"from"), (Vec3i)BlockPosArgument.m_118242_(ctx, (String)"to"));
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.m_81372_();
        int blockCount = area.m_71056_() * area.m_71057_() * area.m_71058_();
        if (blockCount > (commandModificationBlockLimit = level.m_46469_().m_46215_(GameRules.f_263760_))) {
            throw FillCommand.f_137372_.create((Object)commandModificationBlockLimit, (Object)blockCount);
        }
        ArrayList<OwnerChange> modifiedBlocks = new ArrayList<OwnerChange>();
        for (BlockPos pos : BlockPos.m_121976_((int)area.m_162395_(), (int)area.m_162396_(), (int)area.m_162398_(), (int)area.m_162399_(), (int)area.m_162400_(), (int)area.m_162401_())) {
            IOwnable ownable;
            Owner previousOwner;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof IOwnable) || (previousOwner = (ownable = (IOwnable)blockEntity).getOwner()).getUUID().equals(uuid) && previousOwner.getName().equals(name)) continue;
            Owner oldOwner = ownable.getOwner().copy();
            ownable.setOwner(uuid, name);
            modifiedBlocks.add(new OwnerChange((BlockEntity)ownable, oldOwner));
        }
        int blocksModified = modifiedBlocks.size();
        if (blocksModified == 0) {
            throw ERROR_FILL_FAILED.create();
        }
        for (OwnerChange ownerChange : modifiedBlocks) {
            BlockEntity be = ownerChange.be;
            BlockPos pos = be.m_58899_();
            BlockState state = be.m_58900_();
            IOwnable ownable = (IOwnable)be;
            ownable.onOwnerChanged(state, (Level)level, pos, null, ownerChange.oldOwner, ownable.getOwner());
            ownable.getOwner().setValidated(true);
            level.m_7260_(pos, state, state, 3);
        }
        source.m_81354_((Component)Component.m_264642_((String)"commands.securitycraft.owner.fill.success", (String)"Successfully set the owner of %s block(s)", (Object[])new Object[]{blocksModified}), true);
        return blocksModified;
    }

    private record OwnerChange(BlockEntity be, Owner oldOwner) {
    }
}

