/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OverlayToggleHandler;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetDefaultCameraViewingDirection;
import net.geforcemods.securitycraft.network.server.ToggleNightVision;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class CameraController {
    public static CameraType previousCameraType;
    public static boolean resetOverlaysAfterDismount;
    private static final ViewMovementKeyHandler[] MOVE_KEY_HANDLERS;
    private static int screenshotSoundCooldown;
    private static long lastCameraMountTimestamp;

    private CameraController() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        if (cameraEntity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)cameraEntity;
            Options options = Minecraft.m_91087_().f_91066_;
            if (event.phase == TickEvent.Phase.START) {
                for (ViewMovementKeyHandler handler : MOVE_KEY_HANDLERS) {
                    handler.tickStart();
                }
                if (options.f_92090_.m_90857_()) {
                    CameraController.dismount();
                    options.f_92090_.m_7249_(false);
                }
            } else if (event.phase == TickEvent.Phase.END) {
                for (ViewMovementKeyHandler handler : MOVE_KEY_HANDLERS) {
                    handler.tickEnd(cam);
                }
                if (KeyBindings.cameraZoomIn.m_90857_()) {
                    CameraController.zoomIn(cam);
                } else if (KeyBindings.cameraZoomOut.m_90857_()) {
                    CameraController.zoomOut(cam);
                } else {
                    cam.zooming = false;
                }
                KeyBindings.cameraEmitRedstone.tick(cam);
                KeyBindings.cameraActivateNightVision.tick(cam);
                KeyBindings.setDefaultViewingDirection.tick(cam);
                --screenshotSoundCooldown;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                double yRotChange = player.m_146908_() - player.f_108598_;
                double xRotChange = player.m_146909_() - player.f_108599_;
                if (yRotChange != 0.0 || xRotChange != 0.0) {
                    player.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(player.m_146908_(), player.m_146909_(), player.m_20096_()));
                }
            }
        } else if (resetOverlaysAfterDismount) {
            resetOverlaysAfterDismount = false;
            OverlayToggleHandler.disable(ClientHandler.cameraOverlay);
            OverlayToggleHandler.enable(VanillaGuiOverlay.JUMP_BAR);
            OverlayToggleHandler.enable(VanillaGuiOverlay.EXPERIENCE_BAR);
            OverlayToggleHandler.enable(VanillaGuiOverlay.POTION_ICONS);
        }
    }

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player) && screenshotSoundCooldown <= 0) {
            screenshotSoundCooldown = 7;
            Minecraft.m_91087_().f_91073_.m_245747_(player.m_20183_(), SCSounds.CAMERASNAP.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    private static void dismount() {
        SecurityCraft.CHANNEL.sendToServer((Object)new DismountCamera());
    }

    public static void moveViewUp(SecurityCamera cam) {
        float next = cam.m_146909_() - CameraController.getMovementSpeed(cam) * cam.getZoomAmount();
        if (cam.isCameraDown()) {
            if (next > 40.0f) {
                cam.setRotation(cam.m_146908_(), next);
            }
        } else if (next > -25.0f) {
            cam.setRotation(cam.m_146908_(), next);
        }
    }

    public static void moveViewDown(SecurityCamera cam) {
        float next = cam.m_146909_() + CameraController.getMovementSpeed(cam) * cam.getZoomAmount();
        if (cam.isCameraDown()) {
            if (next < 90.0f) {
                cam.setRotation(cam.m_146908_(), next);
            }
        } else if (next < 60.0f) {
            cam.setRotation(cam.m_146908_(), next);
        }
    }

    public static void moveViewHorizontally(SecurityCamera cam, float next) {
        BlockState state = cam.f_19853_.m_8055_(cam.m_20183_());
        if (state.m_61138_((Property)SecurityCameraBlock.FACING)) {
            boolean shouldSetRotation;
            float checkNext = next;
            if (checkNext < 0.0f) {
                checkNext += 360.0f;
            }
            switch ((Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) {
                case NORTH: {
                    boolean bl;
                    if (checkNext > 90.0f && checkNext < 270.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case SOUTH: {
                    boolean bl;
                    if (checkNext > 270.0f || checkNext < 90.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case EAST: {
                    boolean bl;
                    if (checkNext > 180.0f && checkNext < 360.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case WEST: {
                    boolean bl;
                    if (checkNext > 0.0f && checkNext < 180.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case DOWN: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = shouldSetRotation = false;
                }
            }
            if (shouldSetRotation) {
                cam.m_146922_(next);
            }
        }
    }

    public static void zoomIn(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.m_91087_().f_91073_.m_245747_(cam.m_20183_(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.setZoomAmount(Math.max(cam.getZoomAmount() - 0.1f, 0.1f));
    }

    public static void zoomOut(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.m_91087_().f_91073_.m_245747_(cam.m_20183_(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.setZoomAmount(Math.min(cam.getZoomAmount() + 0.1f, 1.4f));
    }

    public static void toggleRedstone(SecurityCamera cam) {
        IModuleInventory be;
        BlockPos pos = cam.m_20183_();
        BlockEntity blockEntity = cam.f_19853_.m_7702_(pos);
        if (blockEntity instanceof IModuleInventory && (be = (IModuleInventory)blockEntity).isModuleEnabled(ModuleType.REDSTONE)) {
            SecurityCraft.CHANNEL.sendToServer((Object)new SetCameraPowered(pos, (Boolean)cam.f_19853_.m_8055_(pos).m_61143_((Property)SecurityCameraBlock.POWERED) == false));
        }
    }

    public static void toggleNightVision(SecurityCamera cam) {
        if (((Boolean)ConfigHandler.SERVER.allowCameraNightVision.get()).booleanValue()) {
            SecurityCraft.CHANNEL.sendToServer((Object)new ToggleNightVision());
        }
    }

    public static void setDefaultViewingDirection(SecurityCamera cam) {
        SecurityCraft.CHANNEL.sendToServer((Object)new SetDefaultCameraViewingDirection(cam));
    }

    public static float getMovementSpeed(SecurityCamera cam) {
        SecurityCameraBlockEntity be = cam.getBlockEntity();
        if (be != null) {
            return (float)be.getMovementSpeed();
        }
        return 0.0f;
    }

    public static void setCameraMountedTimestamp() {
        lastCameraMountTimestamp = System.currentTimeMillis();
    }

    public static long getMillisSinceLastMount() {
        return System.currentTimeMillis() - lastCameraMountTimestamp;
    }

    static {
        resetOverlaysAfterDismount = false;
        MOVE_KEY_HANDLERS = (ViewMovementKeyHandler[])Util.m_137537_(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null) {
                return new ViewMovementKeyHandler[]{new ViewMovementKeyHandler(mc.f_91066_.f_92085_, CameraController::moveViewUp), new ViewMovementKeyHandler(mc.f_91066_.f_92087_, CameraController::moveViewDown), new ViewMovementKeyHandler(mc.f_91066_.f_92086_, cam -> CameraController.moveViewHorizontally(cam, cam.m_146908_() - CameraController.getMovementSpeed(cam) * cam.getZoomAmount())), new ViewMovementKeyHandler(mc.f_91066_.f_92088_, cam -> CameraController.moveViewHorizontally(cam, cam.m_146908_() + CameraController.getMovementSpeed(cam) * cam.getZoomAmount()))};
            }
            return new ViewMovementKeyHandler[0];
        });
        screenshotSoundCooldown = 0;
        lastCameraMountTimestamp = 0L;
    }

    public static class ViewMovementKeyHandler {
        private final KeyMapping key;
        private final Consumer<SecurityCamera> action;
        private boolean wasPressed;

        public ViewMovementKeyHandler(KeyMapping key, Consumer<SecurityCamera> action) {
            this.key = key;
            this.action = action;
        }

        public void tickStart() {
            this.wasPressed = this.key.m_90857_();
            if (this.wasPressed) {
                this.key.m_7249_(false);
            }
        }

        public void tickEnd(SecurityCamera cam) {
            if (this.wasPressed) {
                this.action.accept(cam);
                this.key.m_7249_(true);
            }
        }
    }
}

