/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraFeed;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class FrameFeedHandler {
    private static final Map<GlobalPos, CameraFeed> FRAME_CAMERA_FEEDS = new ConcurrentHashMap<GlobalPos, CameraFeed>();
    private static GlobalPos currentlyCapturedCamera;
    private static double lastFrameRendered;

    @SubscribeEvent
    public static void onRenderFramePost(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.f_108617_.m_105147_() == null || !FrameFeedHandler.hasFeeds() || !((Boolean)ConfigHandler.SERVER.frameFeedViewingEnabled.get()).booleanValue()) {
            return;
        }
        ProfilerFiller profiler = mc.m_91307_();
        double currentTime = GLFW.glfwGetTime();
        Map<GlobalPos, CameraFeed> activeFrameCameraFeeds = FrameFeedHandler.getFeedsToRender(mc, currentTime);
        if (activeFrameCameraFeeds.isEmpty()) {
            return;
        }
        lastFrameRendered = currentTime;
        profiler.m_6180_("gameRenderer");
        profiler.m_6180_("securitycraft:frame_level");
        Level level = player.f_19853_;
        float partialTick = event.renderTickTime;
        Camera camera = mc.f_91063_.m_109153_();
        Entity oldCamEntity = mc.f_91075_;
        Window window = mc.m_91268_();
        int oldWidth = window.m_85441_();
        int oldHeight = window.m_85442_();
        ObjectArrayList oldVisibleSections = mc.f_91060_.f_194297_.clone();
        int newFrameFeedViewDistance = FrameFeedHandler.getFrameFeedViewDistance(null);
        double oldX = player.m_20185_();
        double oldXO = player.f_19790_;
        double oldY = player.m_20186_();
        double oldYO = player.f_19791_;
        double oldZ = player.m_20189_();
        double oldZO = player.f_19792_;
        float oldXRot = player.m_146909_();
        float oldXRotO = player.f_19860_;
        float oldYRot = player.m_146908_();
        float oldYRotO = player.f_19859_;
        float oldEyeHeight = camera.f_90562_;
        float oldEyeHeightO = camera.f_90563_;
        CameraType oldCameraType = mc.f_91066_.m_92176_();
        Marker securityCamera = new Marker(EntityType.f_147036_, level);
        RenderTarget oldMainRenderTarget = mc.m_91385_();
        RenderTarget oldTranslucentTarget = mc.f_91060_.f_109413_;
        RenderTarget oldItemEntityTarget = mc.f_91060_.f_109414_;
        RenderTarget oldWeatherTarget = mc.f_91060_.f_109416_;
        PostChain oldTransparencyChain = mc.f_91060_.f_109418_;
        Frustum playerFrustum = FrameFeedHandler.getFrustum(mc.f_91060_);
        mc.f_91063_.m_172775_(false);
        mc.f_91063_.m_172736_(false);
        mc.f_91063_.m_172779_(true);
        window.m_166450_(100);
        window.m_166452_(100);
        mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        camera.f_90562_ = camera.f_90563_ = player.m_20236_(Pose.STANDING);
        mc.f_91060_.f_109413_ = null;
        mc.f_91060_.f_109414_ = null;
        mc.f_91060_.f_109416_ = null;
        mc.f_91060_.f_109418_ = null;
        mc.m_91269_().m_110104_().m_109911_();
        for (Map.Entry<GlobalPos, CameraFeed> cameraView : activeFrameCameraFeeds.entrySet()) {
            BlockPos pos;
            BlockEntity blockEntity;
            GlobalPos cameraPos = cameraView.getKey();
            if (!cameraPos.m_122640_().equals((Object)level.m_46472_()) || !((blockEntity = level.m_7702_(pos = cameraPos.m_122646_())) instanceof SecurityCameraBlockEntity)) continue;
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
            CameraFeed feed = cameraView.getValue();
            if (!feed.hasFrameInFrustum(playerFrustum)) continue;
            RenderTarget frameTarget = feed.renderTarget();
            Vec3 cameraEntityPos = new Vec3((double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() - player.m_20236_(Pose.STANDING)) + 0.5, (double)pos.m_123343_() + 0.5);
            float cameraXRot = be.getDefaultXRotation();
            float cameraYRot = be.getDefaultYRotation((Direction)be.m_58900_().m_61143_((Property)SecurityCameraBlock.FACING)) + (float)Mth.m_14139_((double)partialTick, (double)be.getOriginalCameraRotation(), (double)be.getCameraRotation()) * 57.295776f;
            securityCamera.m_146884_(cameraEntityPos);
            mc.m_91118_((Entity)securityCamera);
            securityCamera.m_146926_(cameraXRot);
            securityCamera.m_146922_(cameraYRot);
            currentlyCapturedCamera = cameraPos;
            feed.applyVisibleSections((List<LevelRenderer.RenderChunkInfo>)mc.f_91060_.f_194297_);
            profiler.m_6180_("securitycraft:discover_frame_sections");
            feed.discoverVisibleSections(cameraPos, newFrameFeedViewDistance);
            profiler.m_6182_("securitycraft:bind_frame_target");
            frameTarget.m_83954_(true);
            frameTarget.m_83947_(true);
            mc.f_91042_ = frameTarget;
            profiler.m_7238_();
            try {
                mc.f_91063_.m_109089_(1.0f, 0L, new PoseStack());
            }
            catch (Exception e) {
                PlayerUtils.sendMessageToPlayer((Player)player, Utils.localize(((FrameBlock)((Object)SCContent.FRAME.get())).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:frame.error", new Object[0]), ChatFormatting.RED, true);
                SecurityCraft.LOGGER.error("Frame feed at {} threw an exception while rendering the level. Deactivating clientside rendering for this feed", (Object)be.m_58899_());
                e.printStackTrace();
                feed.markForRemoval();
            }
            frameTarget.m_83970_();
            profiler.m_6180_("securitycraft:apply_frame_frustum");
            Frustum frustum = new Frustum(FrameFeedHandler.getFrustum(mc.f_91060_)).m_194441_(8);
            if (be.shouldRotate() || !feed.hasVisibleSections() || feed.requiresFrustumUpdate()) {
                feed.updateVisibleSections(frustum);
            }
            profiler.m_7238_();
        }
        securityCamera.m_146870_();
        mc.m_91118_(oldCamEntity);
        window.m_166450_(oldWidth);
        window.m_166452_(oldHeight);
        mc.f_91060_.f_194297_.clear();
        mc.f_91060_.f_194297_.addAll((Collection)oldVisibleSections);
        player.m_20343_(oldX, oldY, oldZ);
        player.f_19790_ = player.f_19854_ = oldXO;
        player.f_19791_ = player.f_19855_ = oldYO;
        player.f_19792_ = player.f_19856_ = oldZO;
        player.m_146926_(oldXRot);
        player.f_19860_ = oldXRotO;
        player.m_146922_(oldYRot);
        player.f_19859_ = oldYRotO;
        camera.m_90575_((BlockGetter)level, (Entity)(oldCamEntity == null ? player : oldCamEntity), !mc.f_91066_.m_92176_().m_90612_(), mc.f_91066_.m_92176_().m_90613_(), partialTick);
        camera.f_90562_ = oldEyeHeight;
        camera.f_90563_ = oldEyeHeightO;
        mc.f_91066_.m_92157_(oldCameraType);
        mc.f_91063_.m_172775_(true);
        mc.f_91063_.m_172736_(true);
        mc.f_91063_.m_172779_(false);
        mc.f_91042_ = oldMainRenderTarget;
        mc.m_91385_().m_83947_(true);
        mc.f_91060_.f_109413_ = oldTranslucentTarget;
        mc.f_91060_.f_109414_ = oldItemEntityTarget;
        mc.f_91060_.f_109416_ = oldWeatherTarget;
        mc.f_91060_.f_109418_ = oldTransparencyChain;
        currentlyCapturedCamera = null;
        profiler.m_7238_();
        profiler.m_7238_();
    }

    @SubscribeEvent
    public static void onClientTickPost(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && FrameFeedHandler.hasFeeds()) {
            FRAME_CAMERA_FEEDS.entrySet().removeIf(e -> ((CameraFeed)e.getValue()).shouldBeRemoved());
        }
    }

    public static Map<GlobalPos, CameraFeed> getFeedsToRender(Minecraft mc, double currentTime) {
        double feedsToRender = FRAME_CAMERA_FEEDS.size() + 1;
        double fpsCap = ((Integer)ConfigHandler.CLIENT.frameFeedFpsLimit.get()).intValue();
        double frameInterval = 1.0 / fpsCap;
        double activeFramesPerMcFrame = Mth.m_14165_((double)(fpsCap * feedsToRender / (double)mc.m_260875_()));
        if (fpsCap < 260.0) {
            HashMap<GlobalPos, CameraFeed> activeFrameCameraFeeds = new HashMap<GlobalPos, CameraFeed>();
            for (Map.Entry<GlobalPos, CameraFeed> cameraView : FRAME_CAMERA_FEEDS.entrySet()) {
                double timeBetweenFrames = frameInterval / feedsToRender;
                double lastActiveTime = cameraView.getValue().lastActiveTime().get();
                if (currentTime < lastActiveTime + frameInterval || currentTime < lastFrameRendered + timeBetweenFrames) continue;
                double d = activeFramesPerMcFrame;
                activeFramesPerMcFrame = d - 1.0;
                if (d <= 0.0) continue;
                cameraView.getValue().lastActiveTime().set(currentTime);
                activeFrameCameraFeeds.put(cameraView.getKey(), cameraView.getValue());
            }
            return activeFrameCameraFeeds;
        }
        return FRAME_CAMERA_FEEDS;
    }

    public static void addFrameLink(FrameBlockEntity be, GlobalPos cameraPos) {
        CameraFeed feed = FRAME_CAMERA_FEEDS.computeIfAbsent(cameraPos, FrameFeedHandler::createFeedForCamera);
        feed.linkFrame(be);
    }

    private static CameraFeed createFeedForCamera(GlobalPos cameraPos) {
        SectionPos cameraSectionPos = SectionPos.m_123199_((BlockPos)cameraPos.m_122646_());
        LevelRenderer.RenderChunkInfo startingSection = new LevelRenderer.RenderChunkInfo(CameraViewAreaExtension.rawFetch(cameraSectionPos.m_123170_(), Mth.m_14045_((int)cameraSectionPos.m_123206_(), (int)CameraViewAreaExtension.minSectionY(), (int)(CameraViewAreaExtension.maxSectionY() - 1)), cameraSectionPos.m_123222_(), true), null, 0);
        return new CameraFeed(cameraPos, startingSection);
    }

    public static void removeFrameLink(GlobalPos cameraPos, FrameBlockEntity be) {
        if (FRAME_CAMERA_FEEDS.containsKey(cameraPos)) {
            FRAME_CAMERA_FEEDS.get(cameraPos).unlinkFrame(be);
        }
    }

    public static void removeAllFrameLinks(GlobalPos cameraPos) {
        if (FRAME_CAMERA_FEEDS.containsKey(cameraPos)) {
            FRAME_CAMERA_FEEDS.remove(cameraPos);
        }
    }

    public static boolean isCapturingCamera() {
        return currentlyCapturedCamera != null;
    }

    public static boolean amIBeingCaptured(SecurityCameraBlockEntity be) {
        return FrameFeedHandler.isCapturingCamera() && currentlyCapturedCamera.m_122646_().equals((Object)be.m_58899_());
    }

    public static boolean shouldAddChunk(ChunkPos pos, int renderDistance) {
        for (GlobalPos cameraPos : FRAME_CAMERA_FEEDS.keySet()) {
            if (pos.m_45594_(new ChunkPos(cameraPos.m_122646_())) > renderDistance + 1) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFeeds() {
        return !FRAME_CAMERA_FEEDS.isEmpty();
    }

    public static boolean hasFeed(GlobalPos cameraPos) {
        return FRAME_CAMERA_FEEDS.containsKey(cameraPos);
    }

    public static CameraFeed getFeed(GlobalPos cameraPos) {
        return FRAME_CAMERA_FEEDS.get(cameraPos);
    }

    public static void removeAllFeeds() {
        FRAME_CAMERA_FEEDS.clear();
    }

    public static int getFrameFeedViewDistance(FrameBlockEntity be) {
        int frameSpecificRenderDistance = be == null ? 32 : be.getChunkLoadingDistanceOption();
        return Math.min(frameSpecificRenderDistance, Math.min((Integer)ConfigHandler.CLIENT.frameFeedRenderDistance.get(), Math.min((Integer)ConfigHandler.SERVER.frameFeedViewDistance.get(), Minecraft.m_91087_().f_91066_.m_193772_())));
    }

    private static Frustum getFrustum(LevelRenderer levelRenderer) {
        return levelRenderer.f_109442_ != null ? levelRenderer.f_109442_ : levelRenderer.f_172938_;
    }

    static {
        lastFrameRendered = 0.0;
    }
}

