/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MineRemoteAccessToolItem
extends Item {
    public MineRemoteAccessToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            ClientHandler.displayMRATScreen(player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        BlockPos pos;
        Level level = ctx.m_43725_();
        if (level.m_8055_(pos = ctx.m_8083_()).m_60734_() instanceof IExplosive) {
            Player player = ctx.m_43723_();
            if (!MineRemoteAccessToolItem.isMineAdded(stack, pos)) {
                IOwnable ownable;
                int nextSlot = MineRemoteAccessToolItem.getNextAvailableSlot(stack);
                if (nextSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:mrat.noSlots", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof IOwnable && !(ownable = (IOwnable)blockEntity).isOwnedBy((Entity)player)) {
                    if (level.f_46443_) {
                        ClientHandler.displayMRATScreen(stack);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stack.m_41783_() == null) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128385_("mine" + nextSlot, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:mrat.bound", Utils.getFormattedCoordinates(pos)), ChatFormatting.GREEN);
                return InteractionResult.SUCCESS;
            }
            MineRemoteAccessToolItem.removeMine(stack, pos);
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:mrat.unbound", Utils.getFormattedCoordinates(pos)), ChatFormatting.RED);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords = stack.m_41783_().m_128465_("mine" + i);
            if (coords.length != 3) {
                list.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "---")));
                continue;
            }
            list.add((Component)Utils.localize("tooltip.securitycraft:mine", i, Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2]))).m_6270_(Utils.GRAY_STYLE));
        }
    }

    public static boolean hasMineAdded(CompoundTag tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 6; ++i) {
            if (!tag.m_128441_("mine" + i)) continue;
            return true;
        }
        return false;
    }

    public static void removeMine(ItemStack stack, BlockPos pos) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords = stack.m_41783_().m_128465_("mine" + i);
            if (coords.length != 3 || coords[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            stack.m_41783_().m_128473_("mine" + i);
            return;
        }
    }

    public static boolean isMineAdded(ItemStack stack, BlockPos pos) {
        if (stack.m_41783_() == null) {
            return false;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords = stack.m_41783_().m_128465_("mine" + i);
            if (coords.length != 3 || coords[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            return true;
        }
        return false;
    }

    public static int getNextAvailableSlot(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 1;
        }
        for (int i = 1; i <= 6; ++i) {
            if (stack.m_41783_().m_128465_("mine" + i).length == 3) continue;
            return i;
        }
        return 0;
    }
}

