/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GameRenderer.class}, priority=1100)
public class GameRendererMixin {
    @Shadow
    @Final
    Minecraft f_109059_;

    @ModifyConstant(method={"tickFov"}, constant={@Constant(floatValue=1.0f)})
    private float securitycraft$modifyInitialFValue(float f) {
        Entity entity = this.f_109059_.f_91075_;
        if (entity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)entity;
            return cam.getZoomAmount();
        }
        return f;
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Options;hideGui:Z", opcode=180)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void securitycraft$renderCameraTint(float partialTicks, long nanoTime, boolean renderLevel, CallbackInfo ci, int i, int j, Window window, Matrix4f matrix4f, PoseStack posestack, PoseStack posestack1) {
        if (this.f_109059_.f_91075_ instanceof SecurityCamera) {
            DyeableLeatherItem item;
            ClientLevel level = this.f_109059_.f_91073_;
            BlockPos pos = this.f_109059_.f_91075_.m_20183_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
                return;
            }
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
            ItemStack lens = be.getLensContainer().m_8020_(0);
            Item item2 = lens.m_41720_();
            if (item2 instanceof DyeableLeatherItem && (item = (DyeableLeatherItem)item2).m_41113_(lens)) {
                Gui.m_93172_((PoseStack)posestack1, (int)0, (int)0, (int)window.m_85445_(), (int)window.m_85446_(), (int)(item.m_41121_(lens) + (be.getOpacity() << 24)));
            }
        }
    }

    @ModifyVariable(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;lerp(FFF)F"), ordinal=1)
    private float securitycraft$disableFeedDistortion(float original) {
        return FrameFeedHandler.isCapturingCamera() ? 0.0f : original;
    }

    @Inject(method={"pick"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$preventFramePick(float partialTicks, CallbackInfo ci) {
        if (FrameFeedHandler.isCapturingCamera()) {
            ci.cancel();
        }
    }
}

