/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Shadow
    private ChunkRenderDispatcher f_109436_;
    @Shadow
    private ClientLevel f_109465_;

    @Inject(method={"setupRender"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onSetupRender(Camera camera, Frustum frustum, boolean hasCapturedFrustum, boolean isSpectator, CallbackInfo ci) {
        if (FrameFeedHandler.isCapturingCamera()) {
            ci.cancel();
        }
    }

    @Inject(method={"allChanged"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/atomic/AtomicReference;set(Ljava/lang/Object;)V")})
    private void securitycraft$onAllChanged(CallbackInfo ci) {
        CameraViewAreaExtension.allChanged(this.f_109436_, (Level)this.f_109465_);
    }

    @Inject(method={"isChunkCompiled"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onIsSectionCompiled(BlockPos pos, CallbackInfoReturnable<Boolean> ci) {
        SectionPos sectionPos;
        ChunkRenderDispatcher.RenderChunk renderSection;
        if (FrameFeedHandler.isCapturingCamera() && (renderSection = CameraViewAreaExtension.rawFetch((sectionPos = SectionPos.m_123199_((BlockPos)pos)).m_123170_(), sectionPos.m_123206_(), sectionPos.m_123222_(), false)) != null && renderSection.f_112784_.get() != ChunkRenderDispatcher.CompiledChunk.f_112748_) {
            ci.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"), ordinal=1)
    private float securitycraft$modifyFogRenderDistance(float original) {
        if (FrameFeedHandler.isCapturingCamera()) {
            return FrameFeedHandler.getFrameFeedViewDistance(null) * 16;
        }
        return original;
    }
}

