/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.util.TriConsumer;

public class RemoteControlMine {
    private BlockPos pos;
    private Action action;

    public RemoteControlMine() {
    }

    public RemoteControlMine(BlockPos pos, Action action) {
        this.pos = pos;
        this.action = action;
    }

    public RemoteControlMine(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.action = (Action)buf.m_130066_(Action.class);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.action);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        Block block;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.f_19853_;
        BlockState state = level.m_8055_(this.pos);
        if (!player.m_5833_() && (block = state.m_60734_()) instanceof IExplosive) {
            IOwnable be;
            IExplosive explosive = (IExplosive)block;
            block = level.m_7702_(this.pos);
            if (block instanceof IOwnable && (be = (IOwnable)block).isOwnedBy((Entity)player)) {
                this.action.act(explosive, level, this.pos);
            }
        }
    }

    public static enum Action {
        ACTIVATE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::activateMine)),
        DEFUSE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::defuseMine)),
        DETONATE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::explode));

        private final TriConsumer<IExplosive, Level, BlockPos> action;

        private Action(TriConsumer<IExplosive, Level, BlockPos> action) {
            this.action = action;
        }

        public void act(IExplosive explosive, Level level, BlockPos pos) {
            this.action.accept((Object)explosive, (Object)level, (Object)pos);
        }
    }
}

