/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetPasscode {
    private BlockPos pos;
    private int entityId;
    private String passcode;

    public SetPasscode() {
    }

    public SetPasscode(BlockPos pos, String code) {
        this.pos = pos;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(code);
    }

    public SetPasscode(int entityId, String code) {
        this.entityId = entityId;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(code);
    }

    public SetPasscode(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.m_130135_();
        } else {
            this.entityId = buf.m_130242_();
        }
        this.passcode = buf.m_130136_(0x1FFFFFFF);
    }

    public void encode(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.m_130064_(this.pos);
        } else {
            buf.m_130130_(this.entityId);
        }
        buf.m_130070_(this.passcode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        IOwnable ownable;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.f_19853_;
        IPasscodeProtected passcodeProtected = this.getPasscodeProtected(level);
        if (!(player.m_5833_() || passcodeProtected == null || passcodeProtected instanceof IOwnable && !(ownable = (IOwnable)((Object)passcodeProtected)).isOwnedBy((Entity)player))) {
            passcodeProtected.hashAndSetPasscode(this.passcode, arg_0 -> this.lambda$handle$0(passcodeProtected, level, (Player)player, arg_0));
            passcodeProtected.setPasscodeInAdjacentBlock(this.passcode);
        }
    }

    private IPasscodeProtected getPasscodeProtected(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)blockEntity;
                return pp;
            }
        } else {
            Entity entity = level.m_6815_(this.entityId);
            if (entity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)entity;
                return pp;
            }
        }
        return null;
    }

    private /* synthetic */ void lambda$handle$0(IPasscodeProtected passcodeProtected, Level level, Player player, byte[] b) {
        passcodeProtected.openPasscodeGUI(level, this.pos, player);
    }
}

