/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncKeycardSettings {
    private BlockPos pos;
    private int signature;
    private boolean[] acceptedLevels;
    private boolean link;
    private String usableBy;

    public SyncKeycardSettings() {
    }

    public SyncKeycardSettings(BlockPos pos, boolean[] acceptedLevels, int signature, boolean link, String usableBy) {
        this.pos = pos;
        this.acceptedLevels = acceptedLevels;
        this.signature = signature;
        this.link = link;
        this.usableBy = usableBy;
    }

    public SyncKeycardSettings(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.signature = buf.m_130242_();
        this.link = buf.readBoolean();
        this.acceptedLevels = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            this.acceptedLevels[i] = buf.readBoolean();
        }
        this.usableBy = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130130_(this.signature);
        buf.writeBoolean(this.link);
        for (int i = 0; i < 5; ++i) {
            buf.writeBoolean(this.acceptedLevels[i]);
        }
        buf.m_130070_(this.usableBy);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        KeycardReaderBlockEntity be;
        boolean isOwner;
        BlockEntity blockEntity;
        ServerPlayer player = ctx.get().getSender();
        if (!player.m_5833_() && (blockEntity = player.f_19853_.m_7702_(this.pos)) instanceof KeycardReaderBlockEntity && ((isOwner = (be = (KeycardReaderBlockEntity)blockEntity).isOwnedBy((Entity)player)) || be.isAllowed((Entity)player))) {
            AbstractContainerMenu abstractContainerMenu;
            if (isOwner) {
                be.setAcceptedLevels(this.acceptedLevels);
                be.setSignature(this.signature);
            }
            if (this.link && (abstractContainerMenu = player.f_36096_) instanceof KeycardReaderMenu) {
                KeycardReaderMenu keycardReaderContainer = (KeycardReaderMenu)abstractContainerMenu;
                keycardReaderContainer.link(this.usableBy);
            }
        }
    }
}

