/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncRiftStabilizer {
    private BlockPos pos;
    private RiftStabilizerBlockEntity.TeleportationType teleportationType;
    private boolean allowed;

    public SyncRiftStabilizer() {
    }

    public SyncRiftStabilizer(BlockPos pos, RiftStabilizerBlockEntity.TeleportationType teleportationType, boolean allowed) {
        this.pos = pos;
        this.teleportationType = teleportationType;
        this.allowed = allowed;
    }

    public SyncRiftStabilizer(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.teleportationType = (RiftStabilizerBlockEntity.TeleportationType)buf.m_130066_(RiftStabilizerBlockEntity.TeleportationType.class);
        this.allowed = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.teleportationType);
        buf.writeBoolean(this.allowed);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (this.teleportationType != null) {
            RiftStabilizerBlockEntity be;
            BlockEntity blockEntity;
            ServerPlayer player = ctx.get().getSender();
            Level level = player.f_19853_;
            if (!player.m_5833_() && (blockEntity = level.m_7702_(this.pos)) instanceof RiftStabilizerBlockEntity && (be = (RiftStabilizerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
                BlockState state = level.m_8055_(this.pos);
                be.setFilter(this.teleportationType, this.allowed);
                level.m_7260_(this.pos, state, state, 2);
            }
        }
    }
}

