/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncSSSSettingsOnServer {
    private BlockPos pos;
    private DataType dataType;
    private BlockPos posToRemove;

    public SyncSSSSettingsOnServer() {
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType) {
        this(pos, dataType, null);
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType, BlockPos posToRemove) {
        this.pos = pos;
        this.dataType = dataType;
        this.posToRemove = posToRemove;
    }

    public SyncSSSSettingsOnServer(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.dataType = (DataType)buf.m_130066_(DataType.class);
        if (this.dataType == DataType.REMOVE_POS) {
            this.posToRemove = buf.m_130135_();
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.dataType);
        if (this.dataType == DataType.REMOVE_POS) {
            buf.m_130064_(this.posToRemove);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        SonicSecuritySystemBlockEntity sss;
        BlockEntity blockEntity;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.f_19853_;
        if (!player.m_5833_() && (blockEntity = level.m_7702_(this.pos)) instanceof SonicSecuritySystemBlockEntity && (sss = (SonicSecuritySystemBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            switch (this.dataType) {
                case POWER_ON: {
                    sss.setActive(true);
                    break;
                }
                case POWER_OFF: {
                    sss.setActive(false);
                    if (!sss.isRecording()) break;
                    sss.setRecording(false);
                    break;
                }
                case SOUND_ON: {
                    sss.setPings(true);
                    break;
                }
                case SOUND_OFF: {
                    sss.setPings(false);
                    break;
                }
                case RECORDING_ON: {
                    sss.setRecording(true);
                    break;
                }
                case RECORDING_OFF: {
                    sss.setRecording(false);
                    break;
                }
                case CLEAR_NOTES: {
                    sss.clearNotes();
                    break;
                }
                case REMOVE_POS: {
                    sss.delink(this.posToRemove, false);
                    break;
                }
                case INVERT_FUNCTIONALITY: {
                    sss.setDisableBlocksWhenTuneIsPlayed(!sss.disablesBlocksWhenTuneIsPlayed());
                }
            }
            sss.m_6596_();
        }
    }

    public static enum DataType {
        POWER_ON,
        POWER_OFF,
        SOUND_ON,
        SOUND_OFF,
        RECORDING_ON,
        RECORDING_OFF,
        CLEAR_NOTES,
        REMOVE_POS,
        INVERT_FUNCTIONALITY;

    }
}

