/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncSecureRedstoneInterface {
    private BlockPos pos;
    private boolean sender;
    private boolean protectedSignal;
    private int frequency;
    private boolean sendExactPower;
    private boolean receiveInvertedPower;
    private int senderRange;
    private boolean highlightConnections;

    public SyncSecureRedstoneInterface(BlockPos pos, boolean sender, boolean protectedSignal, int frequency, boolean sendExactPower, boolean receiveInvertedPower, int senderRange, boolean highlightConnections) {
        this.pos = pos;
        this.sender = sender;
        this.protectedSignal = protectedSignal;
        this.frequency = frequency;
        this.sendExactPower = sendExactPower;
        this.receiveInvertedPower = receiveInvertedPower;
        this.senderRange = senderRange;
        this.highlightConnections = highlightConnections;
    }

    public SyncSecureRedstoneInterface(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.sender = buf.readBoolean();
        this.protectedSignal = buf.readBoolean();
        this.frequency = buf.m_130242_();
        this.sendExactPower = buf.readBoolean();
        this.receiveInvertedPower = buf.readBoolean();
        this.senderRange = buf.m_130242_();
        this.highlightConnections = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.sender);
        buf.writeBoolean(this.protectedSignal);
        buf.m_130130_(this.frequency);
        buf.writeBoolean(this.sendExactPower);
        buf.writeBoolean(this.receiveInvertedPower);
        buf.m_130130_(this.senderRange);
        buf.writeBoolean(this.highlightConnections);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        SecureRedstoneInterfaceBlockEntity be;
        BlockEntity blockEntity;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.f_19853_;
        if (!player.m_5833_() && (blockEntity = level.m_7702_(this.pos)) instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (this.sender != be.isSender()) {
                be.setSender(this.sender);
            }
            if (this.protectedSignal != be.isProtectedSignal()) {
                be.setProtectedSignal(this.protectedSignal);
            }
            if (this.frequency != be.getFrequency()) {
                be.setFrequency(this.frequency);
            }
            if (this.sendExactPower != be.sendsExactPower()) {
                be.setSendExactPower(this.sendExactPower);
            }
            if (this.receiveInvertedPower != be.receivesInvertedPower()) {
                be.setReceiveInvertedPower(this.receiveInvertedPower);
            }
            if (this.senderRange != be.getSenderRange()) {
                be.setSenderRange(this.senderRange);
            }
            be.setHighlightConnections(this.highlightConnections);
        }
    }
}

