/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncTrophySystem {
    private BlockPos pos;
    private ResourceLocation projectileTypeLocation;
    private boolean allowed;

    public SyncTrophySystem() {
    }

    public SyncTrophySystem(BlockPos pos, EntityType<?> projectileType, boolean allowed) {
        this.pos = pos;
        this.projectileTypeLocation = Utils.getRegistryName(projectileType);
        this.allowed = allowed;
    }

    public SyncTrophySystem(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.projectileTypeLocation = buf.m_130281_();
        this.allowed = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.projectileTypeLocation);
        buf.writeBoolean(this.allowed);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        EntityType projectileType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.projectileTypeLocation);
        if (projectileType != null) {
            TrophySystemBlockEntity be;
            BlockEntity blockEntity;
            ServerPlayer player = ctx.get().getSender();
            Level level = player.f_19853_;
            if (!player.m_5833_() && (blockEntity = level.m_7702_(this.pos)) instanceof TrophySystemBlockEntity && (be = (TrophySystemBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
                BlockState state = level.m_8055_(this.pos);
                be.setFilter(projectileType, this.allowed);
                level.m_7260_(this.pos, state, state, 2);
            }
        }
    }
}

