/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.entity.camera.CameraFeed;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class FrameBlockEntityRenderer
implements BlockEntityRenderer<FrameBlockEntity> {
    private static final ResourceLocation CAMERA_NOT_FOUND = new ResourceLocation("securitycraft", "textures/entity/frame/camera_not_found.png");
    private static final ResourceLocation INACTIVE = new ResourceLocation("securitycraft", "textures/entity/frame/inactive.png");
    private static final ResourceLocation NO_REDSTONE_SIGNAL = new ResourceLocation("securitycraft", "textures/entity/frame/no_redstone_signal.png");
    private static final Material NOISE_BACKGROUND = new Material(InventoryMenu.f_39692_, new ResourceLocation("securitycraft", "entity/frame/noise_background"));
    private static final ResourceLocation SELECT_CAMERA = new ResourceLocation("securitycraft", "textures/entity/frame/select_camera.png");
    private static final ResourceLocation WHITE = new ResourceLocation("securitycraft", "textures/entity/frame/white.png");
    private static final RenderType CAMERA_IN_FRAME_RENDER_TYPE = RenderType.m_173215_((String)"frame_shader", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(ClientHandler::getFrameFeedShader)).m_110691_(false));

    public FrameBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FrameBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Vector4f innerVertices;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (be.isDisabled() || !be.isOwnedBy((Entity)player) && !be.isAllowed((Entity)player) || be.getCameraPositions().isEmpty()) {
            return;
        }
        Level level = be.m_58904_();
        BlockState state = be.m_58900_();
        GlobalPos cameraPos = be.getCurrentCamera();
        Direction direction = (Direction)state.m_61143_((Property)FrameBlock.FACING);
        Vec3i normal = direction.m_122436_();
        float margin = 0.0625f;
        Vector4f outerVertices = switch (direction) {
            case Direction.NORTH -> {
                innerVertices = new Vector4f(0.0625f, 0.9375f, 0.05f, 0.05f);
                yield new Vector4f(0.0625f, 0.9375f, 0.045f, 0.045f);
            }
            case Direction.SOUTH -> {
                innerVertices = new Vector4f(0.9375f, 0.0625f, 0.95f, 0.95f);
                yield new Vector4f(0.9375f, 0.0625f, 0.955f, 0.955f);
            }
            case Direction.WEST -> {
                innerVertices = new Vector4f(0.05f, 0.05f, 0.9375f, 0.0625f);
                yield new Vector4f(0.045f, 0.045f, 0.9375f, 0.0625f);
            }
            case Direction.EAST -> {
                innerVertices = new Vector4f(0.95f, 0.95f, 0.0625f, 0.9375f);
                yield new Vector4f(0.955f, 0.955f, 0.0625f, 0.9375f);
            }
            default -> {
                innerVertices = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
                yield new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
            }
        };
        if (cameraPos == null) {
            this.renderSolidTexture(pose, buffer, SELECT_CAMERA, innerVertices, packedLight, normal, 0.0625f);
        } else if (be.redstoneSignalDisabled()) {
            this.renderNoise(pose, buffer, innerVertices, packedLight, normal, 0.0625f);
            this.renderCutoutTexture(pose, buffer, NO_REDSTONE_SIGNAL, outerVertices, packedLight, normal, 0.0625f);
        } else if (!be.hasClientInteracted()) {
            this.renderNoise(pose, buffer, innerVertices, packedLight, normal, 0.0625f);
            this.renderCutoutTexture(pose, buffer, INACTIVE, outerVertices, packedLight, normal, 0.0625f);
        } else {
            BlockEntity blockEntity;
            CameraFeed feed = FrameFeedHandler.getFeed(cameraPos);
            if (!(feed != null && feed.isFrameLinked(be) && level.m_46749_(cameraPos.m_122646_()) && (blockEntity = level.m_7702_(cameraPos.m_122646_())) instanceof SecurityCameraBlockEntity)) {
                this.renderSolidTexture(pose, buffer, CAMERA_NOT_FOUND, innerVertices, packedLight, normal, 0.0625f);
            } else {
                SecurityCameraBlockEntity cameraBlockEntity = (SecurityCameraBlockEntity)blockEntity;
                if (!FrameFeedHandler.isCapturingCamera()) {
                    DyeableLeatherItem item;
                    RenderTarget target = feed.renderTarget();
                    ShaderInstance shader = ClientHandler.getFrameFeedShader();
                    float xStart = innerVertices.x;
                    float xEnd = innerVertices.y;
                    float zStart = innerVertices.z;
                    float zEnd = innerVertices.w;
                    shader.m_173350_("DiffuseSampler", (Object)target.m_83975_());
                    if (shader.f_173308_ != null) {
                        shader.f_173308_.m_5679_(pose.m_85850_().m_252922_());
                    }
                    if (shader.f_173309_ != null) {
                        shader.f_173309_.m_5679_(mc.f_91063_.m_253088_(90.0));
                    }
                    shader.m_173363_();
                    Matrix4f lastPose = pose.m_85850_().m_252922_();
                    VertexConsumer bufferBuilder = buffer.m_6299_(CAMERA_IN_FRAME_RENDER_TYPE);
                    bufferBuilder.m_252986_(lastPose, xStart, 0.0625f, zStart).m_7421_(1.0f, 0.0f).m_193479_(0xFFFFFF).m_5752_();
                    bufferBuilder.m_252986_(lastPose, xStart, 0.9375f, zStart).m_7421_(1.0f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
                    bufferBuilder.m_252986_(lastPose, xEnd, 0.9375f, zEnd).m_7421_(0.0f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
                    bufferBuilder.m_252986_(lastPose, xEnd, 0.0625f, zEnd).m_7421_(0.0f, 0.0f).m_193479_(0xFFFFFF).m_5752_();
                    shader.m_173362_();
                    if (buffer instanceof MultiBufferSource.BufferSource) {
                        MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
                        bufferSource.m_109911_();
                    } else {
                        mc.f_91060_.f_109464_.m_110104_().m_109911_();
                    }
                    ItemStack lens = cameraBlockEntity.getLensContainer().m_8020_(0);
                    Item item2 = lens.m_41720_();
                    if (item2 instanceof DyeableLeatherItem && (item = (DyeableLeatherItem)item2).m_41113_(lens)) {
                        this.renderOverlay(pose, buffer, innerVertices, item.m_41121_(lens) + (cameraBlockEntity.getOpacity() << 24), packedLight, normal, 0.0625f);
                    }
                }
            }
        }
    }

    private void renderNoise(PoseStack pose, MultiBufferSource buffer, Vector4f vertices, int packedLight, Vec3i normal, float margin) {
        TextureAtlasSprite sprite = NOISE_BACKGROUND.m_119204_();
        this.renderTexture(pose, buffer, buffer.m_6299_(Sheets.m_110789_()), vertices, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), 0xFFFFFF, packedLight, normal, margin);
    }

    private void renderSolidTexture(PoseStack pose, MultiBufferSource buffer, ResourceLocation texture, Vector4f vertices, int packedLight, Vec3i normal, float margin) {
        this.renderTexture(pose, buffer, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)texture)), vertices, 0.0f, 0.0f, 1.0f, 1.0f, 0xFFFFFF, packedLight, normal, margin);
    }

    private void renderCutoutTexture(PoseStack pose, MultiBufferSource buffer, ResourceLocation texture, Vector4f vertices, int packedLight, Vec3i normal, float margin) {
        this.renderTexture(pose, buffer, buffer.m_6299_(RenderType.m_110452_((ResourceLocation)texture)), vertices, 0.0f, 0.0f, 1.0f, 1.0f, 0xFFFFFF, packedLight, normal, margin);
    }

    private void renderOverlay(PoseStack pose, MultiBufferSource buffer, Vector4f vertices, int color, int packedLight, Vec3i normal, float margin) {
        this.renderTexture(pose, buffer, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)WHITE)), vertices, 0.0f, 0.0f, 1.0f, 1.0f, color, packedLight, normal, margin);
    }

    private void renderTexture(PoseStack pose, MultiBufferSource buffer, VertexConsumer bufferBuilder, Vector4f vertices, float u0, float v0, float u1, float v1, int color, int packedLight, Vec3i normal, float margin) {
        Matrix4f lastPose = pose.m_85850_().m_252922_();
        float xStart = vertices.x;
        float xEnd = vertices.y;
        float zStart = vertices.z;
        float zEnd = vertices.w;
        int nx = normal.m_123341_();
        int ny = normal.m_123342_();
        int nz = normal.m_123343_();
        bufferBuilder.m_252986_(lastPose, xStart, margin, zStart).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)nx, (float)ny, (float)nz).m_5752_();
        bufferBuilder.m_252986_(lastPose, xStart, 1.0f - margin, zStart).m_193479_(color).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)nx, (float)ny, (float)nz).m_5752_();
        bufferBuilder.m_252986_(lastPose, xEnd, 1.0f - margin, zEnd).m_193479_(color).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)nx, (float)ny, (float)nz).m_5752_();
        bufferBuilder.m_252986_(lastPose, xEnd, margin, zEnd).m_193479_(color).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)nx, (float)ny, (float)nz).m_5752_();
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
            bufferSource.m_109911_();
        }
    }
}

