/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.CheckBriefcasePasscode;
import net.geforcemods.securitycraft.network.server.SetBriefcasePasscodeAndOwner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BriefcasePasscodeScreen
extends Screen {
    public static final String UP_ARROW = "\u2191";
    public static final String RIGHT_ARROW = "\u2192";
    public static final String DOWN_ARROW = "\u2193";
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final boolean isSetup;
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private EditBox[] keycodeTextboxes = new EditBox[4];
    private int[] digits = new int[]{0, 0, 0, 0};

    public BriefcasePasscodeScreen(Component title, boolean isSetup) {
        super(title);
        this.isSetup = isSetup;
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        for (int i = 0; i < 4; ++i) {
            int id = i;
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 40 + i * 20, this.f_96544_ / 2 - 52, 20, 20, (Component)Component.m_237113_((String)UP_ARROW), b -> this.keycodeButtonClicked(id), Button.f_252438_));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 40 + i * 20, this.f_96544_ / 2, 20, 20, (Component)Component.m_237113_((String)DOWN_ARROW), b -> this.keycodeButtonClicked(4 + id), Button.f_252438_));
            this.keycodeTextboxes[i] = (EditBox)this.m_169394_((Renderable)new EditBox(this.f_96547_, this.f_96543_ / 2 - 37 + i * 20, this.f_96544_ / 2 - 22, 14, 12, (Component)Component.m_237119_()));
            this.keycodeTextboxes[i].m_94199_(1);
            this.keycodeTextboxes[i].m_94144_("0");
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 42, this.f_96544_ / 2 - 26, 20, 20, (Component)Component.m_237113_((String)RIGHT_ARROW), this::continueButtonClicked, Button.f_252438_));
    }

    public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(pose);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        BriefcasePasscodeScreen.m_93228_((PoseStack)pose, (int)this.leftPos, (int)this.topPos, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight);
        super.m_86412_(pose, mouseX, mouseY, partialTick);
        this.f_96547_.m_92889_(pose, this.f_96539_, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(this.topPos + 6), 0x404040);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private void continueButtonClicked(Button button) {
        ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.BRIEFCASE.get());
        if (!briefcase.m_41619_()) {
            String passcode = "" + this.digits[0] + this.digits[1] + this.digits[2] + this.digits[3];
            if (this.isSetup) {
                SecurityCraft.CHANNEL.sendToServer((Object)new SetBriefcasePasscodeAndOwner(passcode));
                ClientHandler.displayBriefcasePasscodeScreen(briefcase.m_41786_());
            } else {
                SecurityCraft.CHANNEL.sendToServer((Object)new CheckBriefcasePasscode(passcode));
            }
        }
    }

    private void keycodeButtonClicked(int id) {
        int n;
        int index = id % 4;
        if (id > 3) {
            int n2 = index;
            n = this.digits[n2] = this.digits[n2] - 1;
        } else {
            int n3 = index;
            n = this.digits[n3] = this.digits[n3] + 1;
        }
        this.digits[index] = Math.floorMod(n, 10);
        this.keycodeTextboxes[index].m_94144_(String.valueOf(this.digits[index]));
    }
}

