/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.screen.components.SmallButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class CameraSelectScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final List<Pair<GlobalPos, String>> cameras;
    protected final boolean readOnly;
    private final Button[] cameraButtons = new Button[10];
    private final CameraRedstoneModuleState[] redstoneModuleStates = new CameraRedstoneModuleState[10];
    private int xSize = 176;
    private int ySize = 166;
    private int leftPos;
    private int topPos;
    private int page;

    public CameraSelectScreen(List<Pair<GlobalPos, String>> cameras, boolean readOnly) {
        this(cameras, readOnly, 1);
    }

    public CameraSelectScreen(List<Pair<GlobalPos, String>> cameras, boolean readOnly, int page) {
        super((Component)Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]));
        this.cameras = cameras;
        this.readOnly = readOnly;
        this.page = page;
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.xSize) / 2;
        this.topPos = (this.f_96544_ - this.ySize) / 2;
        Button prevPageButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 25, this.f_96544_ / 2 + 57, 20, 20, (Component)Component.m_237113_((String)"<"), b -> {
            --this.page;
            this.m_232761_();
        }, Button.f_252438_));
        Button nextPageButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ / 2 + 57, 20, 20, (Component)Component.m_237113_((String)">"), b -> {
            ++this.page;
            this.m_232761_();
        }, Button.f_252438_));
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (int i = 0; i < 10; ++i) {
            int buttonId = i + 1;
            int camID = buttonId + (this.page - 1) * 10;
            int x = this.leftPos + 18 + i % 5 * 30;
            int y = this.topPos + 30 + i / 5 * 55;
            int aboveCameraButton = y - 8;
            Pair<GlobalPos, String> pair = this.cameras.get(camID - 1);
            GlobalPos view = (GlobalPos)pair.getLeft();
            Button cameraButton = (Button)this.m_142416_((GuiEventListener)new Button(x, y, 20, 20, (Component)Component.m_237119_(), button -> this.cameraButtonClicked(button, camID), Button.f_252438_));
            if (!this.readOnly) {
                ((SmallButton)this.m_142416_((GuiEventListener)SmallButton.createWithX((int)(x + 19), (int)aboveCameraButton, (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$3(int net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((CameraSelectScreen)this, (int)camID)))).f_93623_ = view != null;
            }
            this.cameraButtons[i] = cameraButton;
            cameraButton.m_93666_((Component)cameraButton.m_6035_().m_6879_().m_7220_((Component)Component.m_237113_((String)("" + camID))));
            this.redstoneModuleStates[i] = null;
            if (view != null) {
                SecurityCameraBlockEntity camera;
                BlockPos pos = view.m_122646_();
                BlockEntity blockEntity = level.m_7702_(pos);
                SecurityCameraBlockEntity cameraBe = blockEntity instanceof SecurityCameraBlockEntity ? (camera = (SecurityCameraBlockEntity)blockEntity) : null;
                String cameraName = (String)pair.getRight();
                if (cameraBe != null) {
                    BlockState state = level.m_8055_(pos);
                    if (cameraBe.isDisabled() || cameraBe.isShutDown()) {
                        cameraButton.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
                        cameraButton.f_93623_ = false;
                    } else if (cameraName != null && cameraBe.m_8077_()) {
                        cameraName = cameraBe.m_7770_().getString();
                    }
                    this.redstoneModuleStates[i] = state.m_60746_((BlockGetter)level, pos, (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) == 0 ? (!cameraBe.isModuleEnabled(ModuleType.REDSTONE) ? CameraRedstoneModuleState.NOT_INSTALLED : CameraRedstoneModuleState.DEACTIVATED) : CameraRedstoneModuleState.ACTIVATED;
                }
                if (cameraButton.f_93623_ && cameraName != null) {
                    cameraButton.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:monitor.cameraName", cameraName)));
                }
                if (!player.m_7500_()) continue;
                Button tpButton = (Button)this.m_142416_((GuiEventListener)SmallButton.create(x, aboveCameraButton, (Component)Component.m_237119_(), b -> {
                    player.f_108617_.m_246979_(String.format("execute in %s run tp %s %s %s", view.m_122640_().m_135782_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
                    this.f_96541_.m_91152_(null);
                }));
                tpButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"chat.coordinates.tooltip")));
                continue;
            }
            cameraButton.f_93623_ = false;
        }
        prevPageButton.f_93623_ = this.page != 1;
        nextPageButton.f_93623_ = this.page != 3;
    }

    public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        CameraSelectScreen.m_93228_((PoseStack)pose, (int)this.leftPos, (int)this.topPos, (int)0, (int)0, (int)this.xSize, (int)this.ySize);
        super.m_86412_(pose, mouseX, mouseY, partialTicks);
        for (int i = 0; i < 10; ++i) {
            Button button = this.cameraButtons[i];
            CameraRedstoneModuleState redstoneModuleState = this.redstoneModuleStates[i];
            if (redstoneModuleState == null) continue;
            redstoneModuleState.render(pose, button.m_252754_() + 4, button.m_252907_() + 25);
        }
        this.f_96547_.m_92889_(pose, this.f_96539_, (float)(this.leftPos + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(this.topPos + 6), 0x404040);
    }

    private void cameraButtonClicked(Button button, int camID) {
        Pair<GlobalPos, String> camera = this.cameras.get(camID - 1);
        if (camera != null) {
            SecurityCameraBlockEntity cameraEntity;
            GlobalPos cameraPos = (GlobalPos)camera.getLeft();
            BlockEntity blockEntity = this.f_96541_.f_91073_.m_7702_(cameraPos.m_122646_());
            if (blockEntity instanceof SecurityCameraBlockEntity && ((cameraEntity = (SecurityCameraBlockEntity)blockEntity).isDisabled() || cameraEntity.isShutDown())) {
                button.f_93623_ = false;
                return;
            }
            this.viewCamera(cameraPos);
        }
    }

    protected void viewCamera(GlobalPos cameraPos) {
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    private void unbindButtonClicked(Button button, int camID) {
        Pair<GlobalPos, String> camera = this.cameras.get(camID - 1);
        if (camera != null) {
            int i = (camID - 1) % 10;
            Button cameraButton = this.cameraButtons[i];
            this.unbindCamera(camID);
            button.f_93623_ = false;
            cameraButton.f_93623_ = false;
            cameraButton.m_257544_(null);
            this.redstoneModuleStates[i] = null;
        }
    }

    protected void unbindCamera(int camID) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private /* synthetic */ void lambda$init$3(int camID, Button button) {
        this.unbindButtonClicked(button, camID);
    }
}

